package fireControlSystem.processes;

import java.util.*;

import javax.swing.JOptionPane;

import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

public class Keyboard extends javax.swing.JFrame implements CSProcess {
    int counter = 1;
    public SystemState newState;
    public Alternative alt;
    public class CSP implements CSProcess {
		// Action KeyboardCycle
		private void keyboardCycle(SystemState state) {
		    availableButtons(state);

		    //writeOn_btnPressed (new Integer(18));
		    
		    Guard[] guards = new Guard[]{systemState, btnPressed};
		    alt = new Alternative(guards);

		    final int SYSTEM_STATE = 0;
		    final int BT_PRESSED = 1;
		    
		    SetOfType areas = new SetOfType();
		    
//TRECHO ABAIXO ACRESCENTADO POR MIM
		    //if (counter == 1) {
		    //SystemState new2State = (SystemState) systemState.read();
		    //int key2 = ((Integer)(btnPressed.read())).intValue();
		    //SystemState state2 = new SystemState (SystemState.FIRE_SYS);
		    //syncChannel(from_switchOn[KEYBOARD_SYNC_ID.intValue()],to_switchOn, null, state2);
		    //syncChannel(from_switchOn[KEYBOARD_SYNC_ID.intValue()],to_switchOn, null, state);
		    
		    //keyboardCycle (newState);
		    //}
		    counter++;
//TRECHO ACIMA ACRESCENTADO POR MIM
		    
		    switch(alt.select()) {
		        case SYSTEM_STATE: 
		            /*SystemState*/ newState = (SystemState)systemState.read();
		            System.out.println ("<><><><><><><>Agora newState vale: " + newState.getValue());
		            System.out.println ("______ATENO_____CDIGO HASH DE systemState: " + systemState.hashCode());
		            
		            //syncChannel(from_switchOn[KEYBOARD_SYNC_ID.intValue()],to_switchOn, null, state);		            
		            
		            keyboardCycle(newState);
		            
		            //syncChannel(from_switchOn[KEYBOARD_SYNC_ID.intValue()],to_switchOn, null, state);

		            break;
		        case BT_PRESSED:
		            int key = ((Integer)(btnPressed.read())).intValue();
		            switch (key) {
		                case DETECTION_0 :
		                    syncChannel(from_detection[KEYBOARD_SYNC_ID.intValue()],to_detection, new ZoneId(ZoneId.Z_0), state);
		                    break;
		                case DETECTION_1 :
		                    syncChannel(from_detection[KEYBOARD_SYNC_ID.intValue()],to_detection, new ZoneId(ZoneId.Z_1), state);
		                    break;
		                case DETECTION_2 :
		                    syncChannel(from_detection[KEYBOARD_SYNC_ID.intValue()],to_detection, new ZoneId(ZoneId.Z_2), state);
		                    break;
		                case DETECTION_3 :
		                    syncChannel(from_detection[KEYBOARD_SYNC_ID.intValue()],to_detection, new ZoneId(ZoneId.Z_3), state);
		                    break;
		                case DETECTION_4 :
		                    syncChannel(from_detection[KEYBOARD_SYNC_ID.intValue()],to_detection, new ZoneId(ZoneId.Z_4), state);
		                    break;
		                case DETECTION_5 :
		                    syncChannel(from_detection[KEYBOARD_SYNC_ID.intValue()],to_detection, new ZoneId(ZoneId.Z_5), state);
		                    break;
		                case ZONE_FAULT :
		                    syncChannel(from_fault[KEYBOARD_SYNC_ID.intValue()],to_fault, new FaultId(FaultId.ZONE_FAULT), state);
		                    break;
		                case EARTH_FAULT :
		                    syncChannel(from_fault[KEYBOARD_SYNC_ID.intValue()],to_fault, new FaultId(FaultId.EARTH_FAULT), state);
		                    break;
		                case SOUNDER_LINE_FAULT :
		                    syncChannel(from_fault[KEYBOARD_SYNC_ID.intValue()],to_fault, new FaultId(FaultId.SOUNDER_LINE_FAULT), state);
		                    break;
		                case POWER_FAULT :
		                    syncChannel(from_fault[KEYBOARD_SYNC_ID.intValue()],to_fault, new FaultId(FaultId.POWER_FAULT), state);
		                    break;
		                case ISOLATE_REMOTE_SIGNAL :
		                    syncChannel(from_fault[KEYBOARD_SYNC_ID.intValue()],to_fault, new FaultId(FaultId.ISOLATE_REMOTE_SIGNAL), state);
		                    break;
		                case ACTUATOR_LINE_FAULT :
		                    syncChannel(from_fault[KEYBOARD_SYNC_ID.intValue()],to_fault, new FaultId(FaultId.ACTUATOR_LINE_FAULT), state);
		                    break;
		                case MANUAL_DISCHARGE_0 :
		                    areas.addElement(new AreaId(AreaId.A_0));
		                    writeChannel(externalManualDischarge, areas, state);
		                    break;
		                case MANUAL_DISCHARGE_1 :
		                    areas.addElement(new AreaId(AreaId.A_1));
		                    writeChannel(externalManualDischarge, areas, state);
		                    break;
		                case MANUAL_DISCHARGE_ALL :
		                    areas.addElement(new AreaId(0));
		                    areas.addElement(new AreaId(1));
		                    writeChannel(externalManualDischarge, areas, state);
		                    break;
		                case MODE_SWITCH_MANUAL :
		                    syncChannel(from_modeSwitch[KEYBOARD_SYNC_ID.intValue()],to_modeSwitch, new SwitchMode(SwitchMode.MANUAL), state);
		                    break;
		                case MODE_SWITCH_AUTOMATIC :
		                    syncChannel(from_modeSwitch[KEYBOARD_SYNC_ID.intValue()],to_modeSwitch, new SwitchMode(SwitchMode.AUTOMATIC), state);
		                    break;
		                case RESET :
		                    syncChannel(from_reset[KEYBOARD_SYNC_ID.intValue()],to_reset, null, state);
		                    break;
		                case SWITCH_ON :
		                    syncChannel(from_switchOn[KEYBOARD_SYNC_ID.intValue()],to_switchOn, null, state);
		                    break;
		                case SILENCE_ALARM :
		                    syncChannel(from_silenceAlarm[KEYBOARD_SYNC_ID.intValue()],to_silenceAlarm, null, state);
		                    break;
		                case ACTUATORS_REPLACED :
		                    syncChannel(from_actuatorsReplaced[KEYBOARD_SYNC_ID.intValue()] ,to_actuatorsReplaced, null, state);
		                    break;
		            }
		            break;
		    }
		}

		private void availableButtons(SystemState state){
		    jLabelSystemState.setText(SYSTEM_STATE+state.getValue());
		    
		    //btnPressed.write(new Integer(SWITCH_ON));
		    //state.setValue(SystemState.FIRE_SYS);
		    
		    switch (state.getValue()) {
		        case SystemState.FIRE_SYS_START:
		            jButtonDetection_0.setEnabled(false);
		            jButtonDetection_1.setEnabled(false);
		            jButtonDetection_2.setEnabled(false);
		            jButtonDetection_3.setEnabled(false);
		            jButtonDetection_4.setEnabled(false);
		            jButtonDetection_5.setEnabled(false);
		            jButtonZoneFault.setEnabled(false);
		            jButtonEarthFault.setEnabled(false);
		            jButtonSounderLine.setEnabled(false);
		            jButtonPowerFault.setEnabled(false);
		            jButtonIsolateRemoteSignal.setEnabled(false);
		            jButtonActuatorLineFault.setEnabled(false);
		            jButtonManualDischarge_0.setEnabled(false);
		            jButtonManualDischarge_1.setEnabled(false);
		            jButtonManualDischarge_all.setEnabled(false);
		            jButtonModeSwitchAutomatic.setEnabled(false);
		            jButtonModeSwitchManual.setEnabled(false);
		            jButtonReset.setEnabled(false);
		            jButtonSwitchOn.setEnabled(true);
		            jButtonSilenceAlarm.setEnabled(false);
		            jButtonActuatorsReplaced.setEnabled(false);
		            break;
		        case SystemState.FIRE_SYS:
		            jButtonDetection_0.setEnabled(true);
		            jButtonDetection_1.setEnabled(true);
		            jButtonDetection_2.setEnabled(true);
		            jButtonDetection_3.setEnabled(true);
		            jButtonDetection_4.setEnabled(true);
		            jButtonDetection_5.setEnabled(true);
		            jButtonZoneFault.setEnabled(true);
		            jButtonEarthFault.setEnabled(true);
		            jButtonSounderLine.setEnabled(true);
		            jButtonPowerFault.setEnabled(true);
		            jButtonIsolateRemoteSignal.setEnabled(true);
		            jButtonActuatorLineFault.setEnabled(true);
		            jButtonManualDischarge_0.setEnabled(false);
		            jButtonManualDischarge_1.setEnabled(false);
		            jButtonManualDischarge_all.setEnabled(false);
		            jButtonModeSwitchAutomatic.setEnabled(true);
		            jButtonModeSwitchManual.setEnabled(true);
		            jButtonReset.setEnabled(false);
		            jButtonSwitchOn.setEnabled(false);
		            jButtonSilenceAlarm.setEnabled(false);
		            jButtonActuatorsReplaced.setEnabled(true);
		            break;
		        case SystemState.FIRE_SYS_D:
		            jButtonDetection_0.setEnabled(true);
		            jButtonDetection_1.setEnabled(true);
		            jButtonDetection_2.setEnabled(true);
		            jButtonDetection_3.setEnabled(true);
		            jButtonDetection_4.setEnabled(true);
		            jButtonDetection_5.setEnabled(true);
		            jButtonZoneFault.setEnabled(true);
		            jButtonEarthFault.setEnabled(true);
		            jButtonSounderLine.setEnabled(true);
		            jButtonPowerFault.setEnabled(true);
		            jButtonIsolateRemoteSignal.setEnabled(true);
		            jButtonActuatorLineFault.setEnabled(true);
		            jButtonManualDischarge_0.setEnabled(false);
		            jButtonManualDischarge_1.setEnabled(false);
		            jButtonManualDischarge_all.setEnabled(false);
		            jButtonModeSwitchAutomatic.setEnabled(false);
		            jButtonModeSwitchManual.setEnabled(false);
		            jButtonReset.setEnabled(false);
		            jButtonSwitchOn.setEnabled(false);
		            jButtonSilenceAlarm.setEnabled(false);
		            jButtonActuatorsReplaced.setEnabled(true);
		            break;
		        case SystemState.AUTO:
		            jButtonDetection_0.setEnabled(true);
		            jButtonDetection_1.setEnabled(true);
		            jButtonDetection_2.setEnabled(true);
		            jButtonDetection_3.setEnabled(true);
		            jButtonDetection_4.setEnabled(true);
		            jButtonDetection_5.setEnabled(true);
		            jButtonZoneFault.setEnabled(true);
		            jButtonEarthFault.setEnabled(true);
		            jButtonSounderLine.setEnabled(true);
		            jButtonPowerFault.setEnabled(true);
		            jButtonIsolateRemoteSignal.setEnabled(true);
		            jButtonActuatorLineFault.setEnabled(true);
		            jButtonManualDischarge_0.setEnabled(false);
		            jButtonManualDischarge_1.setEnabled(false);
		            jButtonManualDischarge_all.setEnabled(false);
		            jButtonModeSwitchAutomatic.setEnabled(false);
		            jButtonModeSwitchManual.setEnabled(false);
		            jButtonReset.setEnabled(true);
		            jButtonSwitchOn.setEnabled(false);
		            jButtonSilenceAlarm.setEnabled(false);
		            jButtonActuatorsReplaced.setEnabled(false);
		            break;
		        case SystemState.COUNTDOWN:
		            jButtonDetection_0.setEnabled(true);
		            jButtonDetection_1.setEnabled(true);
		            jButtonDetection_2.setEnabled(true);
		            jButtonDetection_3.setEnabled(true);
		            jButtonDetection_4.setEnabled(true);
		            jButtonDetection_5.setEnabled(true);
		            jButtonZoneFault.setEnabled(true);
		            jButtonEarthFault.setEnabled(true);
		            jButtonSounderLine.setEnabled(true);
		            jButtonPowerFault.setEnabled(true);
		            jButtonIsolateRemoteSignal.setEnabled(true);
		            jButtonActuatorLineFault.setEnabled(true);
		            jButtonManualDischarge_0.setEnabled(false);
		            jButtonManualDischarge_1.setEnabled(false);
		            jButtonManualDischarge_all.setEnabled(false);
		            jButtonModeSwitchAutomatic.setEnabled(false);
		            jButtonModeSwitchManual.setEnabled(false);
		            jButtonReset.setEnabled(false);
		            jButtonSwitchOn.setEnabled(false);
		            jButtonSilenceAlarm.setEnabled(false);
		            jButtonActuatorsReplaced.setEnabled(false);
		            break;
		        case SystemState.DISCHARGE:
		            jButtonDetection_0.setEnabled(false);
		            jButtonDetection_1.setEnabled(false);
		            jButtonDetection_2.setEnabled(false);
		            jButtonDetection_3.setEnabled(false);
		            jButtonDetection_4.setEnabled(false);
		            jButtonDetection_5.setEnabled(false);
		            jButtonZoneFault.setEnabled(false);
		            jButtonEarthFault.setEnabled(false);
		            jButtonSounderLine.setEnabled(false);
		            jButtonPowerFault.setEnabled(false);
		            jButtonIsolateRemoteSignal.setEnabled(false);
		            jButtonActuatorLineFault.setEnabled(false);
		            jButtonManualDischarge_0.setEnabled(false);
		            jButtonManualDischarge_1.setEnabled(false);
		            jButtonManualDischarge_all.setEnabled(false);
		            jButtonModeSwitchAutomatic.setEnabled(false);
		            jButtonModeSwitchManual.setEnabled(false);
		            jButtonReset.setEnabled(false);
		            jButtonSwitchOn.setEnabled(false);
		            jButtonSilenceAlarm.setEnabled(false);
		            jButtonActuatorsReplaced.setEnabled(false);
		            break;
		        case SystemState.RESET:
		            jButtonDetection_0.setEnabled(true);
		            jButtonDetection_1.setEnabled(true);
		            jButtonDetection_2.setEnabled(true);
		            jButtonDetection_3.setEnabled(true);
		            jButtonDetection_4.setEnabled(true);
		            jButtonDetection_5.setEnabled(true);
		            jButtonZoneFault.setEnabled(true);
		            jButtonEarthFault.setEnabled(true);
		            jButtonSounderLine.setEnabled(true);
		            jButtonPowerFault.setEnabled(true);
		            jButtonIsolateRemoteSignal.setEnabled(true);
		            jButtonActuatorLineFault.setEnabled(true);
		            jButtonManualDischarge_0.setEnabled(false);
		            jButtonManualDischarge_1.setEnabled(false);
		            jButtonManualDischarge_all.setEnabled(false);
		            jButtonModeSwitchAutomatic.setEnabled(false);
		            jButtonModeSwitchManual.setEnabled(false);
		            jButtonReset.setEnabled(true);
		            jButtonSwitchOn.setEnabled(false);
		            jButtonSilenceAlarm.setEnabled(false);
		            jButtonActuatorsReplaced.setEnabled(true);
		            break;
		        case SystemState.MANUAL:
		            jButtonDetection_0.setEnabled(true);
		            jButtonDetection_1.setEnabled(true);
		            jButtonDetection_2.setEnabled(true);
		            jButtonDetection_3.setEnabled(true);
		            jButtonDetection_4.setEnabled(true);
		            jButtonDetection_5.setEnabled(true);
		            jButtonZoneFault.setEnabled(true);
		            jButtonEarthFault.setEnabled(true);
		            jButtonSounderLine.setEnabled(true);
		            jButtonPowerFault.setEnabled(true);
		            jButtonIsolateRemoteSignal.setEnabled(true);
		            jButtonActuatorLineFault.setEnabled(true);
		            jButtonManualDischarge_0.setEnabled(true);
		            jButtonManualDischarge_1.setEnabled(true);
		            jButtonManualDischarge_all.setEnabled(true);
		            jButtonModeSwitchAutomatic.setEnabled(false);
		            jButtonModeSwitchManual.setEnabled(false);
		            jButtonReset.setEnabled(false);
		            jButtonSwitchOn.setEnabled(false);
		            jButtonSilenceAlarm.setEnabled(true);
		            jButtonActuatorsReplaced.setEnabled(false);
		            break;
		        case SystemState.DISABLED:
		            jButtonDetection_0.setEnabled(true);
		            jButtonDetection_1.setEnabled(true);
		            jButtonDetection_2.setEnabled(true);
		            jButtonDetection_3.setEnabled(true);
		            jButtonDetection_4.setEnabled(true);
		            jButtonDetection_5.setEnabled(true);
		            jButtonZoneFault.setEnabled(true);
		            jButtonEarthFault.setEnabled(true);
		            jButtonSounderLine.setEnabled(true);
		            jButtonPowerFault.setEnabled(true);
		            jButtonIsolateRemoteSignal.setEnabled(true);
		            jButtonActuatorLineFault.setEnabled(true);
		            jButtonManualDischarge_0.setEnabled(false);
		            jButtonManualDischarge_1.setEnabled(false);
		            jButtonManualDischarge_all.setEnabled(false);
		            jButtonModeSwitchAutomatic.setEnabled(false);
		            jButtonModeSwitchManual.setEnabled(false);
		            jButtonReset.setEnabled(false);
		            jButtonSwitchOn.setEnabled(false);
		            jButtonSilenceAlarm.setEnabled(true);
		            jButtonActuatorsReplaced.setEnabled(false);
		            break;
		        default:
		            throw new RuntimeException();
		    }
		}

		private void syncChannel(AltingChannelInput from, ChannelOutput to, Object value, SystemState state) {
		    // Wait a multi-sinchronisation on the given channel

		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from, to, KEYBOARD_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);

		    Vector seqOfNotSync = new Vector(); 
		    seqOfNotSync.addElement(systemState);

		    MultiSyncClient client = new MultiSyncClient(seqOfSync, seqOfNotSync, value);
		    client.run();

		    int choosen = client.getChoosen();
		    final int SYNCHRONISED = 0;
		    final int INTERRUPTED  = 1;

		    if (choosen == SYNCHRONISED) {
		        keyboardCycle(state);
		    } else if (choosen == INTERRUPTED) {
		        keyboardCycle((SystemState)client.getValueTrans());
		    }
		}

		// writes the value in the given channel
		private void writeChannel(ChannelOutput channel, Object value, SystemState state) {
		    channel.write(value);
		    keyboardCycle(state);
		}

		/* Initialises the keyboard */
		private void initKeyboard() {
		    initComponents();
		    internationalise();
		    setLocation(0,LAMPS_TYPES*LAMPS_SIZE_Y+ALARM_SIZE_Y);
		    show();
		}

		/* Action Run Keyboard */
		private void runKeyboard() {
		    SystemState state = (SystemState)systemState.read();
		    keyboardCycle(state);
		}

		public void run(){
		    initKeyboard();
		    runKeyboard();
		}
	}

	/* Channel externalManualDischarge */
    private final ChannelOutput externalManualDischarge;

    /* Channel modeSwitch */
    private final AltingChannelInput[] from_modeSwitch;
    private final ChannelOutput to_modeSwitch;

    /* Channel reset */
    private final AltingChannelInput[] from_reset;
    private final ChannelOutput to_reset;

    /* Channel switchOn */
    private final AltingChannelInput[] from_switchOn;
    private final ChannelOutput to_switchOn;

    /* Channel silenceAlarm */
    private final AltingChannelInput[] from_silenceAlarm;
    private final ChannelOutput to_silenceAlarm;

    /* Channel actuatorsReplaced */
    private final AltingChannelInput[] from_actuatorsReplaced;
    private final ChannelOutput to_actuatorsReplaced;

    /* Channel detection */
    private final AltingChannelInput[] from_detection;
    private final ChannelOutput to_detection;

    /* Channel fault */
    private final AltingChannelInput[] from_fault;
    private final ChannelOutput to_fault;

    /* Channel systemState */
    /*private*/public /*final*/ Any2OneChannel/*AltingChannelInput*/ systemState;

    /* Synchronisations IDs */
    final Integer KEYBOARD_SYNC_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("KEYBOARD_SYNC_ID")));

    /* Display parameters */
    private final int LAMPS_SIZE_Y = Integer.parseInt(Config.getInstance().getMessage("GENERIC_LAMP_SIZE_Y"));
    private final int ALARM_SIZE_Y = Integer.parseInt(Config.getInstance().getMessage("ALARM_SIZE_Y"));
    private final int LAMPS_TYPES = Integer.parseInt(Config.getInstance().getMessage("LAMPS_TYPES"));
    private final String SYSTEM_STATE = International.getInstance().getMessage("MSG_0039"); 
    
    /* Internal communication */
    public void writeOn_btnPressed (Integer integer) {
    	this.btnPressed.write(integer);
    }
    
    /*private*/ public Any2OneChannel btnPressed = new Any2OneChannel();
    final int DETECTION_0           = 0;
    final int DETECTION_1           = 1;
    final int DETECTION_2           = 2;
    final int DETECTION_3           = 3;
    final int DETECTION_4           = 4;
    final int DETECTION_5           = 5;
    final int ZONE_FAULT            = 6;
    final int EARTH_FAULT           = 7;
    final int SOUNDER_LINE_FAULT    = 8;
    final int POWER_FAULT           = 9;
    final int ISOLATE_REMOTE_SIGNAL = 10;
    final int ACTUATOR_LINE_FAULT   = 11;
    final int MANUAL_DISCHARGE_0    = 12;
    final int MANUAL_DISCHARGE_1    = 13;
    final int MANUAL_DISCHARGE_ALL  = 14;
    final int MODE_SWITCH_MANUAL    = 15;
    final int MODE_SWITCH_AUTOMATIC = 16;
    final int RESET                 = 17;
    public final int SWITCH_ON      = 18;
    final int SILENCE_ALARM         = 19;
    final int ACTUATORS_REPLACED    = 20;
    
    /* Creates new form Input */
    public Keyboard(
        ChannelOutput newexternalManualDischarge, 
        AltingChannelInput[] newfrom_modeSwitch, ChannelOutput newto_modeSwitch, 
        AltingChannelInput[] newfrom_reset, ChannelOutput newto_reset, 
        AltingChannelInput[] newfrom_switchOn, ChannelOutput newto_switchOn, 
        AltingChannelInput[] newfrom_silenceAlarm, ChannelOutput newto_silenceAlarm, 
        AltingChannelInput[] newfrom_actuatorsReplaced, ChannelOutput newto_actuatorsReplaced, 
        AltingChannelInput[] newfrom_detection, ChannelOutput newto_detection, 
        AltingChannelInput[] newfrom_fault, ChannelOutput newto_fault, 
        AltingChannelInput newsystemState) {
        
        this.externalManualDischarge = newexternalManualDischarge;
        this.from_modeSwitch = newfrom_modeSwitch;
        this.to_modeSwitch = newto_modeSwitch;
        this.from_reset = newfrom_reset;
        this.to_reset = newto_reset;
        this.from_switchOn = newfrom_switchOn;
        this.to_switchOn = newto_switchOn;
        this.from_silenceAlarm = newfrom_silenceAlarm;
        this.to_silenceAlarm = newto_silenceAlarm;
        this.from_actuatorsReplaced = newfrom_actuatorsReplaced;
        this.to_actuatorsReplaced = newto_actuatorsReplaced;
        this.from_detection = newfrom_detection;
        this.to_detection = newto_detection;
        this.from_fault = newfrom_fault;
        this.to_fault = newto_fault;
        this.systemState = (Any2OneChannel) newsystemState;        
    }
    
    /* This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelDetection = new javax.swing.JPanel();
        jButtonDetection_0 = new javax.swing.JButton();
        jButtonDetection_1 = new javax.swing.JButton();
        jButtonDetection_2 = new javax.swing.JButton();
        jButtonDetection_3 = new javax.swing.JButton();
        jButtonDetection_4 = new javax.swing.JButton();
        jButtonDetection_5 = new javax.swing.JButton();
        jPanelFault = new javax.swing.JPanel();
        jButtonZoneFault = new javax.swing.JButton();
        jButtonEarthFault = new javax.swing.JButton();
        jButtonSounderLine = new javax.swing.JButton();
        jButtonPowerFault = new javax.swing.JButton();
        jButtonIsolateRemoteSignal = new javax.swing.JButton();
        jButtonActuatorLineFault = new javax.swing.JButton();
        jPanelManualDischarge = new javax.swing.JPanel();
        jButtonManualDischarge_0 = new javax.swing.JButton();
        jButtonManualDischarge_1 = new javax.swing.JButton();
        jButtonManualDischarge_all = new javax.swing.JButton();
        jPanelModeSwitch = new javax.swing.JPanel();
        jButtonModeSwitchAutomatic = new javax.swing.JButton();
        jButtonModeSwitchManual = new javax.swing.JButton();
        jPanelOthers = new javax.swing.JPanel();
        jButtonReset = new javax.swing.JButton();
        jButtonSwitchOn = new javax.swing.JButton();
        jButtonSilenceAlarm = new javax.swing.JButton();
        jButtonActuatorsReplaced = new javax.swing.JButton();
        jLabelSystemState = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Input");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanelDetection.setLayout(new java.awt.GridBagLayout());

        jPanelDetection.setBorder(new javax.swing.border.TitledBorder(null, "Detection", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 11)));
        jButtonDetection_0.setText("Zone 0");
        jButtonDetection_0.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDetection_0ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelDetection.add(jButtonDetection_0, gridBagConstraints);

        jButtonDetection_1.setText("Zone 1");
        jButtonDetection_1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDetection_1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelDetection.add(jButtonDetection_1, gridBagConstraints);

        jButtonDetection_2.setText("Zone 2");
        jButtonDetection_2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDetection_2ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelDetection.add(jButtonDetection_2, gridBagConstraints);

        jButtonDetection_3.setText("Zone 3");
        jButtonDetection_3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDetection_3ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelDetection.add(jButtonDetection_3, gridBagConstraints);

        jButtonDetection_4.setText("Zone 4");
        jButtonDetection_4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDetection_4ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelDetection.add(jButtonDetection_4, gridBagConstraints);

        jButtonDetection_5.setText("Zone 5");
        jButtonDetection_5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDetection_5ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelDetection.add(jButtonDetection_5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jPanelDetection, gridBagConstraints);

        jPanelFault.setLayout(new java.awt.GridBagLayout());

        jPanelFault.setBorder(new javax.swing.border.TitledBorder(null, "Fault", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 11)));
        jButtonZoneFault.setText("Zone");
        jButtonZoneFault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonZoneFaultActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelFault.add(jButtonZoneFault, gridBagConstraints);

        jButtonEarthFault.setText("Earth");
        jButtonEarthFault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonEarthFaultActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelFault.add(jButtonEarthFault, gridBagConstraints);

        jButtonSounderLine.setText("Sounder Line");
        jButtonSounderLine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSounderLineActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelFault.add(jButtonSounderLine, gridBagConstraints);

        jButtonPowerFault.setText("Power");
        jButtonPowerFault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPowerFaultActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelFault.add(jButtonPowerFault, gridBagConstraints);

        jButtonIsolateRemoteSignal.setText("Remote Signal");
        jButtonIsolateRemoteSignal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonIsolateRemoteSignalActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelFault.add(jButtonIsolateRemoteSignal, gridBagConstraints);

        jButtonActuatorLineFault.setText("Actuator Line");
        jButtonActuatorLineFault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonActuatorLineFaultActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelFault.add(jButtonActuatorLineFault, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jPanelFault, gridBagConstraints);

        jPanelManualDischarge.setLayout(new java.awt.GridBagLayout());

        jPanelManualDischarge.setBorder(new javax.swing.border.TitledBorder(null, "Manual Discharge", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 11)));
        jButtonManualDischarge_0.setText("Area 0");
        jButtonManualDischarge_0.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonManualDischarge_0ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelManualDischarge.add(jButtonManualDischarge_0, gridBagConstraints);

        jButtonManualDischarge_1.setText("Area 1");
        jButtonManualDischarge_1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonManualDischarge_1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelManualDischarge.add(jButtonManualDischarge_1, gridBagConstraints);

        jButtonManualDischarge_all.setText("All Areas");
        jButtonManualDischarge_all.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonManualDischarge_allActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelManualDischarge.add(jButtonManualDischarge_all, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jPanelManualDischarge, gridBagConstraints);

        jPanelModeSwitch.setLayout(new java.awt.GridBagLayout());

        jPanelModeSwitch.setBorder(new javax.swing.border.TitledBorder(null, "Mode Switch", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 11)));
        jButtonModeSwitchAutomatic.setText("Automatic");
        jButtonModeSwitchAutomatic.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModeSwitchAutomaticActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelModeSwitch.add(jButtonModeSwitchAutomatic, gridBagConstraints);

        jButtonModeSwitchManual.setText("Manual");
        jButtonModeSwitchManual.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModeSwitchManualActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelModeSwitch.add(jButtonModeSwitchManual, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jPanelModeSwitch, gridBagConstraints);

        jPanelOthers.setLayout(new java.awt.GridBagLayout());

        jPanelOthers.setBorder(new javax.swing.border.TitledBorder(null, "Others", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 11)));
        jButtonReset.setText("Reset");
        jButtonReset.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonResetActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelOthers.add(jButtonReset, gridBagConstraints);

        jButtonSwitchOn.setText("Switch On");
        jButtonSwitchOn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSwitchOnActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelOthers.add(jButtonSwitchOn, gridBagConstraints);

        jButtonSilenceAlarm.setText("Silence Alarm");
        jButtonSilenceAlarm.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSilenceAlarmActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelOthers.add(jButtonSilenceAlarm, gridBagConstraints);

        jButtonActuatorsReplaced.setText("Actuators Replaced");
        jButtonActuatorsReplaced.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonActuatorsReplacedActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelOthers.add(jButtonActuatorsReplaced, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jPanelOthers, gridBagConstraints);

        jLabelSystemState.setText("System State");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        getContentPane().add(jLabelSystemState, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void jButtonManualDischarge_allActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonManualDischarge_allActionPerformed
        this.btnPressed.write(new Integer(MANUAL_DISCHARGE_ALL));
    }//GEN-LAST:event_jButtonManualDischarge_allActionPerformed

    private void jButtonActuatorsReplacedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonActuatorsReplacedActionPerformed
        this.btnPressed.write(new Integer(ACTUATORS_REPLACED));
    }//GEN-LAST:event_jButtonActuatorsReplacedActionPerformed

    private void jButtonSilenceAlarmActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSilenceAlarmActionPerformed
        this.btnPressed.write(new Integer(SILENCE_ALARM));
    }//GEN-LAST:event_jButtonSilenceAlarmActionPerformed

    private void jButtonSwitchOnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSwitchOnActionPerformed
        this.btnPressed.write(new Integer(SWITCH_ON));
    }//GEN-LAST:event_jButtonSwitchOnActionPerformed

    private void jButtonResetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonResetActionPerformed
        this.btnPressed.write(new Integer(RESET));
    }//GEN-LAST:event_jButtonResetActionPerformed

    private void jButtonModeSwitchManualActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModeSwitchManualActionPerformed
        this.btnPressed.write(new Integer(MODE_SWITCH_MANUAL));
    }//GEN-LAST:event_jButtonModeSwitchManualActionPerformed

    private void jButtonModeSwitchAutomaticActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModeSwitchAutomaticActionPerformed
        this.btnPressed.write(new Integer(MODE_SWITCH_AUTOMATIC));
    }//GEN-LAST:event_jButtonModeSwitchAutomaticActionPerformed

    private void jButtonManualDischarge_1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonManualDischarge_1ActionPerformed
        this.btnPressed.write(new Integer(MANUAL_DISCHARGE_1));
    }//GEN-LAST:event_jButtonManualDischarge_1ActionPerformed

    private void jButtonManualDischarge_0ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonManualDischarge_0ActionPerformed
        this.btnPressed.write(new Integer(MANUAL_DISCHARGE_0));
    }//GEN-LAST:event_jButtonManualDischarge_0ActionPerformed

    private void jButtonActuatorLineFaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonActuatorLineFaultActionPerformed
        this.btnPressed.write(new Integer(ACTUATOR_LINE_FAULT));
    }//GEN-LAST:event_jButtonActuatorLineFaultActionPerformed

    private void jButtonIsolateRemoteSignalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonIsolateRemoteSignalActionPerformed
        this.btnPressed.write(new Integer(ISOLATE_REMOTE_SIGNAL));
    }//GEN-LAST:event_jButtonIsolateRemoteSignalActionPerformed

    private void jButtonPowerFaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPowerFaultActionPerformed
        this.btnPressed.write(new Integer(POWER_FAULT));
    }//GEN-LAST:event_jButtonPowerFaultActionPerformed

    private void jButtonSounderLineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSounderLineActionPerformed
        this.btnPressed.write(new Integer(SOUNDER_LINE_FAULT));
    }//GEN-LAST:event_jButtonSounderLineActionPerformed

    private void jButtonEarthFaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonEarthFaultActionPerformed
        this.btnPressed.write(new Integer(EARTH_FAULT));
    }//GEN-LAST:event_jButtonEarthFaultActionPerformed

    private void jButtonZoneFaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonZoneFaultActionPerformed
        this.btnPressed.write(new Integer(ZONE_FAULT));
    }//GEN-LAST:event_jButtonZoneFaultActionPerformed

    private void jButtonDetection_5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetection_5ActionPerformed
        this.btnPressed.write(new Integer(DETECTION_5));
    }//GEN-LAST:event_jButtonDetection_5ActionPerformed

    private void jButtonDetection_4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetection_4ActionPerformed
        this.btnPressed.write(new Integer(DETECTION_4));
    }//GEN-LAST:event_jButtonDetection_4ActionPerformed

    private void jButtonDetection_3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetection_3ActionPerformed
        this.btnPressed.write(new Integer(DETECTION_3));
    }//GEN-LAST:event_jButtonDetection_3ActionPerformed

    private void jButtonDetection_2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetection_2ActionPerformed
        this.btnPressed.write(new Integer(DETECTION_2));
    }//GEN-LAST:event_jButtonDetection_2ActionPerformed

    private void jButtonDetection_1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetection_1ActionPerformed
        this.btnPressed.write(new Integer(DETECTION_1));
    }//GEN-LAST:event_jButtonDetection_1ActionPerformed

    private void jButtonDetection_0ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetection_0ActionPerformed
        this.btnPressed.write(new Integer(DETECTION_0));
    }//GEN-LAST:event_jButtonDetection_0ActionPerformed
    
    /* Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm

    // Variables declaration - do not modify//GEN-BEGIN:variables
    /*private*/ public static javax.swing.JButton jButtonManualDischarge_1;
    /*private*/ public static javax.swing.JButton jButtonModeSwitchManual;
    /*private*/ public static javax.swing.JButton jButtonModeSwitchAutomatic;
    /*private*/ public static javax.swing.JButton jButtonDetection_5;
    /*private*/ public static javax.swing.JButton jButtonReset;
    /*private*/ public static javax.swing.JButton jButtonActuatorsReplaced;
    /*private*/ public static javax.swing.JLabel jLabelSystemState;
    /*private*/ public static javax.swing.JButton jButtonManualDischarge_0;
    /*private*/ public static javax.swing.JPanel jPanelDetection;
    /*private*/ public static javax.swing.JButton jButtonSilenceAlarm;
    /*private*/ public static javax.swing.JPanel jPanelFault;
    /*private*/ public static javax.swing.JButton jButtonDetection_1;
    /*private*/ public static javax.swing.JButton jButtonZoneFault;
    /*private*/ public static javax.swing.JButton jButtonSounderLine;
    /*private*/ public static javax.swing.JButton jButtonDetection_4;
    /*private*/ public static javax.swing.JPanel jPanelModeSwitch;
    /*private*/ public static javax.swing.JButton jButtonActuatorLineFault;
    /*private*/ public static javax.swing.JButton jButtonManualDischarge_all;
    /*private*/ public static javax.swing.JPanel jPanelManualDischarge;
    /*private*/ public static javax.swing.JButton jButtonPowerFault;
    /*private*/ public static javax.swing.JButton jButtonEarthFault;
    /*private*/ public static javax.swing.JButton jButtonDetection_2;
    /*private*/ public static javax.swing.JButton jButtonSwitchOn;
    /*private*/ public static javax.swing.JButton jButtonDetection_3;
    /*private*/ public static javax.swing.JButton jButtonDetection_0;
    /*private*/ public static javax.swing.JPanel jPanelOthers;
    /*private*/ public static javax.swing.JButton jButtonIsolateRemoteSignal;

    //Os mtodos abaixo devem ser adaptados  nova gerao de cdigo provida por JCircus... Foram acrescentados manualmente por mim (Sam)
    // End of variables declaration//GEN-END:variables

    // Internationalises the messages of the frame
    private void internationalise(){
        this.setTitle(International.getInstance().getMessage("MSG_0017"));
        this.jButtonDetection_0.setText(International.getInstance().getMessage("MSG_0018"));
        this.jButtonDetection_1.setText(International.getInstance().getMessage("MSG_0019"));
        this.jButtonDetection_2.setText(International.getInstance().getMessage("MSG_0020"));
        this.jButtonDetection_3.setText(International.getInstance().getMessage("MSG_0021"));
        this.jButtonDetection_4.setText(International.getInstance().getMessage("MSG_0022"));
        this.jButtonDetection_5.setText(International.getInstance().getMessage("MSG_0023"));
        this.jButtonZoneFault.setText(International.getInstance().getMessage("MSG_0024"));
        this.jButtonEarthFault.setText(International.getInstance().getMessage("MSG_0025"));
        this.jButtonSounderLine.setText(International.getInstance().getMessage("MSG_0026"));
        this.jButtonPowerFault.setText(International.getInstance().getMessage("MSG_0027"));
        this.jButtonIsolateRemoteSignal.setText(International.getInstance().getMessage("MSG_0028"));
        this.jButtonActuatorLineFault.setText(International.getInstance().getMessage("MSG_0029"));
        this.jButtonManualDischarge_0.setText(International.getInstance().getMessage("MSG_0030"));
        this.jButtonManualDischarge_1.setText(International.getInstance().getMessage("MSG_0031"));
        this.jButtonManualDischarge_all.setText(International.getInstance().getMessage("MSG_0042"));
        this.jButtonModeSwitchAutomatic.setText(International.getInstance().getMessage("MSG_0032"));
        this.jButtonModeSwitchManual.setText(International.getInstance().getMessage("MSG_0033"));
        this.jButtonReset.setText(International.getInstance().getMessage("MSG_0034"));
        this.jButtonSwitchOn.setText(International.getInstance().getMessage("MSG_0035"));
        this.jButtonSilenceAlarm.setText(International.getInstance().getMessage("MSG_0036"));
        this.jButtonActuatorsReplaced.setText(International.getInstance().getMessage("MSG_0037"));
    }
    
    /* runs this process */
    public void run() {
    	//this.btnPressed.write(new Integer(18));
        CSP csp = new CSP();
        csp.run();
        
    }
    
}
