package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process representig the Fire Control
 *
 * Created on 16 May 2003, 11:05
 * @author  Marcel Oliveira
*/

public class FireControl implements CSProcess {
    public class I_0 implements CSProcess {
        AreaId area;
        SetOfType aux_l_log_0;
        public I_0(AreaId newarea, SetOfType newlog) {
            this.area = newarea;
            this.aux_l_log_0 = newlog;
        }
        public void run() {
            Guard[] guards = new Guard[]{gasDischarged[area.getValue()], 
                                           gasNotDischarged[area.getValue()]};
            final Alternative alt = new Alternative(guards);
            final int GAS_DISCHARGED     = 0;
            final int GAS_NOT_DISCHARGED = 1;

            switch(alt.select()) {
                case GAS_DISCHARGED:
                    gasDischarged[area.getValue()].read();
                    aux_l_log_0.addElement(area);
                    break;
                case GAS_NOT_DISCHARGED:
                    gasNotDischarged[area.getValue()].read();
                    (new Skip()).run();
                    break;
            }
        }
    }
    public class I_1 implements CSProcess {
        AreaId area;
        SetOfType aux_l_log_0;
        public I_1(AreaId newarea, SetOfType newlog) {
            this.area = newarea;
            this.aux_l_log_0 = newlog;
        }
        public void run() {
            Guard[] guards = new Guard[]{gasDischarged[area.getValue()], 
                                           gasNotDischarged[area.getValue()]};
            final Alternative alt = new Alternative(guards);
            final int GAS_DISCHARGED     = 0;
            final int GAS_NOT_DISCHARGED = 1;

            switch(alt.select()) {
                case GAS_DISCHARGED:
                    gasDischarged[area.getValue()].read();
                    aux_l_log_0.addElement(area);
                    break;
                case GAS_NOT_DISCHARGED:
                    gasNotDischarged[area.getValue()].read();
                    (new Skip()).run();
                    break;
            }
        }
    }

    public class CSP implements CSProcess {
		/* Mode of the system */
		private Mode mode_1;

		/* Schema InitFireControl */
		private void initFireControl() {
		    mode_1 = new Mode(Mode.AUTOMATIC);
		}

		/* Schema SwitchFireControlMode */
		private void switchFireControlMode(SwitchMode newMode){
		    mode_1 = newMode;
		}

		/* Schema SwitchFireControl2AutomaticMode */
		private void switchFireControl2AutomaticMode() {
		    mode_1 = new Mode(Mode.AUTOMATIC);
		}

		/* Schema SwitchFireControl2DisabledMode */
		private void switchFireControl2DisabledMode() {
		    mode_1 = new Mode(Mode.DISABLED);
		}

		/* Action FireSysStart */
		private void fireSysStart() {
		    systemState.write(new SystemState(SystemState.FIRE_SYS_START));

		    // Wait a multi-sinchronisation on channel switchOn
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_switchOn[FIRE_CONTROL_SYNC_ID.intValue()], to_switchOn, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    MultiSyncClient client = new MultiSyncClient(seqOfSync, new Vector(), null);
		    client.run();

		    switched.read();

		    initFireControl();
		    fireSys();
		}

		/* Action FireSys */
		private void fireSys() {
		    systemState.write(new SystemState(SystemState.FIRE_SYS));

		    final int DETECTION          = 0;
		    final int MODE_SWITCH        = 1;
		    final int ACTUATORS_REPLACED = 2;
		    final int FAULT              = 3;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_detection[FIRE_CONTROL_SYNC_ID.intValue()], to_detection, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync2 = new Object[]{from_modeSwitch[FIRE_CONTROL_SYNC_ID_MODE_SWITCH.intValue()], to_modeSwitch, FIRE_CONTROL_SYNC_ID_MODE_SWITCH, KEYBOARD_SYNC_ID};
		    Object[] sync3 = new Object[]{from_actuatorsReplaced[FIRE_CONTROL_SYNC_ID.intValue()], to_actuatorsReplaced, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync4 = new Object[]{from_fault[FIRE_CONTROL_SYNC_ID.intValue()], to_fault, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    seqOfSync.addElement(sync2);
		    seqOfSync.addElement(sync3);
		    seqOfSync.addElement(sync4);

		    Vector seqOfNotSync = new Vector();

		    MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
		    client.run();

		    switch(client.getChoosen()) {
		        case DETECTION:
		        {
		            ZoneId newZone = (ZoneId)client.getValueTrans();
		            switched.read();
		            alarm.write(new AlarmStage(AlarmStage.FIRST_STAGE));
		            if (mode_1.getValue()==Mode.MANUAL){
		                manual();
		            } else if (mode_1.getValue()==Mode.AUTOMATIC){
		                auto();
		            }
		        }
		            break;
		        case MODE_SWITCH:
		        {
		            SwitchMode newMode = (SwitchMode)client.getValueTrans();
		            switchFireControlMode(newMode);
		            fireSys();
		        }
		            break;
		        case ACTUATORS_REPLACED:
		            switched.read();
		            switchFireControl2AutomaticMode();
		            reset();
		            break;
		        case FAULT:
		        {
		            FaultId faultId = (FaultId)client.getValueTrans();
		            switched.read();
		            fireSys();
		        }
		            break;
		    } 
		}

		/* Action Manual */
		private void manual() {
		    systemState.write(new SystemState(SystemState.MANUAL));

		    final int DETECTION                 = 0;
		    final int SILENCE_ALARM             = 1;
		    final int FAULT                     = 2;
		    final int EXTERNAL_MANUAL_DISCHARGE = 3;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_detection[FIRE_CONTROL_SYNC_ID.intValue()], to_detection, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync2 = new Object[]{from_silenceAlarm[FIRE_CONTROL_SYNC_ID.intValue()], to_silenceAlarm, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync3 = new Object[]{from_fault[FIRE_CONTROL_SYNC_ID.intValue()], to_fault, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    seqOfSync.addElement(sync2);
		    seqOfSync.addElement(sync3);

		    Vector seqOfNotSync = new Vector();
		    seqOfNotSync.addElement(externalManualDischarge);
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
		    client.run();

		    switch(client.getChoosen()) {
		        case DETECTION:
		        {
		            ZoneId newZone = (ZoneId)client.getValueTrans();
		            switched.read();
		            manual();
		        }
		            break;
		        case SILENCE_ALARM:
		            switched.read();
		            alarm.write(new AlarmStage(AlarmStage.ALARM_OFF));
		            reset();
		            break;
		        case FAULT:
		        {
		            FaultId faultId = (FaultId)client.getValueTrans();
		            switched.read();
		            manual();
		        }
		            break;
		        case EXTERNAL_MANUAL_DISCHARGE:
		        {
		            SetOfType areas = (SetOfType)client.getValueTrans();

		            // Wait a multi-sinchronisation on the given channel
		            seqOfSync = new Vector();
		            sync = new Object[]{from_manualDischarge[FIRE_CONTROL_SYNC_AREAS_ID.intValue()], to_manualDischarge, FIRE_CONTROL_SYNC_AREAS_ID, FIRE_CONTROL_SYNC_AREAS_ID};
		            seqOfSync.addElement(sync);
		            client = new MultiSyncClient(seqOfSync,new Vector(),areas);
		            client.run();

		            SetOfType log = new SetOfType();


		            for (AreaId id = new AreaId(AreaId.MIN_AREA_ID); 
		                    id.compareTo(new AreaId(AreaId.MAX_AREA_ID)) <= 0; id=new AreaId(id.getValue()+1) ) {
		                I_0 i_0_0 = new I_0(id,log);
		                i_0_0.run();
		                log = i_0_0.aux_l_log_0;
		            }

		            if (log.size() == 0) {
		                // Wait a multi-sinchronisation on the given channel
		                Vector seqOfSync_3 = new Vector();
		                Object[] sync4 = new Object[]{from_noDischarge[FIRE_CONTROL_SYNC_AREAS_ID.intValue()], to_noDischarge, FIRE_CONTROL_SYNC_AREAS_ID, FIRE_CONTROL_SYNC_AREAS_ID};
		                seqOfSync_3.addElement(sync4);

		                Vector seqOfNotSync_3 = new Vector();
		                MultiSyncClient client3 = new MultiSyncClient(seqOfSync_3,seqOfNotSync_3,null);
		                client3.run();

		                manual();
		            } else {
		                // Wait a multi-sinchronisation on the given channel
		                Vector seqOfSync_3 = new Vector();
		                Object[] sync4 = new Object[]{from_anyDischarge[FIRE_CONTROL_SYNC_AREAS_ID.intValue()], to_anyDischarge, FIRE_CONTROL_SYNC_AREAS_ID, FIRE_CONTROL_SYNC_AREAS_ID};
		                seqOfSync_3.addElement(sync4);

		                Vector seqOfNotSync_3 = new Vector();
		                MultiSyncClient client3 = new MultiSyncClient(seqOfSync_3,seqOfNotSync_3,null);
		                client3.run();

		                displayDischarge.write(log);
		                switched.read();
		                switchFireControl2DisabledMode();
		                reset();
		            }
		        }
		            break;
		    } 
		}

		/* Action Automatic */
		private void auto() {
		    systemState.write(new SystemState(SystemState.AUTO));

		    final int RESET     = 0;
		    final int DETECTION = 1;
		    final int FAULT     = 2;
		    final int COUNTDOWN = 3;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_reset[FIRE_CONTROL_SYNC_ID.intValue()], to_reset, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync2 = new Object[]{from_detection[FIRE_CONTROL_SYNC_ID.intValue()], to_detection, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync3 = new Object[]{from_fault[FIRE_CONTROL_SYNC_ID.intValue()], to_fault, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    seqOfSync.addElement(sync2);
		    seqOfSync.addElement(sync3);

		    Vector seqOfNotSync = new Vector();
		    seqOfNotSync.addElement(countdown);
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
		    client.run();

		    switch(client.getChoosen()) {
		        case RESET:
		            switched.read();
		            initFireControl();
		            fireSys();
		            break;
		        case DETECTION:
		        {
		            ZoneId newZone = (ZoneId)client.getValueTrans();
		            switched.read();
		            auto();
		        }
		            break;
		        case FAULT:
		        {
		            FaultId faultId = (FaultId)client.getValueTrans();
		            switched.read();
		            auto();
		        }
		            break;
		        case COUNTDOWN:
		            final int COUNTING = 0;
		            // Wait a multi-sinchronisation on the given channel

		            seqOfSync = new Vector();
		            sync = new Object[]{from_counting[FIRE_CONTROL_SYNC_AREAS_ID.intValue()], to_counting, FIRE_CONTROL_SYNC_AREAS_ID, FIRE_CONTROL_SYNC_AREAS_ID};
		            seqOfSync.addElement(sync);
		            client = new MultiSyncClient(seqOfSync, new Vector(), null);
		            client.run();

		            switch(client.getChoosen()) {
		                case COUNTING:
		                    alarm.write(new AlarmStage(AlarmStage.SECOND_STAGE));
		                    countdown();
		                    break;
		            } 
		            break;

		    } 
		}

		/* Action Reset */
		private void reset() {
		    systemState.write(new SystemState(SystemState.RESET));

		    final int RESET              = 0;
		    final int DETECTION          = 1;
		    final int ACTUATORS_REPLACED = 2;
		    final int FAULT              = 3;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_reset[FIRE_CONTROL_SYNC_ID.intValue()], to_reset, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync2 = new Object[]{from_detection[FIRE_CONTROL_SYNC_ID.intValue()], to_detection, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync3 = new Object[]{from_actuatorsReplaced[FIRE_CONTROL_SYNC_ID.intValue()], to_actuatorsReplaced, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync4 = new Object[]{from_fault[FIRE_CONTROL_SYNC_ID.intValue()], to_fault, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    seqOfSync.addElement(sync2);
		    seqOfSync.addElement(sync3);
		    seqOfSync.addElement(sync4);

		    Vector seqOfNotSync = new Vector();
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
		    client.run();

		    switch(client.getChoosen()) {
		        case RESET:
		            switched.read();
		            if (mode_1.getValue() == Mode.DISABLED) {
		                fireSysD();
		            } else if (mode_1.getValue() != Mode.DISABLED) {
		                initFireControl();
		                fireSys();
		            }
		            break;
		        case DETECTION:
		        {
		            ZoneId newZone = (ZoneId)client.getValueTrans();
		            switched.read();
		            reset();
		        }
		            break;
		        case ACTUATORS_REPLACED:
		            switched.read();
		            switchFireControl2AutomaticMode();
		            reset();
		            break;
		        case FAULT:
		        {
		            FaultId faultId = (FaultId)client.getValueTrans();
		            switched.read();
		            reset();
		        }
		            break;
		    } 
		}

		/* Action Countdown */
		private void countdown() {
		    systemState.write(new SystemState(SystemState.COUNTDOWN));
		    startClock.write(null);
		    waitingClock();
		}

		/* Waiting Clock */
		private void waitingClock() {
		    final int DETECTION      = 0;
		    final int FAULT          = 1;
		    final int CLOCK_FINISHED = 2;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync  = new Object[]{from_detection[FIRE_CONTROL_SYNC_ID.intValue()], to_detection, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync2 = new Object[]{from_fault[FIRE_CONTROL_SYNC_ID.intValue()], to_fault, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    seqOfSync.addElement(sync2);

		    Vector seqOfNotSync = new Vector();
		    seqOfNotSync.addElement(clockFinished);
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
		    client.run();

		    switch(client.getChoosen()) {
		        case DETECTION:
		        {
		            ZoneId newZone = (ZoneId)client.getValueTrans();
		            switched.read();
		            waitingClock();
		        }
		            break;
		        case FAULT:
		        {
		            FaultId faultId = (FaultId)client.getValueTrans();
		            switched.read();
		            waitingClock();
		        }
		            break;
		        case CLOCK_FINISHED:
		            discharge();
		            break;
		    } 
		}

		/* Action FireSysD */
		private void fireSysD() {
		    systemState.write(new SystemState(SystemState.FIRE_SYS_D));

		    final int DETECTION          = 0;
		    final int ACTUATORS_REPLACED = 1;
		    final int FAULT              = 2;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_detection[FIRE_CONTROL_SYNC_ID.intValue()], to_detection, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync2 = new Object[]{from_actuatorsReplaced[FIRE_CONTROL_SYNC_ID.intValue()], to_actuatorsReplaced, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync3 = new Object[]{from_fault[FIRE_CONTROL_SYNC_ID.intValue()], to_fault, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    seqOfSync.addElement(sync2);
		    seqOfSync.addElement(sync3);

		    Vector seqOfNotSync = new Vector();
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
		    client.run();

		    switch(client.getChoosen()) {
		        case DETECTION:
		        {
		            ZoneId newZone = (ZoneId)client.getValueTrans();
		            switched.read();
		            alarm.write(new AlarmStage(AlarmStage.FIRST_STAGE));
		            disabled();
		        }
		            break;
		        case ACTUATORS_REPLACED:
		            switched.read();
		            initFireControl();
		            fireSys();
		            break;
		        case FAULT:
		        {
		            FaultId faultId = (FaultId)client.getValueTrans();
		            switched.read();
		            fireSysD();
		        }
		            break;
		    } 
		}

		/* Action Discharge */
		private void discharge() {
		    systemState.write(new SystemState(SystemState.DISCHARGE));

		    final int AUTOMATIC_DISCHARGE  = 0;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_automaticDischarge[FIRE_CONTROL_SYNC_AREAS_ID.intValue()], to_automaticDischarge, FIRE_CONTROL_SYNC_AREAS_ID, FIRE_CONTROL_SYNC_AREAS_ID};
		    seqOfSync.addElement(sync);
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,new Vector(), null);
		    client.run();

		    switch(client.getChoosen()) {
		        case AUTOMATIC_DISCHARGE:
		            SetOfType log = new SetOfType();


		            for (AreaId id = new AreaId(AreaId.MIN_AREA_ID); 
		                    id.compareTo(new AreaId(AreaId.MAX_AREA_ID)) <= 0; id=new AreaId(id.getValue()+1) ) {
		                I_1 i_1_0 = new I_1(id,log);
		                i_1_0.run();
		                log = i_1_0.aux_l_log_0;
		            }
		            // Wait a multi-sinchronisation on the given channel
		            Vector seqOfSync_3 = new Vector();
		            Object[] sync4 = new Object[]{from_anyDischarge[FIRE_CONTROL_SYNC_AREAS_ID.intValue()], to_anyDischarge, FIRE_CONTROL_SYNC_AREAS_ID, FIRE_CONTROL_SYNC_AREAS_ID};
		            seqOfSync_3.addElement(sync4);

		            MultiSyncClient client3 = new MultiSyncClient(seqOfSync_3,new Vector(),null);
		            client3.run();

		            displayDischarge.write(log);
		            switched.read();
		            switchFireControl2DisabledMode();
		            reset();

		            break;
		    } 
		}

		/* Action Disabled */
		private void disabled() {
		    systemState.write(new SystemState(SystemState.DISABLED));

		    final int DETECTION     = 0;
		    final int SILENCE_ALARM = 1;
		    final int FAULT         = 2;

		    // Wait a multi-sinchronisation on the given channel
		    Vector seqOfSync = new Vector();
		    Object[] sync = new Object[]{from_detection[FIRE_CONTROL_SYNC_ID.intValue()], to_detection, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync2 = new Object[]{from_silenceAlarm[FIRE_CONTROL_SYNC_ID.intValue()], to_silenceAlarm, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    Object[] sync3 = new Object[]{from_fault[FIRE_CONTROL_SYNC_ID.intValue()], to_fault, FIRE_CONTROL_SYNC_ID, KEYBOARD_SYNC_ID};
		    seqOfSync.addElement(sync);
		    seqOfSync.addElement(sync2);
		    seqOfSync.addElement(sync3);

		    Vector seqOfNotSync = new Vector();
		    MultiSyncClient client = new MultiSyncClient(seqOfSync,seqOfNotSync, null);
		    client.run();

		    switch(client.getChoosen()) {
		        case DETECTION:
		        {
		            ZoneId newZone = (ZoneId)client.getValueTrans();
		            switched.read();
		            disabled();
		        }
		            break;
		        case SILENCE_ALARM:
		            switched.read();
		            alarm.write(new AlarmStage(AlarmStage.ALARM_OFF));
		            reset();
		            break;
		        case FAULT:
		        {
		            FaultId faultId = (FaultId)client.getValueTrans();
		            switched.read();
		            disabled();
		        }
		            break;
		    } 
		}

		/* Runs the process */
		public void run() {
		    fireSysStart();
		}
	}

	/* switchOn channel */
    private AltingChannelInput[] from_switchOn;
    private ChannelOutput to_switchOn;

    /* detection channel */
    private AltingChannelInput[] from_detection;
    private ChannelOutput to_detection;
    
    /* silenceAlarm channel */
    private AltingChannelInput[] from_silenceAlarm;
    private ChannelOutput to_silenceAlarm;
    
    /* reset channel */
    private AltingChannelInput[] from_reset;
    private ChannelOutput to_reset;
    
    /* actuators replaced channel */
    private AltingChannelInput[] from_actuatorsReplaced;
    private ChannelOutput to_actuatorsReplaced;

    /* modeSwitch channel */
    private AltingChannelInput[] from_modeSwitch;
    private ChannelOutput to_modeSwitch;
    
    /* externalManualDischarge channel */
    private AltingChannelInput externalManualDischarge;

    /* fault channel */
    private AltingChannelInput[] from_fault;
    private ChannelOutput to_fault;

    /* countdown channel */
    private AltingChannelInput countdown;

    /* gasDischarged channel */
    private AltingChannelInput[] gasDischarged;

    /* gasNotDischarged channel */
    private AltingChannelInput[] gasNotDischarged;

    /* clockFinished channel */
    private AltingChannelInput clockFinished;

    /* startClock channel */
    private ChannelOutput startClock;

    /* discharge channel */
    private ChannelOutput displayDischarge;

    /* switched channel */
    private ChannelInput switched;

    /* manualDischarge channel */
    private final AltingChannelInput[] from_manualDischarge;
    private final ChannelOutput to_manualDischarge;
    
    /* automaticDischarge channel */
    private final AltingChannelInput[] from_automaticDischarge;
    private final ChannelOutput to_automaticDischarge;

    /* counting channel */
    private final AltingChannelInput[] from_counting;
    private final ChannelOutput to_counting;

    /* anyDischarge channel */
    private final AltingChannelInput[] from_anyDischarge;
    private final ChannelOutput to_anyDischarge;

    /* noDischarge channel */
    private final AltingChannelInput[] from_noDischarge;
    private final ChannelOutput to_noDischarge;

    /* alarm channel */
    private ChannelOutput alarm;

    /* systemState channel */
    private ChannelOutput systemState;

    /* Synchronisations IDs */
    final Integer KEYBOARD_SYNC_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("KEYBOARD_SYNC_ID")));
    final Integer FIRE_CONTROL_SYNC_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("FIRE_CONTROL_SYNC_ID")));
    final Integer FIRE_CONTROL_SYNC_ID_MODE_SWITCH = new Integer(Integer.parseInt(Config.getInstance().getMessage("FIRE_CONTROL_SYNC_ID_MODE_SWITCH")));
    final Integer FIRE_CONTROL_SYNC_AREAS_ID = new Integer(Integer.parseInt(Config.getInstance().getMessage("FIRE_CONTROL_SYNC_AREAS_ID")));
   
    public FireControl(AltingChannelInput[] newFrom_switchOn, ChannelOutput newTo_switchOn,
                       AltingChannelInput[] newFrom_detection, ChannelOutput newTo_detection,
                       AltingChannelInput[] newFrom_silenceAlarm, ChannelOutput newTo_silenceAlarm,
                       AltingChannelInput[] newFrom_reset, ChannelOutput newTo_reset,
                       AltingChannelInput[] newFrom_actuatorsReplaced, ChannelOutput newTo_actuatorsReplaced,
                       AltingChannelInput[] newFrom_modeSwitch, ChannelOutput newTo_modeSwitch,
                       AltingChannelInput newExternalManualDischarge,
                       AltingChannelInput[] newFrom_fault, ChannelOutput newTo_fault,
                       AltingChannelInput newCountdown, 
                       AltingChannelInput[] newGasDischarged, AltingChannelInput[] newGasNotDischarged, 
                       AltingChannelInput[] newFrom_manualDischarge, ChannelOutput newTo_manualDischarge,
                       AltingChannelInput[] newFrom_automaticDischarge, ChannelOutput newTo_automaticDischarge,
                       AltingChannelInput[] newFrom_counting, ChannelOutput newTo_counting,
                       AltingChannelInput[] newFrom_anyDischarge, ChannelOutput newTo_anyDischarge,
                       AltingChannelInput[] newFrom_noDischarge, ChannelOutput newTo_noDischarge,
                       ChannelOutput newDisplayDischarge, 
                       ChannelInput newSwitched, 
                       ChannelOutput newAlarm, ChannelOutput newSystemState,
                       AltingChannelInput newClockFinished, ChannelOutput newStartClock) {
        
        this.from_switchOn = newFrom_switchOn;
        this.to_switchOn = newTo_switchOn;
        this.from_detection = newFrom_detection;
        this.to_detection = newTo_detection;
        this.from_silenceAlarm = newFrom_silenceAlarm;
        this.to_silenceAlarm = newTo_silenceAlarm;
        this.from_reset = newFrom_reset;
        this.to_reset = newTo_reset;
        this.from_actuatorsReplaced = newFrom_actuatorsReplaced;
        this.to_actuatorsReplaced = newTo_actuatorsReplaced;
        this.from_modeSwitch = newFrom_modeSwitch;
        this.to_modeSwitch = newTo_modeSwitch;
        this.externalManualDischarge = newExternalManualDischarge;
        this.from_fault = newFrom_fault;
        this.to_fault = newTo_fault;
        this.countdown = newCountdown;
        this.gasDischarged = newGasDischarged;
        this.gasNotDischarged = newGasNotDischarged;
        this.from_manualDischarge = newFrom_manualDischarge;
        this.to_manualDischarge = newTo_manualDischarge;
        this.from_automaticDischarge = newFrom_automaticDischarge;
        this.to_automaticDischarge = newTo_automaticDischarge;
        this.from_counting = newFrom_counting;
        this.to_counting = newTo_counting;
        this.from_anyDischarge = newFrom_anyDischarge;
        this.to_anyDischarge = newTo_anyDischarge;
        this.from_noDischarge = newFrom_noDischarge;
        this.to_noDischarge = newTo_noDischarge;
        this.displayDischarge = newDisplayDischarge;
        this.switched = newSwitched;
        this.alarm = newAlarm;
        this.systemState = newSystemState;
        this.clockFinished = newClockFinished;
        this.startClock = newStartClock;
        
    }
    
    public void run(){
        CSP csp = new CSP();
        csp.run();
    }
}
