package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process representig the Output
 *
 * Created on 11 June 2003, 17:16
 * @author  Marcel Oliveira
 */
public class ExternalDevices implements CSProcess {
	public Keyboard teclado;
	int counter;
	public Output output;
	public class CSP3 implements CSProcess {
		public void run() {
		    teclado = new Keyboard(externalManualDischarge, 
		        from_modeSwitch, to_modeSwitch, 
		        from_reset, to_reset, 
		        from_switchOn, to_switchOn, 
		        from_silenceAlarm, to_silenceAlarm, 
		        from_actuatorsReplaced, to_actuatorsReplaced, 
		        from_detection, to_detection, 
		        from_fault, to_fault, 
		        systemState
		    );
		    teclado.run();
		    //teclado.writeOn_btnPressed(18);
            //teclado.clickOnButtonSwitchOn ();
		}
	}
	
	public class CSP2 implements CSProcess {
		public void run() {
		    //output = new Output(switchLamp,switchBuzzer,alarm);
		    output.run();
		}
	}

    public class CSP1 implements CSProcess {
		public void run(){
			CSProcess [] cspVetor = new CSProcess [] {
					(new CSP2()),
		            (new CSP3())
			};
		    Parallel emParalelo = new Parallel(cspVetor);
		    emParalelo.run();
		}
	}

	public /*private*/ ChannelInput[][] switchLamp;
	public /*private*/ ChannelInput switchBuzzer;
	public /*private*/ ChannelInput alarm;

    /* Channel externalManualDischarge */
	public /*private*/ final ChannelOutput externalManualDischarge;

    /* Channel modeSwitch */
	public /*private*/ final AltingChannelInput[] from_modeSwitch;
	public /*private*/ final ChannelOutput to_modeSwitch;

    /* Channel reset */
	public /*private*/ final AltingChannelInput[] from_reset;
	public /*private*/ final ChannelOutput to_reset;

    /* Channel switchOn */
	public /*private*/ final AltingChannelInput[] from_switchOn;
	public /*private*/ final ChannelOutput to_switchOn;

    /* Channel silenceAlarm */
	public /*private*/ final AltingChannelInput[] from_silenceAlarm;
	public /*private*/ final ChannelOutput to_silenceAlarm;

    /* Channel actuatorsReplaced */
	public /*private*/ final AltingChannelInput[] from_actuatorsReplaced;
	public /*private*/ final ChannelOutput to_actuatorsReplaced;

    /* Channel detection */
	public /*private*/ final AltingChannelInput[] from_detection;
	public /*private*/ final ChannelOutput to_detection;

    /* Channel fault */
	public /*private*/ final AltingChannelInput[] from_fault;
	public /*private*/ final ChannelOutput to_fault;

    /* Channel systemState */
	public /*private*/ final AltingChannelInput systemState;
    
    
    
    /* Creates a new instance of Output */
    public ExternalDevices(ChannelInput[][] newswitchLamp, ChannelInput newswitchBuzzer, ChannelInput newalarm, 
        ChannelOutput newexternalManualDischarge, 
        AltingChannelInput[] newfrom_modeSwitch, ChannelOutput newto_modeSwitch, 
        AltingChannelInput[] newfrom_reset, ChannelOutput newto_reset, 
        AltingChannelInput[] newfrom_switchOn, ChannelOutput newto_switchOn, 
        AltingChannelInput[] newfrom_silenceAlarm, ChannelOutput newto_silenceAlarm, 
        AltingChannelInput[] newfrom_actuatorsReplaced, ChannelOutput newto_actuatorsReplaced, 
        AltingChannelInput[] newfrom_detection, ChannelOutput newto_detection, 
        AltingChannelInput[] newfrom_fault, ChannelOutput newto_fault, 
        AltingChannelInput newsystemState) {
            
        this.switchLamp = newswitchLamp;
        this.switchBuzzer = newswitchBuzzer;
        this.alarm = newalarm;
        
        this.externalManualDischarge = newexternalManualDischarge;
        this.from_modeSwitch = newfrom_modeSwitch;
        this.to_modeSwitch = newto_modeSwitch;
        this.from_reset = newfrom_reset;
        this.to_reset = newto_reset;
        this.from_switchOn = newfrom_switchOn;
        this.to_switchOn = newto_switchOn;
        this.from_silenceAlarm = newfrom_silenceAlarm;
        this.to_silenceAlarm = newto_silenceAlarm;
        this.from_actuatorsReplaced = newfrom_actuatorsReplaced;
        this.to_actuatorsReplaced = newto_actuatorsReplaced;
        this.from_detection = newfrom_detection;
        this.to_detection = newto_detection;
        this.from_fault = newfrom_fault;
        this.to_fault = newto_fault;
        this.systemState = newsystemState;

	    output = new Output(switchLamp,switchBuzzer,alarm);
    }
    /* Runs this process */
    public void run() {
        CSP1 csp1 = new CSP1();
        csp1.run();
    }
}
