package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process TimedFireControl
 *
 * Created on 22 May 2003, 17:45
 * @author  Marcel Oliveira
 */
public class ConcreteTimedFireControl implements CSProcess{
	public class CSP3 implements CSProcess {
		public void run() {
			//cfc
		    ConcreteFireControl cfc = new ConcreteFireControl(
		       from_switchOn, to_switchOn, 
		       from_detection, to_detection, 
		       from_silenceAlarm, to_silenceAlarm, 
		       from_reset, to_reset, 
		       from_actuatorsReplaced, to_actuatorsReplaced, 
		       from_modeSwitch, to_modeSwitch, 
		       externalManualDischarge, 
		       from_fault, to_fault, 
		       alarm, 
		       switchLamp, 
		       switchBuzzer, systemState,
		       clockFinished, startClock);
		    cfc.run();
		}
	}

	public class CSP2 implements CSProcess {
		public void run() {
			//relogio
		    Clock relogio = new Clock(startClock,clockFinished);
		    relogio.run();
		}
	}
	
    public class CSP1 implements CSProcess {
		public void run(){
			CSProcess [] cspVetor1 = new CSProcess [] {
		            (new CSP2()),
		            (new CSP3())					
			};
			Parallel emParalelo1 = new Parallel (cspVetor1);
			emParalelo1.run();
		    /*(new Parallel( //emParalelo1
		        new CSProcess[] { //cspVetor1
		            (new CSP2()),
		            (new CSP3())
		        }
		    )).run();*/
		}
	}

	private AltingChannelInput[] from_switchOn; 
    private ChannelOutput to_switchOn;
    private AltingChannelInput[] from_detection;
    private ChannelOutput to_detection;
    private AltingChannelInput[] from_silenceAlarm;
    private ChannelOutput to_silenceAlarm;
    private AltingChannelInput[] from_reset;
    private ChannelOutput to_reset; 
    private AltingChannelInput[] from_actuatorsReplaced; 
    private ChannelOutput to_actuatorsReplaced; 
    private AltingChannelInput[] from_modeSwitch; 
    private ChannelOutput to_modeSwitch;
    private AltingChannelInput externalManualDischarge; 
    private AltingChannelInput[] from_fault;
    private ChannelOutput to_fault;
    private ChannelOutput alarm;
    private ChannelOutput[][] switchLamp;
    private ChannelOutput switchBuzzer;
    private ChannelOutput systemState;
    
    private Any2OneChannel startClock;
    private Any2OneChannel clockFinished;

    /* Creates a new instance of TimedFireControl */
    public ConcreteTimedFireControl(
                               AltingChannelInput[] newfrom_switchOn, ChannelOutput newto_switchOn, 
                               AltingChannelInput[] newfrom_detection, ChannelOutput newto_detection, 
                               AltingChannelInput[] newfrom_silenceAlarm, ChannelOutput newto_silenceAlarm, 
                               AltingChannelInput[] newfrom_reset, ChannelOutput newto_reset, 
                               AltingChannelInput[] newfrom_actuatorsReplaced, ChannelOutput newto_actuatorsReplaced, 
                               AltingChannelInput[] newfrom_modeSwitch, ChannelOutput newto_modeSwitch, 
                               AltingChannelInput newexternalManualDischarge, 
                               AltingChannelInput[] newfrom_fault, ChannelOutput newto_fault, 
                               ChannelOutput newalarm, 
                               ChannelOutput[][] newswitchLamp, 
                               ChannelOutput newswitchBuzzer, ChannelOutput newsystemState) {
                           
        this.from_switchOn = newfrom_switchOn; 
        this.to_switchOn = newto_switchOn;
        this.from_detection = newfrom_detection;
        this.to_detection = newto_detection;
        this.from_silenceAlarm = newfrom_silenceAlarm;
        this.to_silenceAlarm = newto_silenceAlarm;
        this.from_reset = newfrom_reset;
        this.to_reset = newto_reset; 
        this.from_actuatorsReplaced = newfrom_actuatorsReplaced; 
        this.to_actuatorsReplaced = newto_actuatorsReplaced; 
        this.from_modeSwitch = newfrom_modeSwitch; 
        this.to_modeSwitch = newto_modeSwitch;
        this.externalManualDischarge = newexternalManualDischarge; 
        this.from_fault = newfrom_fault;
        this.to_fault = newto_fault;
        this.alarm = newalarm;
        this.switchLamp = newswitchLamp;
        this.switchBuzzer = newswitchBuzzer;
        this.systemState = newsystemState;

        this.startClock = new Any2OneChannel();
        this.clockFinished = new Any2OneChannel();
    }

    public void run() {
        CSP1 csp1 = new CSP1();
        csp1.run();
    }
}
