package fireControlSystem.processes;

import java.util.*;
import jcsp.lang.*;
import fireControlSystem.axiomaticDefinitions.*;
import fireControlSystem.typing.*;
import fireControlSystem.util.*;
import fireControlSystem.gui.*;

/*
 * Process representig a Alarm
 *
 * Created on 22 May 2003, 16:06
 * @author  Marcel Oliveira
 * Modificado por Samuel Barrocas
 */
public class Alarm implements CSProcess {
	/*private*/public AlarmStage stage;
    
    public class AlarmStageClass implements CSProcess {
		/* Lamp id */
		///*private*/public AlarmStage stage;

		/* Schema InitAlarm */
		private void initAlarm() {
		    stage = new AlarmStage(AlarmStage.ALARM_OFF);
		}

		/* Schema SwitchStage */
		private void switchStage(AlarmStage newStage) {
		    stage = newStage;

		    /* GUI */
		    visualisation.switchStage(newStage);
		}
	    public class I_0 implements CSProcess {
	        public AlarmStage aux_l_stage_0;
	        public I_0(AlarmStage stage){
	            this.aux_l_stage_0 = stage;
	        }
	        public void run(){
	            {
	                AlarmStage newStage = (AlarmStage)alarm.read();
	                switchStage(newStage);
	                I_0 i_0_0 = new I_0(aux_l_stage_0);
	                i_0_0.run();
	                aux_l_stage_0 = i_0_0.aux_l_stage_0;
	            }
	        }
	    }

		public void run() {
		    initAlarm();
		    I_0 i_0_0 = new I_0(stage);
		    i_0_0.run();
		    stage = i_0_0.aux_l_stage_0;
		}
	}

	/* Communication channel of this process */
    /*private*/public ChannelInput alarm;

    /* GUI */
    private AlarmGui visualisation;

    /* Creates a new instance of Alarm */
    public Alarm(ChannelInput newAlarm){
        this.alarm = newAlarm;

        /* GUI */
        this.visualisation = new AlarmGui();
        this.visualisation.show();
    }
    
    /* Runs this process */
    public void run() {
        (new AlarmStageClass()).run();
    }
    
}
