package fireControlSystem.gui;

import java.awt.Point;
import fireControlSystem.typing.*;
import fireControlSystem.gui.Mappings;
import fireControlSystem.util.*;

/*
 * Shows a generic lamp
 *
 * Created on 14 May 2003, 13:28
 */
public class GenericLampGui extends javax.swing.JFrame {
    
    private final int SIZE_X = Integer.parseInt(Config.getInstance().getMessage("GENERIC_LAMP_SIZE_X"));
    private final int SIZE_Y = Integer.parseInt(Config.getInstance().getMessage("GENERIC_LAMP_SIZE_Y"));
    
    /* Creates new form GenericLampGui */
    public GenericLampGui(Type id) {
        initComponents();
        
        lampDescription.setText(Mappings.getLampDescription(id));
        this.setSize(SIZE_X,SIZE_Y);
        int x = id.getValue()*this.SIZE_X;
        int y = Mappings.getY(id)*this.SIZE_Y;
        this.setLocation(x,y);
        this.setTitle(International.getInstance().getMessage("MSG_0000"));
    }
    
    /* This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        lampDescription = new javax.swing.JLabel();
        lampStatus = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setName("frameGenericLamp");
        setResizable(false);
        setEnabled(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        lampDescription.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lampDescription.setText("Lamp Description");
        lampDescription.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        lampDescription.setAlignmentY(1.0F);
        lampDescription.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        getContentPane().add(lampDescription, gridBagConstraints);

        lampStatus.setIcon(new javax.swing.ImageIcon(".\\images\\off.jpg"));
        lampStatus.setAlignmentY(0.0F);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        getContentPane().add(lampStatus, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    /* Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lampStatus;
    private javax.swing.JLabel lampDescription;
    // End of variables declaration//GEN-END:variables
    
    public void switchLampStatus(OnOff status){
        switch (status.getValue()) {
            case OnOff.ON:
                lampStatus.setIcon(new javax.swing.ImageIcon(".\\images\\on.jpg"));
                break;
            case OnOff.OFF:
                lampStatus.setIcon(new javax.swing.ImageIcon(".\\images\\off.jpg"));
                break;
        }
 
    }
}
