package jcircus.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import jcircus.JCircusControllerText;
import jcircus.exceptions.FailTranslationException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Class for tests with JUnit.
 *
 * @author  Angela Freitas
 */
public class TestJCircus extends TestCase {

    private final boolean GEN_NEW_ORIGINAL = false;

    private final String projectDir;
    private final String originalDir;
    private final boolean CHECK;
    private final String dirExamples = ".\\tests\\in\\";
    private final String sourceDir = "src";
    
    public TestJCircus(String s) {
        super(s);
        
        if (GEN_NEW_ORIGINAL) {
            projectDir = ".\\tests\\reference";
            originalDir = null;
            CHECK = false;
            
        } else {
            projectDir = ".\\tests\\out";
            originalDir = ".\\tests\\reference";
            CHECK = true;
        }
    }
    
    static public Test suite() {
        TestSuite suite = new TestSuite(TestJCircus.class);
        return suite;
    }

    public void test_Act() throws Exception {
        check("Act");
    }
    public void test_ActionParallelism() throws Exception {
        check("ActionParallelism");
    }
    public void test_ActionParEx() throws Exception {
        check("ActionParEx");
    }
    
    public void test_AxDef() throws Exception {
        check("AxDef");
    }
    public void test_Calculator() throws Exception {
        check("Calculator");
    }   
    public void test_Chronometer() throws Exception {
        check("Chronometer");
    }
    public void test_Dot() throws Exception {
        check("Dot");
    }    
    public void test_Err() throws Exception {   
        String projectName = "Err";
        try {
            (new JCircusControllerText()).translate(dirExamples + "T_" + projectName + ".tex", projectDir, projectName, /*Sam's*/ "Err", false, false/*, 0, 9*/);
            fail("no exception for Err.tex");
        } catch (FailTranslationException e) { }
    }  
    public void test_Ex1() throws Exception {
        check("Ex1");
    }
    public void test_ExtMultiSingle() throws Exception {
        check("ExtMultiSingle");
    }
    // ChanUseUnificationException: reset
    public void test_FCS() throws Exception {
        check("FCS");
    }
    public void test_Fibonacci() throws Exception {
        check("Fibonacci");
    }
    public void test_GCD() throws Exception {
        check("GCD");
    }
    public void test_GenChannel() throws Exception {
        check("GenChannel");
    }
    public void test_Guarded() throws Exception {
        check("Guarded");
    }
    public void test_LocalEnv() throws Exception {
        check("LocalEnv");
    }
    public void test_MS() throws Exception {
        check("MS");
    }
    public void test_MS2() throws Exception {
        check("MS2");
    }
    public void test_MS3() throws Exception {
        check("MS3");
    }
    public void test_MSExtChoice() throws Exception {
        check("MSExtChoice");
    }
    public void test_MSExtChoice2() throws Exception {
        check("MSExtChoice2");
    }
    public void test_NameReuse() throws Exception {
        check("NameReuse");
    }   
    // Contains parallelism of actions, calls merge with parallel=false for basic process
    public void test_ParActionsComm() throws Exception {
        check("ParActionsComm");
    }
    public void test_Paralelismo2a2() throws Exception {
        check("Paralelismo2a2");
    }
    public void test_ParalelismoDoisADois() throws Exception {
        check("ParalelismoDoisADois");
    }
    public void test_ParSimple() throws Exception {
        check("ParSimple");
    }
    public void test_Powers() throws Exception {
        check("Powers");
    }
    public void test_Proc() throws Exception {
        check("Proc");
    }
    public void test_SelfParallel() throws Exception {
        check("SelfParallel");
    }
    public void test_SelfParallel2() throws Exception {
        check("SelfParallel2");
    }
    public void test_SelfParallelism() throws Exception {
        check("SelfParallelism");
    }
    public void test_Simple() throws Exception {
        String projectName = "Simple";
        try {
            (new JCircusControllerText()).translate(dirExamples + "T_" + projectName + ".tex", projectDir, projectName, "Simple", false, false/*, 0, 9*/);
            fail("no exception for Simple.tex");
        } catch (FailTranslationException e) { }
    }
    public void test_SomeParamProc() throws Exception {
        check("SomeParamProc");
    }
    public void test_SyncOnMultiple() throws Exception {
        check("SyncOnMultiple");
    }
    public void test_Tuna() throws Exception {
        check("Tuna");
    }

/*    public void test_comparator() throws Exception {
        
        File two = new File ("D:\\Angela\\Research\\Java\\Tests\\Generated\\AxDef\\src\\AxDef");
        File one = new File ("D:\\Angela\\Research\\Java\\Tests\\Original\\AxDef\\src\\AxDef");
        
        Result r = compareFiles(one, two);
        assertTrue(r.getDescription(), r.isEqual());
    }*/
    
    /**
     * Mthods to compare if two projects are equal.
     */
    
    private void check(String projectName) throws Exception {

        (new JCircusControllerText()).translate(dirExamples + "T_" + projectName + ".tex", projectDir, projectName, /*Sam's*/"", false, false/*, 0, 9*/);      

        if (CHECK) {
            System.out.println("Checking...");
            Result r = projectsEqual(projectName);
            assertTrue(r.getDescription(), r.isEqual());    
        }
    }

    private Result projectsEqual(String projectName) throws FileNotFoundException, IOException {

        File projectDirFile = new File(projectDir + "\\" + projectName + "\\" + sourceDir);
        File originalDirFile = new File(originalDir + "\\" + projectName + "\\" + sourceDir);
        
        return compareFiles(projectDirFile, originalDirFile);
    }
    
    private Result compareFiles(File oFile, File gFile) throws FileNotFoundException, IOException {
        
        if (oFile == null || gFile == null) {
            return new Result(false, "Original " +
                    (oFile == null ? "is null, " : "is not null, ") + 
                    "generated " + 
                    (gFile == null ? "is null, " : "is not null, "));
        }
            
        if (oFile.isDirectory() != gFile.isDirectory()) {
            return new Result(false, "Different types, original (" + oFile.getName() + ") " +
                    (oFile.isDirectory() ? "is a directory, " : "is a file, ") + 
                    "generated (" + gFile.getName() + ") " +
                    (gFile.isDirectory() ? "is a directory." : "is a file."));
        }

        if (!oFile.getName().equals(gFile.getName())) {
            return new Result(false, "Different names, original: " + 
                    oFile.getName() + ", generated: " + gFile.getName());
        }
        
        if (oFile.isFile()) {
            return compareActualFiles(oFile, gFile);
        } else {
            return compareDirectories(oFile, gFile);
        }
        
    }
    
    private Result compareActualFiles(File oFile, File gFile) throws FileNotFoundException, IOException {
        
        FileReader oFileReader = new FileReader(oFile);
        FileReader gFileReader = new FileReader(gFile);
        
        int oc = '&', gc = '&';
        int count = 0;
        
        while (oc != -1) {
            
            oc = oFileReader.read();
            gc = gFileReader.read();
            
            if (oc != gc) 
                return new Result(false, "Files " + oFile.getName() + 
                        " differ at character #" + count + ", original: " + oc +
                        ", new: " + gc);
            
            count++;
        }      
        
        gc = gFileReader.read();
        if (gc != -1) {
            return new Result(false, "Files " + oFile.getName() + 
                        " differ. Original file finished, new: " + gc);
        }
        
        return new Result(true, "");
    }
            
    private Result compareDirectories(File oDir, File gDir) throws FileNotFoundException, IOException {
   
        boolean r = false;
        
        File[] oList = oDir.listFiles();
        File[] gList = gDir.listFiles();
        
        if (oList.length != gList.length) {
            return new Result(false, "Original (" + oDir.getName() + ") has " +
                    oList.length + " members, generated (" + gDir.getName() + ") has " +
                    gList.length + " members.");
        }
        
        File oFile, gFile;
        
        oFile = null;
        for (int i = 0; i < oList.length; i++) {
            
            oFile = oList[i];
            
            gFile = null;
            for (int j = 0; j < gList.length; j++) {
                
                if (oFile.getName().equals(gList[j].getName())) {
                    gFile = gList[j];
                    break;
                }
            }
            
            Result result = compareFiles(oFile, gFile);
            
            if (!result.isEqual()) {
                return result;
            }
        }
        return new Result (true, "");
    }
    
    private class Result {
        
        boolean isEqual;
        String description;
        
        public Result(boolean isEqual, String description) {
            this.isEqual = isEqual;
            this.description = description;
        }
        
        public boolean isEqual() {
            return isEqual;
        }
        
        public String getDescription() {
            return description;
        }
    }
            
    public static void main(String[] sa) {
        //junit.swingui.TestRunner.run(TestJCircus.class); 
    }
    
}


