package jcircus.parallelism;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Vector;

import net.sourceforge.czt.circus.ast.BasicChannelSetExpr;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusChannelSet;
import net.sourceforge.czt.circus.ast.CircusCommunicationList;
import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.CommPattern;
import net.sourceforge.czt.circus.ast.CommUsage;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.ExtChoiceProcess;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.IntChoiceAction;
import net.sourceforge.czt.circus.ast.IntChoiceProcess;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.InterleaveProcess;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.ParallelProcess;
import net.sourceforge.czt.circus.ast.ParamAction;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SeqAction;
import net.sourceforge.czt.circus.ast.SeqProcess;
import net.sourceforge.czt.circus.ast.SkipAction;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.TupleExpr;

/**@author: Samuel Barrocas**/
//Classe implementada para ajudar a criar cpias de aes e processos. Como a rvore sinttica abstrata
	//de Circus possui muitos atributos (e muitos deles esto contidos em classes que so atributos de outras classes, e etc),
	//pode haver uma situao em que instanciamos uma classe sem a instanciao de seus atributos,
	//o que pode levar a uma igualdade indesejada entre os dois objetos (literalmente). 
	// bom observar que, em Java, dois objetos iguais na verdade so o mesmo objeto. 
	//Qualquer modificao em um dos objetos leva  mesma modificao a qualquer outro objeto igual a ele, 
	//e isso, muitas vezes, no  a inteno do programador.

public class ParallelismFactory {
	Factory f = new Factory ();
	public static Expr createExpr (Expr expr) {
		Factory f = new Factory ();
		if (expr instanceof RefExpr) {
			RefExpr exprref = (RefExpr) expr;
			RefExpr ref = f.createRefExpr();
			ref.setExplicit(exprref.getExplicit());
			ref.setExprList(exprref.getExprList());
			ref.setMixfix(exprref.getMixfix());
			ref.setName(exprref.getName());
			ref.getAnns().addAll(exprref.getAnns());
			return ref;
			//return exprref;
		}
		else if (expr instanceof ApplExpr) {
			ApplExpr exprappl = (ApplExpr)expr;
			ApplExpr appl = f.createApplExpr();
			appl.setLeftExpr(exprappl.getLeftExpr());
			appl.setRightExpr(exprappl.getRightExpr());
			appl.setMixfix(exprappl.getMixfix());
			appl.getAnns().addAll(exprappl.getAnns());
			return appl;
		}
		else if (expr instanceof TupleExpr) {
			TupleExpr exprtuple = (TupleExpr) expr;
			TupleExpr tuple = f.createTupleExpr();
			tuple.setExprList(f.createZExprList(exprtuple.getZExprList()));
			tuple.getAnns().addAll (exprtuple.getAnns());
			return tuple;
		}
		/*else if {outras expresses}*/
		else {
			return f.createRefExpr();
		}
	}
	public static Field createField (Field field) {
		Factory f = new Factory ();
		if (field instanceof InputField) {
			InputField nfield = f.createInputField();
			nfield.setVariableName(((InputField)field).getVariableName());
			nfield.setRestriction(((InputField)field).getRestriction());
			nfield.getAnns().addAll(field.getAnns());
			return nfield;
		}
		else /*field instanceof DotField*/{
			DotField nfield = f.createDotField();
			nfield.setExpr(
				//ParallelismFactory.createExpr (((DotField)field).getExpr())
				((DotField)field).getExpr()
			);
			nfield.getAnns().addAll(field.getAnns());
			return nfield;
		}
	}
	public static CircusFieldList createCFL (CircusFieldList cfl) {
		Factory f = new Factory ();
		CircusFieldList cfl2 = f.createCircusFieldList();
		for (int i = 0; i < cfl.size(); i++) {
			cfl2.add(ParallelismFactory.createField(cfl.get(i)));
		}
		cfl2.getAnns().addAll(cfl.getAnns());
		return cfl2;
	}
	public static Communication createCommunication (Communication c) {
		Factory f = new Factory ();
		Communication c2 = f.createCommunication(
				f.createRefExpr(f.createZName(c.getChannelExpr().getName().toString())),
				//f.createCircusFieldList(c.getCircusFieldList()),
				ParallelismFactory.createCFL(c.getCircusFieldList()),
				c.getCommUsage(),
				c.getCommPattern(),
				c.getMultiSych(),
				c.getIndexed()
		);
		c2.getAnns().addAll(c.getAnns());
		return c2;
	}
	public ChannelSet createChannelSet (CircusChannelSet channelSet) { 
		//TODO ESTOU CTICO COM ESTE MTODO. circusChannelSet.setExpr(channelSet.getExpr()) PODE LEVAR AO PROBLEMA DE IGUALDADE ENTRE OBJETOS, QUE SER INDESEJADA!!!!!!!
		CircusChannelSet circusChannelSet = f.createCircusChannelSet();
		BasicChannelSetExpr bcse = f.createBasicChannelSetExpr();
		CircusCommunicationList cl = f.createCircusCommunicationList();
		circusChannelSet.setExpr(channelSet.getExpr());
		return circusChannelSet;
	}
	public CircusAction createCircusAction (CircusAction action) {
		//TODO TESTADO PARCIALMENTE. DEDICAR UMA ATENO ESPECIAL AOS BLOCOS DE AES HIDE, GUARDED, PARALLEL E INTERLEAVE,
			//QUE TEM PERIGO DE ELAS CAREM NA ARMADILHA DA IGUALDADE ENTRE OS OBJETOS
		if (action instanceof ParamAction) {
			Factory f = new Factory ();
			ParamAction param = f.createParamAction();
			param.setDeclList(f.createZDeclList (((ParamAction)action).getZDeclList()));
			param.setCircusAction(createCircusAction (((ParamAction)action).getCircusAction()));
			return param;
		}
		if (action instanceof PrefixingAction) {
			PrefixingAction action2 = (PrefixingAction) action;
			PrefixingAction action3;
			action3 = f.createPrefixingAction();
			action3.setCommunication(ParallelismFactory.createCommunication (action2.getCommunication()));
			action3.setCircusAction(createCircusAction(action2.getCircusAction()));
			action3.getAnns().addAll(action2.getAnns());
			return action3;
		}
		else if (action instanceof ExtChoiceAction) {
			ExtChoiceAction action2 = (ExtChoiceAction) action;
			ExtChoiceAction eca = f.createExtChoiceAction();
			eca.setLeftAction(createCircusAction (action2.getLeftAction()));
			eca.setRightAction(createCircusAction (action2.getRightAction()));
			eca.getAnns().addAll(action2.getLeftAction().getAnns());
			eca.getAnns().addAll(action2.getRightAction().getAnns());
			return eca;
		}
		else if (action instanceof IntChoiceAction) {
			IntChoiceAction action2 = (IntChoiceAction) action;
			IntChoiceAction ica = f.createIntChoiceAction();
			ica.setLeftAction(createCircusAction (action2.getLeftAction()));
			ica.setRightAction(createCircusAction (action2.getRightAction()));
			ica.getAnns().addAll(action2.getLeftAction().getAnns());
			ica.getAnns().addAll(action2.getRightAction().getAnns());
			return ica;
		}
		else if (action instanceof ParallelAction) {
			ParallelAction action2 = (ParallelAction) action;
			ParallelAction pa = f.createParallelAction();
			pa.setLeftAction(createCircusAction (action2.getLeftAction()));
			pa.setRightAction(createCircusAction (action2.getRightAction()));
			pa.setLeftNameSet(action2.getLeftNameSet());
			pa.setRightNameSet(action2.getRightNameSet());
			pa.setChannelSet(createChannelSet ((CircusChannelSet) action2.getChannelSet()));
			pa.getAnns().addAll(action2.getLeftAction().getAnns());
			pa.getAnns().addAll(action2.getRightAction().getAnns());
			return pa;
		}
		else if (action instanceof InterleaveAction) {
			InterleaveAction action2 = (InterleaveAction) action;
			InterleaveAction pa = f.createInterleaveAction();
			pa.setLeftAction(createCircusAction (action2.getLeftAction()));
			pa.setRightAction(createCircusAction (action2.getRightAction()));
			pa.setLeftNameSet(action2.getLeftNameSet());
			pa.setRightNameSet(action2.getRightNameSet());
			pa.getAnns().addAll(action2.getLeftAction().getAnns());
			pa.getAnns().addAll(action2.getRightAction().getAnns());
			return pa;
		}
		else if (action instanceof SeqAction) {
			SeqAction action2 = (SeqAction) action;
			SeqAction pa = f.createSeqAction();
			pa.setLeftAction(createCircusAction (action2.getLeftAction()));
			pa.setRightAction(createCircusAction (action2.getRightAction()));
			pa.getAnns().addAll(action2.getLeftAction().getAnns());
			pa.getAnns().addAll(action2.getRightAction().getAnns());
			return pa;
		}
		else if (action instanceof CallAction) {
			CallAction action2 = f.createCallAction ();
			action2.setName(((CallAction)action).getName());
			action2.setExprList(((CallAction)action).getExprList());
			return action2;
		}
		else if (action instanceof GuardedAction) {
			GuardedAction action2 = (GuardedAction)action;
			GuardedAction action3 = f.createGuardedAction();
			action3.setCircusAction(createCircusAction (action2.getCircusAction()));
			action3.setPred(action2.getPred());
			return action3;
		}
		else if (action instanceof HideAction) {
			HideAction action2 = (HideAction)action;
			HideAction action3 = f.createHideAction();
			action3.setCircusAction(createCircusAction (action2));
			action3.setChannelSet(createChannelSet ((CircusChannelSet)action2.getChannelSet()));
			return action3;
		}
		else if (action instanceof SkipAction) {
			return f.createSkipAction();
		}
		else {
			return f.createStopAction();
		}
	}
	public CircusProcess createCircusProcess (CircusProcess process) {
		//TODO NO TESTADO! DEDICAR UMA ATENO ESPECIAL AOS BLOCOS DE AES HIDE, GUARDED, PARALLEL E INTERLEAVE,
			//QUE TEM PERIGO DE ELAS CAREM NA ARMADILHA DA IGUALDADE ENTRE OS OBJETOS
		if (process instanceof ParamProcess) {
			Factory f = new Factory ();
			ParamProcess param = f.createParamProcess();
			param.setDeclList(((ParamProcess)process).getDeclList());
			param.setCircusProcess(createCircusProcess (((ParamProcess)process).getCircusBasicProcess()));
			return param;
		}
		else if (process instanceof BasicProcess) {
			Factory f = new Factory ();
			BasicProcess basic = f.createBasicProcess();
			basic.setParaList(((BasicProcess)process).getParaList());
			return basic;
		}
		else if (process instanceof ExtChoiceProcess) {
			ExtChoiceProcess process2 = (ExtChoiceProcess) process;
			ExtChoiceProcess ecp = f.createExtChoiceProcess();
			ecp.setLeftProcess(createCircusProcess (process2.getLeftProcess()));
			ecp.setRightProcess(createCircusProcess (process2.getRightProcess()));
			ecp.getAnns().addAll(process2.getLeftProcess().getAnns());
			ecp.getAnns().addAll(process2.getRightProcess().getAnns());
			return ecp;
		}
		else if (process instanceof IntChoiceProcess) {
			IntChoiceProcess process2 = (IntChoiceProcess) process;
			IntChoiceProcess ecp = f.createIntChoiceProcess();
			ecp.setLeftProcess(createCircusProcess (process2.getLeftProcess()));
			ecp.setRightProcess(createCircusProcess (process2.getRightProcess()));
			ecp.getAnns().addAll(process2.getLeftProcess().getAnns());
			ecp.getAnns().addAll(process2.getRightProcess().getAnns());
			return ecp;
		}
		else if (process instanceof ParallelProcess) {
			ParallelProcess process2 = (ParallelProcess) process;
			ParallelProcess pp = f.createParallelProcess();
			pp.setLeftProcess(createCircusProcess (process2.getLeftProcess()));
			pp.setRightProcess(createCircusProcess (process2.getRightProcess()));
			pp.setChannelSet(createChannelSet ((CircusChannelSet) process2.getChannelSet()));
			pp.getAnns().addAll(process2.getLeftProcess().getAnns());
			pp.getAnns().addAll(process2.getRightProcess().getAnns());
			return pp;
		}
		else if (process instanceof InterleaveProcess) {
			InterleaveProcess process2 = (InterleaveProcess) process;
			InterleaveProcess pp = f.createInterleaveProcess();
			pp.setLeftProcess(createCircusProcess (process2.getLeftProcess()));
			pp.setRightProcess(createCircusProcess (process2.getRightProcess()));
			pp.getAnns().addAll(process2.getLeftProcess().getAnns());
			pp.getAnns().addAll(process2.getRightProcess().getAnns());
			return pp;
		}
		else if (process instanceof SeqProcess) {
			SeqProcess process2 = (SeqProcess) process;
			SeqProcess pa = f.createSeqProcess();
			pa.setLeftProcess(createCircusProcess (process2.getLeftProcess()));
			pa.setRightProcess(createCircusProcess (process2.getRightProcess()));
			pa.getAnns().addAll(process2.getLeftProcess().getAnns());
			pa.getAnns().addAll(process2.getRightProcess().getAnns());
			return pa;
		}
		else if (process instanceof CallProcess) { //TODO MANTER O OLHO AQUI!!!! getCallExpr pode no ser suficiente para evitar o problema da igualdade indesejada entre objetos
			CallProcess process2 = f.createCallProcess ();
			process2.setCallExpr(((CallProcess)process).getCallExpr());
			process2.setActuals(((CallProcess) process).getActuals());
			process2.setUsage(((CallProcess) process).getUsage());
			//process2.setCallExpr(arg0)setExprList(((CallProcess)process).getCallExpr().getExprList());
			return process2;
		}
		else if (process instanceof HideProcess) {
			HideProcess process2 = (HideProcess) process;
			HideProcess process3 = f.createHideProcess();
			process3.setCircusProcess(createCircusProcess (process2));
			process3.setChannelSet(createChannelSet ((CircusChannelSet)process2.getChannelSet()));
			return process3;
		}
		else { //TODO TALVEZ AQUI PRECISE DE MAIS AJUSTES...
			return f.createBasicProcess();
		}
	}
}
