package jcircus.exceptions;

import jcircus.util.ChanSync;

/**
 * This exception is thrown in the method put() of ChannelSyncEnvironment.
 * It is thrown when we try to insert an already defined channel with diferent type.
 *
 * @author aff
 *
 */
public class ChanDefOtherChanSyncException extends Exception {
    
    private String channelName;
    private ChanSync chanSync, newChanSync;
    
    public String getChannelName() {
        return this.channelName;
    }
    
    public ChanSync getChanSync() {
        return this.chanSync;
    }
    
    public ChanSync getNewChanSync() {
        return this.newChanSync;
    }
    
    public ChanDefOtherChanSyncException(String channelName, ChanSync chanSync, ChanSync newChanSync) {
        this.channelName = channelName;
        this.chanSync = chanSync;
        this.newChanSync = newChanSync;
    }
    
}
