package jcircus.environment;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;

import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.ZBranchList;

/**
 * FreeTypeEnv.java
 *
 * @author Angela Freitas
 */
public class FreeTypeEnv {
    
    /**
     * Attribute
     */
    private List<Freetype> freeTypeEnv_;
    
    /**
     * Constructor
     *
     */
    public FreeTypeEnv() {
        this.freeTypeEnv_ = new ArrayList();
    }
    
    /**
     *
     * @param freetype
     */
    public void add(Freetype freetype) {
        this.freeTypeEnv_.add(freetype);
    }
    
    /**
     *
     * @param i
     * @return
     */
    public Freetype get(int i) {
        return (Freetype) this.freeTypeEnv_.get(i);
    }
    
    /**
     *
     * @return
     */
    public int size() {
        return this.freeTypeEnv_.size();
    }
    
    /**
     * 
     * @param name
     * @return
     */
    public boolean isFreeType(String name) {
        
        boolean r = false;
        Freetype freetype;
        
        for (int i=0; i < this.freeTypeEnv_.size(); i++) {
            
            freetype = (Freetype) this.freeTypeEnv_.get(i);
            if (name.equals(freetype.getZName()/*getDeclName()*/.toString())) {
                r = true;
            }
        }
        
        return r;
    }
    
    /**
     * 
     * @param name
     * @return
     */
    public boolean isElementFreeType(Name identifier) {
        
        boolean r = false;
        Freetype freetype;
        ZBranchList/*ListTerm*/ branches;
        ZBranchList zbl;
        Branch branch;
        
        for (int i = 0; i < this.freeTypeEnv_.size(); i++) {
            
            freetype = (Freetype) this.freeTypeEnv_.get(i);
            branches = (ZBranchList)(freetype./*getBranch()*/getBranchList());
            //anterior: branches = freetype.getBranch();
            
            for (int j=0; j<branches.size(); j++) {
                
                branch = (Branch) branches.get(j);
                if (identifier.toString().equals(branch.getZName().toString())) {
                    r = true;
                }
            }
        }
        
        return r;
    }

    /**
     * Return true if 'element' is an element of free type 'freeTypeName'; 
     * false otherwise, or if 'freeTypeName' is not a free type
     *
     */
    public boolean isElementFreeType(String freeTypeName, String element) {    
        
        boolean r = false;
        
        for (int i = 0; i < this.freeTypeEnv_.size(); i++) {
            
            Freetype freetype = (Freetype) this.freeTypeEnv_.get(i);
            
            if (freetype.getZName().toString().equals(freeTypeName)) {
                ZBranchList/*ListTerm*/ branches = (ZBranchList)(freetype.getBranchList())/*getBranch()*/;
                //Anterior: ListTerm branches = freetype.getBranch();
                
                for (int j=0; j<branches.size(); j++) {

                    Branch branch = (Branch) branches.get(j);
                    if (element.toString().equals(branch.getZName().toString())) {
                        r = true;
                    }
                }
            }
        }
        
        return r;
    }
    
    /**
     * Receives an element of a free type, returns the corresponding free type.
     * @param name
     * @return
     */
    public String getNameFreeType(Name identifier) {
        
        String r = null;
        Freetype freetype;
        ZBranchList/*ListTerm*/ branches;
        Branch branch;
        
        for (int i = 0; i < this.freeTypeEnv_.size(); i++) {
            
            freetype = (Freetype) this.freeTypeEnv_.get(i);
            
            branches = (ZBranchList)(freetype.getBranchList())/*getBranch()*/;
            //branches = freetype.getBranch();
            
            for (int j = 0; j < branches.size(); j++) {
                
                branch = (Branch) branches.get(j);
                if (identifier.toString().equals(branch.getZName().toString())) {
                    r = freetype.getZName().toString();
                }
            }
        }
        
        return r;
    }
    
}
