package jcircus.environment;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/**
 * ChannelSetEnv.java
 *
 * @author Angela Freitas
 */
public class ChannelSetEnv {
    
    /**
     * Associates the name of the channel set to a vector of names of sets
     *
     */
    private Map<String, Set<String>> _map;
    
    /**
     * Constructor.
     */
    public ChannelSetEnv() {
        _map = new LinkedHashMap<String, Set<String>>();
    }
    
    /**
     *
     * @param chanSetName
     * @param channelSet
     */
    public void insert(String chanSetName, Set<String> channelSet) {
        _map.put(chanSetName, channelSet);
    }
    
    /**
     *
     * @param chanSetName
     * @return
     */
    public Set<String> get(String chanSetName) {
        return _map.get(chanSetName);
    }
    
    /**
     * Insert a channel name in a channel set name in this collection.
     *
     * @param chanSetName
     * @param nameChannel
     */
    public void insert(String chanSetName, String chanName) {
        
        Set<String> set;
        
        if (this._map.containsKey(chanSetName))
            set = _map.get(chanSetName);
        else
            set = new LinkedHashSet<String>();
        
        set.add(chanName);
        _map.put(chanSetName, set);
    }
    
}
