package jcircus.complexcomms;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class CCMapsGenerator {
	private String code = "";
	private String packageDecl;
	private String path;
	private String procName;
	private int index;
	public CCMapsGenerator (String paper, String src, String projectDir, String specName, String procName, int index) {
		this.packageDecl = "package " + /*specName + "." +*/ paper + "." + src + "." + paper + "." + "ccmaps" + ";\n";
		this.path = projectDir + "\\" + paper + "\\" + src + "\\" + paper + "\\ccmaps\\CCMaps_" + procName + "_" + index + ".java";
		this.procName = procName;
		this.index = index;
	}
	
	public void concatCode (String str) {
		this.code = this.code + str;
	}
	public String totalCode () {
		return
		this.packageDecl +
		"import java.util.HashMap;\n" +
		"import java.math.BigInteger;\n" +
		"import java.util.Vector;\n" +
		"public class CCMaps_" + procName + "_" + this.index + " {\n" +
		"	/*public int abs (String chan, int element, BigInteger bi) {\n" +
		"		return this.env_channels.get(chan).elementAt(element).indexOf(bi);\n" +
		"	}*/\n" +
		this.code
		+ "}\n";
	}
	public void generate() {
		try {
			BufferedWriter bw = new BufferedWriter (new FileWriter (this.path));
			bw.write(this.totalCode());
			bw.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	//Modelo do codigo que será gerado:
	/*
	 *	public class CCMaps {
	 *		HashMap <String, Vector <Vector <BigInteger>>> env_channels = new HashMap <String, Vector <Vector <BigInteger>>> ();
	 *		public void makeEnvChannels () {
	 *			
	 *		}
	 *	}
	 * */
}