package jcircus.complexcomms;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Vector;

public class AbsCommValuesGenerator { //Armazena todos os valores absolutos de cada canal. O acesso aos valores da comunicação serão feitos através de cada valor absoluto da especificação
	private String code = "";
	private String packageDecl;
	private String path;
	private String chanName;
	private Vector <Vector <BigInteger>> vv;
	public AbsCommValuesGenerator (String paper, String src, String projectDir, String specName, String chanName, Vector <Vector <BigInteger>> vv) {
		this.packageDecl = "package " + /*specName + "." +*/ paper + "." + src + "." + paper + "." + "channels" + ";\n";
		this.path = projectDir + "\\" + paper + "\\" + src + "\\" + paper + "\\channels\\Abs_" + chanName + ".java";
		this.chanName = chanName;
		this.vv = vv;
	}

	public void concatCode (String str) {
		this.code = this.code + str;
	}
	public String totalCode () {
		return
		this.packageDecl +
		"import java.util.HashMap;\n" +
		"import java.math.BigInteger;\n" +
		"import java.util.Vector;\n" +
		"public class Abs_" + chanName + /*"_" + this.index +*/ " {\n" +
		/*"	public HashMap <String, Vector <Vector <BigInteger>>> env_channels = new HashMap <String, Vector <Vector <BigInteger>>> ();\n"	+
		"	Vector <BigInteger> subSet;\n" +
		"	Vector <Vector <BigInteger>> set;\n" +*/
		"	public int abs (String chan, int element, BigInteger bi) {\n" +
		"		return this.env_channels.get(chan).elementAt(element).indexOf(bi);\n" +
		"	}\n" +
		"	/*public String toString (String chan, int element, ) {\n" +
		"		" +
		"	}\n*/" +
		"	public Abs_" + this.chanName + "() {\n" +
		"		makeEnvChannels ();\n" +
		"	}\n" +
		CCUtil.makeEnvChannelsCode(this.chanName, this.vv) +
		/*"		env_channels.put (\"" + this.chanName + "\", " + "set" + ");\n" +*/

		this.code
		+ "}\n";
	}
	public void generate() {
		try {
			BufferedWriter bw = new BufferedWriter (new FileWriter (this.path));
			bw.write(this.totalCode());
			bw.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
