package jcircus.complementaryenvs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

//@author: Samuel Lincoln M Barrocas
	//Maps a process name to its arity: True if the process is unary, and false if n-ary, with n > 1. For example:
		//A prefixing process is an unary process. So, it is mapped to true.
		//Parallel, external choice and internal choice processes are binary processes, so they are mapped to false.
public class ParProcessEnv {
	private HashMap <String, Boolean> _map;
	
    public ParProcessEnv () {
        this._map = new LinkedHashMap<String, Boolean>();
    }
	public void put (String channelName, boolean b) {
		this._map.put(channelName, b);
	}
	public boolean get (String channelName) {
		return (boolean) this._map.get(channelName);
	}
	public HashMap <String, Boolean> getMap () {
		return this._map;
	}
	public void set (String channelName, boolean b) {
		if (this._map.containsKey(channelName)/*this.get (channelName) != (new Integer (null)).intValue()*/) {
			this._map.remove(channelName);
		}
		this._map.put(channelName, b);
	}
    public Iterator<String> iteratorKeys() {
        return this._map.keySet().iterator();
    }

}