package jcircus.complementaryenvs;

import java.util.HashMap;
import java.util.LinkedHashMap;

import net.sourceforge.czt.circus.ast.CircusFieldList;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.OutputFieldAnn;

//@author: Samuel Lincoln M. Barrocas
	//Checks if a channel is used at least one time as a communication with its last field being a dot field
public class ChanDotFieldEnv {
	private HashMap map;
	public ChanDotFieldEnv () {
		this.map = new LinkedHashMap <String, Boolean> ();
	}
	private void put (String channel, Boolean b) {
		if (!this.map.containsKey (channel))
			this.map.put(channel, b);
		if (!((Boolean)this.map.get(channel))) {
			this.map.put(channel, b);
		}
	}
    public static boolean hasOutputFieldAnn (Field field) {
    	if (!(field instanceof DotField)) {
    		return false;
    	}
    	for (int i = 0; i < field.getAnns().size(); i++) {
    		if (field.getAnns().get(0) instanceof OutputFieldAnn) {
    			return true;
    		}
    	}
    	return false;
    }

	public void put (Communication c) {
		CircusFieldList cfl = c.getCircusFieldList();
		if (cfl.size() == 0) {
			this.put(c.getChannelExpr().getZName().toString(), false);			
		}
		else if (cfl.get(cfl.size() - 1) instanceof DotField && !hasOutputFieldAnn (cfl.get(cfl.size() - 1))) {
			this.put(c.getChannelExpr().getZName().toString(), true);
		}
		else {
			this.put(c.getChannelExpr().getZName().toString(), false);
		}
	}
	public Boolean get (String channel) {
		return (Boolean) this.map.get(channel);
	}
}