package paper.src.paper.typing;

 /**/

public class CircusInteger extends Type {
    
    public static final int MIN_VALUE = -10;
    public static final int MAX_VALUE = 10;
    
    public CircusInteger(int value) {
        super.setValue(value);
    }
    
    public CircusInteger(String st) {
        super.setValue(Integer.parseInt(st));
    }
    
    public String toString() {
        return this.getValue() + "";
    }
    
    public CircusInteger add(CircusInteger other) {
        return new CircusInteger(this.getValue() + other.getValue());
    }
    
    public CircusInteger sub(CircusInteger other) {
        return new CircusInteger(this.getValue() - other.getValue());
    }
    
    public CircusInteger mult(CircusInteger other) {
        return new CircusInteger(this.getValue() * other.getValue());
    }
    
    public CircusInteger div(CircusInteger other) {
        return new CircusInteger(this.getValue() / other.getValue());
    }
    
    public CircusInteger mod(CircusInteger other) {
        return new CircusInteger(this.getValue() % other.getValue());
    }
    
    public CircusInteger negate() {
        return new CircusInteger(-this.getValue());
    }

    public boolean lessEqual(CircusInteger other) {
        return this.getValue() <= other.getValue();
    }

    public boolean greaterEqual(CircusInteger other) {
        return this.getValue() >= other.getValue();
    }

    public boolean less(CircusInteger other) {
        return this.getValue() < other.getValue();
    }

    public boolean greater(CircusInteger other) {
        return this.getValue() > other.getValue();
    }

    public boolean equals(CircusInteger other) {
        return this.getValue() == other.getValue();
    }
        
}
