package paper.src.paper.typing;

import newjcircusutil.multisync.*;
import newjcircusutil.*;
import org.jcsp.lang.*;

public class GCArray {
	public static GeneralChannel create0Array (ChannelInfo channelInfo, Integer procId, AltingBarrier [] barrier) {
		return new GeneralChannel (channelInfo, procId);
	}
	public static GeneralChannel create0Array (GeneralChannel generalChannel, Integer procId) {
		return new GeneralChannel (generalChannel, procId);
	}
	public static GeneralChannel create0Array (ChannelInfo chanInfo, Integer procId) {
		return new GeneralChannel (chanInfo, procId);
	}
	public static GeneralChannel [] create1Array (ChannelInfo channelInfo, Integer procId, AltingBarrier [] barrier, int size) {
		GeneralChannel [] c = new GeneralChannel [size];
		for (int i = 0; i < size; i++) {
			c [i] = create0Array (channelInfo, procId, barrier);
		}
		return c;
	}
	public static GeneralChannel [] create1Array (ChannelInfo channelInfo, Integer procId) {
		return create1Array (channelInfo, procId, AltingBarrier.create (channelInfo.getTable().size()), 10);
	}

	public static GeneralChannel [] create1Array (GeneralChannel []generalChannel, Integer procId, int size) {
		GeneralChannel [] c = new GeneralChannel [size];
		for (int i = 0; i < size; i++) {
			c [i] = create0Array (generalChannel [i], procId);
		}
		return c;
	}
	public static GeneralChannel [] create1Array (GeneralChannel [] generalChannel, Integer procId) {
		return create1Array (generalChannel, procId, 10);
	}

	public static GeneralChannel [][] create2Array (ChannelInfo channelInfo, Integer procId, AltingBarrier [] barrier, int size) {
		GeneralChannel [][] c = new GeneralChannel [size][size];
		for (int i = 0; i < size; i++) {
			c [i] = create1Array (channelInfo, procId, barrier, size);
		}
		return c;
	}
	public static GeneralChannel [][] create2Array (ChannelInfo channelInfo, Integer procId) {
		return create2Array (channelInfo, procId, AltingBarrier.create (channelInfo.getTable().size()), 10);
	}

	public static GeneralChannel [][] create2Array (GeneralChannel [][]generalChannel, Integer procId, int size) {
		GeneralChannel [][] c = new GeneralChannel [size][size];
		for (int i = 0; i < size; i++) {
			c [i] = create1Array (generalChannel [i], procId);
		}
		return c;
	}
	public static GeneralChannel [][] create2Array (GeneralChannel [][] generalChannel, Integer procId) {
		return create2Array (generalChannel, procId, 10);
	}

	public static GeneralChannel [][][] create3Array (ChannelInfo channelInfo, Integer procId, AltingBarrier [] barrier, int size) {
		GeneralChannel [][][] c = new GeneralChannel [size][size][size];
		for (int i = 0; i < size; i++) {
			c [i] = create2Array (channelInfo, procId, barrier, size);
		}
		return c;
	}
	public static GeneralChannel [][][] create3Array (ChannelInfo channelInfo, Integer procId) {
		return create3Array (channelInfo, procId, AltingBarrier.create (channelInfo.getTable().size()), 10);
	}

	public static GeneralChannel [][][] create3Array (GeneralChannel [][][]generalChannel, Integer procId, int size) {
		GeneralChannel [][][] c = new GeneralChannel [size][size][size];
		for (int i = 0; i < size; i++) {
			c [i] = create2Array (generalChannel [i], procId);
		}
		return c;
	}
	public static GeneralChannel [][][] create3Array (GeneralChannel [][][] generalChannel, Integer procId) {
		return create3Array (generalChannel, procId, 10);
	}

}
