/*
 * JCircusControllerFrame.java
 */

package jcircus;

import java.util.List;
import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTranslationException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.exceptions.JCircusException;
import jcircus.exceptions.TranslationCancelledException;
import jcircus.gui.JCircusFrame;
import jcircus.translator.Translator2Java;
import jcircus.util.Constants;
import jcircus.util.MathToolkitConstants;
import jcircus.util.ProcInfo;
import jcircus.util.Error;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.typecheck.z.ErrorAnn;

public class JCircusControllerFrame extends JCircusController {
    
    /* GUI */
    private JCircusFrame _jCircusFrame;
    
    /**
     * Constructor.
     */
    public JCircusControllerFrame() {
        // Create and show the gui using invokeLater to guarantee
        // thread safeness
    	//System.out.println ("Começou JCircusControllerFrame");
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                _jCircusFrame = new JCircusFrame(JCircusControllerFrame.this);
                _jCircusFrame.showGui();
            }
        });
    	//System.out.println ("Terminou JCircusControllerFrame");
    }

    public JCircusControllerFrame (boolean b) {
    	
    }
    protected void translate2Java (String projectDir, String projectName, Spec spec, String compl, boolean useBarriers, boolean parallelism/*, int minComm, int maxComm*/)
            throws FailTranslationException, TranslationCancelledException, JCircusException {

    	_translator = new Translator2Java(projectDir, projectName, spec, compl, useBarriers, parallelism);

        _translator.translate(true);

        // Prompt for the processes for each we want a main and 
        // prompt for the parameters, in case of parameterised processes
        List<ProcInfo> procInfoList = _translator.getProcInfoList();
        
        _jCircusFrame.promptForMainProcesses(procInfoList);

        for (int i = 0; i < procInfoList.size(); i++) {
            ProcInfo procInfo = procInfoList.get(i);

            if (procInfo.getCreateMain() == true &&
                    procInfo.getParameters() != null &&
                    !procInfo.getParameters().isEmpty()) {

                _jCircusFrame.promptForParameters(procInfo);
            }
        }
        
        // Create the source code files
        _translator.createSources(); 
    }
    
    protected void reportMessage (String message) {
        _jCircusFrame.reportMessage(message);
    }
    
    /**
     *
     */
    protected void reportParsingErrors(List<String> errors) {

        String message = parsingErrorMessage(errors);
        reportMessage(message);
    }
    
    /**
     *
     */
    protected void reportTypeCheckingErrors(List<ErrorAnn> errors) {

        String message = typeCheckingErrorMessage(errors);
        reportMessage(message);
    }

    /**
     *
     */
    protected void reportTranslationErrors(List<Error> errors) {
        
        String message = translationErrorMessage(errors);
        reportMessage(message);
    }
    
    /**
     * Receives the expression that was entered in the text field and the type
     * that it should correspond. This method is a gambi... It is okay,
     * because of the restrictions on the format of a declaration (the expression
     * must be always a RefExpr). This method performs >>fake<< parsing, typechecking
     * and translation to Java. Come back here in the future, when we will be dealing
     * with more kinds of types and expressions, and change the respective bits
     * of code for calls to the real parser, type checker and translator.
     *
     */
    public String codeForParameter(String expression, Expr typeExpr)
            throws FailParsingException, FailTypeCheckingException {
        String code = "";

        // For the moment, typeExpr will be always a reference. This will be
        // changed in the future. Probably this method will receive the actual
        // Type, instead of the type expression.
        assert(typeExpr instanceof RefExpr);
        
/*LM*/        String typeExprSt = ((RefExpr) typeExpr).getName().toString();//.getRefName().toString();

        if (typeExprSt.equals(MathToolkitConstants.NAT) ||
                typeExprSt.equals(MathToolkitConstants.NUM) ||
                typeExprSt.equals(MathToolkitConstants.ARITHMOS)) {

            // Number
            try {

                // Simulate parsing/typeChecking here
                int number = Integer.parseInt(expression);
                code = "new " + Constants.CLS_CIRCNUM + "(" + number + ")";

            } catch (NumberFormatException nfe) {

                // Error
                List<String> errors = new Factory().list("Expression is not a number.");
                throw new FailParsingException(errors);
            }

        } else {
            
            // Free type
            if (_translator.getEnvironment().isElementFreeType(typeExprSt, expression)) {
                
                // Simulate parsing/typeChecking here
                code = "new " + typeExprSt + "(" + typeExprSt + "." + expression + ")";

            } else {
                
                // Error
                List<String> errors = new Factory().list("Expression is not an element of free type.");
                throw new FailParsingException(errors);
            }
        }
            
        return code;
    } 
    
    /**
     * Cancel the translation.
     */
    public void cancelTranslation () throws TranslationCancelledException {
        throw new TranslationCancelledException();
    }
}
