package circusRefine.util.docgenerator;

import java.util.List;

import javax.swing.JOptionPane;

import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.ChannelDecl;
import net.sourceforge.czt.circus.ast.ChannelPara;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.NameSet;
import net.sourceforge.czt.circus.ast.NameSetPara;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.TransformerPara;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.Box;
import net.sourceforge.czt.z.ast.ConjPara;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.FreePara;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.GivenPara;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.NumStroke;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZFreetypeList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.z.util.ZUtils;
import circusRefine.core.NoPrograma;
import circusRefine.core.Relacionamento;
import circusRefine.core.print.ParaPrint;
import circusRefine.core.print.Printer;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;

public class ParaPrintLatex extends ParaPrint {

	public ParaPrintLatex(DocGenerator printer) {
		super(printer);
	}
	
	/**
	 * Remocao da opo de imprimir em Unicode
	 * Retirada do ambiente circus
	 */
	public Object visitChannelPara(ChannelPara term) 
	{	
		getPercurso().append("Channel PAra\n");
		String result[] = null;

		result = new String[1];
		ZDeclList chanDecls = (ZDeclList)term.getZDeclList();

		String strDecls = "";
		int size = chanDecls.size();
		int counter = 0;
		boolean isChannelFromDecl = false;
		for (Decl chanDecl : chanDecls) {
			if (chanDecls.size() == 1) {
				ChannelDecl chandecl = (ChannelDecl)chanDecl;
				if (chandecl.getZChannelNameList().size() == 0) {
					isChannelFromDecl = true;
				}

			}
			strDecls = strDecls + ((String[])chanDecl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + "; ";
			}
			counter++;
		}
		if (!isChannelFromDecl) {
			result[0] = BRANCO + "\\circchannel\\ " + strDecls;
		}
		else {
			result[0] = BRANCO + "\\circchannelfrom\\ " + strDecls;
		}

		return result;
	}
		
	/**
	 * Remocao da opo de imprimir em Unicode
	 * Retirada do ambiente circus
	 */
	public Object visitChannelSetPara(ChannelSetPara term)
	  {
		getPercurso().append("ChannelSetPara\n");
		  
		  ZName name = (ZName)term.getName();
		  ChannelSet chanSet = term.getChannelSet();
		  String strName = name.getWord();
		  String strChanSet = ((String[])chanSet.accept(exprPrint()))[0];
		  
		  ZNameList genericParams = (ZNameList)term.getGenFormals();
		  
		  String[] result = null;	  
		 
		  if (!getUnicoded()) {
			  
			  result = new String[1];
			  result[0] = BRANCO + "\\circchannelset\\ ";
			  if (genericParams.isEmpty()){
				  result[0] = result[0] + strName + " == " + strChanSet;
			  }
			  else{
				  boolean first = true;
				  result[0] = result[0] + "[";
				  for (Name nome : genericParams){
					  ZName nombre = (ZName)nome;
					  if (first) first = false;
					  else result[0] = result[0] + Space + ZString.COMMA + Space;
					  result[0] = result[0] + nombre.getWord();
				  }
				  result[0] = result[0] + "]";
				  
				  result[0] = result[0]+ Space + strName + " == " + strChanSet;
			  }
		  }
		  
		  
		  return result;
	  }
	
	/**
	 * Remocao da opo de imprimir em Unicode
	 * Retirada do ambiente circus
	 */
	public Object visitProcessPara(ProcessPara term)
	  {
		  String[] result = null;

		  getPercurso().append("ProcessPara\n");
		  
		  // guarda a Liha Inicial para setar o Relacionamento
		  
		  List<Name> genParams = (ZNameList)term.getGenFormals();

		  CircusProcess circProc = term.getCircusProcess();

		  String strName = ((String[])term.getName().accept(namePrint()))[0];
		  

		  String[] strProc = (String[])circProc.accept(processPrint());
		  String strGenParams = "";

		  int size = genParams.size();

		  int counter = 0;
		  for(Name ndecl : genParams) {

			  ZName decl = (ZName)ndecl;

			  if(counter == 0) {
				  strGenParams = "[";
			  }
			  strGenParams = strGenParams + decl.getWord();
			  if(counter < size-1) {
				  strGenParams = strGenParams + ",";
			  } 
			  else if(counter == size-1) {
				  strGenParams = strGenParams + "]";
			  }
			  counter++;
		  }

		  //LATEX
		  int index = 1;
		  result = new String[strProc.length + 1];
		  result[0] = BRANCO + "\\circprocess\\" + Space + strGenParams + Space + strName + " \\circdef \\\\";
		  for(int i=0; i<strProc.length; i++) {
			  result[index++] = BRANCO + "\\t1 " + strProc[i];
		  }
		  return result;
	  }

	/**
	 * Retirada do ambiente circus que ficou a cargo do visitor de ZSect
	 */
	public Object visitNameSetPara(NameSetPara term)
	{
		String[] result = new String[1];

		getPercurso().append("NameSet\n");

		ZName name = (ZName)term.getName();
		NameSet ns = term.getNameSet();

		String strName = name.getWord();
		String strNS = ((String[])ns.accept(exprPrint()))[0];

		result[0] = BRANCO + strName + " == " + strNS;

		return result;
	}
	
	/**
	 * Retirada do ambiente circus que ficou a cargo do visitor de ZSect
	 */
	public Object visitGivenPara(GivenPara givenPara)
	{
		String[] result = null;
		result = new String[1];
		getPercurso().append("GivenPAra\n");
		List<Name> Names = givenPara.getZNameList();

		int counter = 0;
		int size = Names.size();
		String strDecl = "";
		for (Name name : Names) {
			ZName nombre = (ZName)name;
			strDecl = strDecl + nombre.getWord();
			if(counter < size-1) {
				strDecl = strDecl + ",";
			}
			counter++;
		}
		result[0] = BRANCO + "[" + strDecl + "]";

		return result;
	}
	
	public Object visitFreePara(FreePara freePara)
	{
		String[] result = null;

		getPercurso().append("FreePara\n");

		List<Freetype> freetypes = (ZFreetypeList)freePara.getFreetypeList();
		String strFT = "";

		int size = freetypes.size();
		int counter = 0;
		for (Freetype freetype : freetypes) {
			strFT = strFT + ((String[])freetype.accept(this))[0];
			if(counter < size-1) {
				strFT = strFT + Space + ZString.AMP+ Space;
			}
			counter++;
		}
		result = new String[1];
		result[0] = BRANCO + strFT;


		return result;
	}
	
	
	public Object visitConjPara(ConjPara conjPara)
	{
		String[] result = new String[3];
		result = new String[1];
		getPercurso().append("ConjPara\n");

		Pred pred = conjPara.getPred();
		List<Name> genParams = conjPara.getZNameList();

		String strPred = ((String[])pred.accept(predPrint()))[0];
		String strGP = "";

		if(genParams != null && genParams.size() != 0) {
			int size = genParams.size();
			int counter = 0;
			for(Name name : genParams) {
				ZName nombre = (ZName) name;
				if(counter == 0) {
					strGP = "[";
				}
				strGP = strGP + nombre.getWord();
				if(counter < size-1) {
					strGP = strGP + ",";
				}
				else if(counter == size-1) {
					strGP = strGP + "]";
				}
			}
		}
		result[0] = BRANCO + strGP + Space + "\\vdash" + Space + strPred;

		return result;
	}
	

	public Object visitTransformerPara (TransformerPara trans) {

		getPercurso().append("TransformerPara\n");
		String aux[] = null;
		String []result= (String[])trans.getTransformerPred().accept(predPrint());

		return result;
	}

	
	
//	 PParagraph ::= N \defs ActionDefinition
	  // ok - verificado em 25/09/2005 s 10:29
	  public Object visitActionPara(ActionPara term)
	  {
		  getPercurso().append("ActionPara\n");

		  String[] result = null;

		  ZName actionName = (ZName)term.getName();
		  CircusAction action = term.getCircusAction();

		  String strName = actionName.getWord();
		  if (strName.startsWith(CircusUtils.DEFAULT_MAIN_ACTION_NAME)) {
			  strName = "Main Action";
		  }
		  else if (strName.startsWith(CircusUtils.DEFAULT_PROCESS_STATE_NAME)) {
			  strName = Space;
		  }
		  String[] strAct = (String[])action.accept(actionPrint());

		  result = new String[strAct.length + 1];

		  int index = 1;

		  result[0] =  strName + " \\circdef ";
		  
		  for(int i=0; i<strAct.length; i++) {
			  result[index++] =  BRANCO + "\\t1 " + strAct[i];
		  }
		 

		  return result;
	  }


}
