package circusRefine.util.docgenerator;

import java.util.LinkedList;
import java.util.Stack;

import circusRefine.core.ExternalManager;
import circusRefine.core.idt.IdtUtils;
import circusRefine.core.util.Text;
import circusRefine.gui.GenerateDocException;
import circusRefine.util.DocCommentsType;

/**
 * Realiza a impressao do programa no formato LaTeX.
 * @author alessandro87
 *
 */
public class DocGeneratorUtils {

	private StringBuffer texto;
	private int redosize;
	private ExternalManager gerInterface;

	private boolean originalSpec;
	private boolean des;
	private boolean proofOb;
	private DocCommentsType comment;
	private boolean code;
	private final static int numeroIdealPorpags = 40;

	/* Campo que determina se a impressao das OPs serao feitas 
	 * de forma Expandida ou Resumida*/
	private boolean formaExpandida;

	private static final String BRANCO = "     ";


	public DocGeneratorUtils(StringBuffer texto, int redosize, ExternalManager gerInterface, boolean originalSpec, boolean des, boolean proofOb, DocCommentsType comment, boolean code, boolean formaExpandida) {
		super();
		this.texto = texto;
		this.redosize = redosize;
		this.gerInterface = gerInterface;
		this.originalSpec = originalSpec;
		this.des = des;
		this.proofOb = proofOb;
		this.comment = comment;
		this.code = code;
		this.formaExpandida = formaExpandida;
	}


	/**
	 * Gera toda a documentacao
	 * @return StringBuffer contendo todo o contedo do arquivo .tex
	 */
	public StringBuffer getTextFromProgram() {

		//Impede que as utilizacoes do printer pro docgenerator 
		//insira relacionamentos
		/*
		 * Inicializando comandos Latex padroes para definicao de arquivo em formato article
		 */
		texto.append("\\documentclass{article}\n\n");
		/*
		 * Comandos temporarios enquanto o circus.sty nao � atualizado
		 */
		adicionandoComandos(texto);

		/*
		 * Adicionando pacotes
		 */
		adicionandoPacotes(texto);

		/*
		 * Inicio de documento propriamente dito; Inserimdo Indice
		 */
		texto.append("\\begin{document}\n\n");
		texto.append("\\tableofcontents\n");

		/*
		 * Possivel Sessao I - Espefica Original
		 */
		if (originalSpec) {
			adicionandoOriSpec(texto, redosize);
		}
		/*
		 * Corpo do Texto
		 */
		if (des) {
			adicionandoDesenvolvimento(texto, redosize);
		}

		/*
		 * Obrigacoes de Prova
		 */
		if (proofOb) {
			adicionandoPOs(texto);
		}
		/*
		 * Comentarios 
		 */
		if (comment != DocCommentsType.NENHUM) {
			adicionandoComentarios(texto);
		}

		/*
		 * Codigo Final
		 */
		if (code) {
			adicionandoCodigo(texto);
		}

		/*
		 * Fim de Documento
		 */

		texto.append("\\end{document}");
		return texto;
	}


	private void adicionandoComentarios(StringBuffer strText) {

		if (comment.equals(DocCommentsType.EM_LISTA)) {
			strText.append("\n");
			strText.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
			strText.append("% " + this.retornarMensagem("COD0553") + " \n");
			strText.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
			strText.append("\n\n");

			strText.append("\\newpage\n");
			strText.append("\\section{" + this.retornarMensagem("COD0293") + "}\n\n");

			LinkedList<String> toInsert = this.gerInterface.generateListCommentsInDoc();

			String[] res = new String[toInsert.size()];
			for (int i=0;i<res.length;i++) {
				res[i] = toInsert.get(i);
			}

			LinkedList<String> result = DefinindoPags(res, numeroIdealPorpags);

			for (int i=0; i<result.size();i++) {
				strText.append(result.get(i) + "\n");
			}

		}
	}


	/**
	 * Esse metodo  quem quebra as paginas inserindo o camando \newpage em
	 * latex.
	 * @param oriText Texto Original retornado pelo Printer
	 * @return
	 */
	private LinkedList<String> DefinindoPags(String[] oriText, int numsPag) {
		LinkedList<String> result = new LinkedList<String>();

		Stack<String> aux = new Stack<String>();
		/*
		 * Numero de linhas por pagina
		 */
		int counter = 0;
		for (int i=0;i < oriText.length;i++) {
			if (counter<numsPag) {
				if (oriText[i].contains("\\begin")) {
					aux.push(oriText[i]);
				}
				else if (oriText[i].contains("\\end") && !aux.isEmpty()){
					aux.pop();
				}
				else{
					counter++;
				}
			}
			/*
			 * Quebra de Pagina
			 */
			else {
				/*
				 * Fechando os ambientes que ficaram para tras
				 */
				for (int k= aux.size()-1; k > -1; k--) {
					String str = aux.get(k).replace("\\begin", "\\end") + "%";
					result.add(str);
				}
				result.add("\\newpage");
				for (int k= aux.size()-1; k > -1; k--) {
					String str = aux.get(k);
					result.add(str);
				}
				counter = 0;
			}
			result.add(oriText[i]);
		}

		return result;
	}
	
	
	private void adicionandoCodigo(StringBuffer strText) {
		texto.append("\n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("% " + this.retornarMensagem("COD0556") + " \n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("\n\n");

		texto.append("\\newpage\n");
		texto.append("\\section{" + this.retornarMensagem("COD0013") + "}\n\n");

		DocGenerator printer = new DocGenerator(Text.ESPECIFICACAO_ORIGINAL);
		String[] oriText = (String[])printer.visitTerm(this.gerInterface.retornarProgAtual());

		LinkedList<String> result = DefinindoPags(oriText, numeroIdealPorpags);
		
		String str1 = "";
		String str2 = "";
		if (gerInterface.isPODevelopment()) {
			str1 = "\\begin{circus}\n";
			str2 = "\\end{circus}\n";
		}
		
		texto.append(str1);
		for (int i=0; i<result.size();i++) {
			texto.append(result.get(i) + "\n");
		}
		texto.append(str2);
		
		/*
		 * Se nao houver selecao de desenvolvimento entao
		 * o programa devera voltar a sua forma antes da impressao
		 * Se houver selecao, esse procedimento so sera realizado apos
		 * a impressao da sessao de refinamento
		 */
		texto.append("\n\n");

	}

	/**
	 * Metodo responsavel por adicionar a sessao de especificao inicial ao
	 * arquivo final .tex
	 * @param texto
	 */
	private void adicionandoOriSpec(StringBuffer texto, int redosize) {

		texto.append("\n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("% " + this.retornarMensagem("COD0548") + " \n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("\n\n");

		texto.append("\\newpage\n");
		texto.append("\\section{" + this.retornarMensagem("COD0535") + "}\n\n");

		this.gerInterface.undoToPrintLatex(texto);
		DocGenerator printer = new DocGenerator(Text.ESPECIFICACAO_ORIGINAL);

		String[] oriText = (String[])printer.visitTerm(this.gerInterface.retornarProgAtual());

		LinkedList<String> result = DefinindoPags(oriText, numeroIdealPorpags);
		/**
		 * Caso o desenvolvimento seja um subdesenvolvimento.
		 * Entao seus termos serao Acoes ou Processos Definidos Isolodamente.
		 * Ou seja, nao haver paragrafos, isto  ActionPara ou ProcessPara.
		 * Dessa forma devera ser inserido o begin{circus} e end{circus} para
		 * que seja reconhecido.
		 */
		String str1 = "";
		String str2 = "";
		if (gerInterface.isPODevelopment()) {
			str1 = "\\begin{circus}\n";
			str2 = "\\end{circus}\n";
		}
		
		texto.append(str1);
		for (int i=0; i<result.size();i++) {
			texto.append(result.get(i) + "\n");
		}
		texto.append(str2);
		
		/*
		 * Se nao houver selecao de desenvolvimento entao
		 * o programa devera voltar a sua forma antes da impressao
		 * Se houver selecao, esse procedimento so sera realizado apos
		 * a impressao da sessao de refinamento
		 */
		if (!des) {
			this.gerInterface.redoPrintLatex(redosize, texto);
		}

		texto.append("\n\n");
	}


	/**
	 * Metodo temporario utilizado para adicionar os comando que "faltam" 
	 * ser integrados ao circus.sty
	 * @param texto
	 */
	private void adicionandoComandos(StringBuffer texto) {
		texto.append("\n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("% " + this.retornarMensagem("COD0551") + " \n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("\n\n");

		texto.append("\\newcommand{\\handwriting}{\\ding{45}}\n");
		texto.append("\\newcommand{\\checkedtrue}{\\ding{52}}\n");
		texto.append("\\newcommand{\\checkedfalse}{\\ding{56}}\n");
		texto.append("\\newcommand{\\manualchecktrue}{\\handwriting \\checkedtrue}\n");
		texto.append("\\newcommand{\\manualcheckfalse}{\\handwriting \\checkedfalse}\n");

//		texto.append("\\newcommand{\\circdef}{\\defs}\n");
//		texto.append("\\newcommand{\\circseq}{\\Semi}\n");
		texto.append("\\newcommand{\\circrefines}{\\sqsubseteq}\n");
		texto.append("\\newcommand{\\circsimulates}{\\preceq}\n");
//		texto.append("\\newcommand{\\lcircguard}{(}\n");
//		texto.append("\\newcommand{\\rcircguard}{)}\n");
//		texto.append("\\newcommand{\\lcircrename}{[}\n");
//		texto.append("\\newcommand{\\rcircrename}{]}\n");
//		texto.append("\\newcommand{\\circguard}{\\&}\n");
//		texto.append("\\newcommand{\\circlinst}{|}\n");
//		texto.append("\\newcommand{\\circrinst}{|}\n");
//		texto.append("\\newcommand{\\circhide}{\\hide}\n");
//		texto.append("\\newcommand{\\circchannelfrom}{circhannelfrom}\n");
		texto.append("\\newcommand{\\true}{true}\n");
		texto.append("\\newcommand{\\false}{false}\n");
//		texto.append("\\newcommand{\\circindex}{\\odot}\n");
//		texto.append("\\newcommand{\\Skip}{skip}\n\n");
//		texto.append("\\newcommand{\\Stop}{stop}\n\n");
		texto.append("\\newcommand{\\arithmos}{\\it Arithmos}\n\n");

	}


	/**
	 * Adiciona os pacotes necessarios para o texto em Latex
	 * @param texto O texto latex
	 */
	private void adicionandoPacotes(StringBuffer texto) {

		texto.append("\n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("% " + this.retornarMensagem("COD0552") + " \n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("\n\n");

		texto.append("\\usepackage{circus}\n");
		texto.append("\\usepackage{pifont}\n");
	}

	/**
	 * Metodo respons�vel por adicionar o desenvolvimento (refinamento)
	 * ao arquivo final .tex
	 * @param texto
	 * @param redosize- tamanho da pilha de redo antes de ter dado os undos.
	 */
	private void adicionandoDesenvolvimento(StringBuffer texto, int redosize) {
		texto.append("\n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("% " + this.retornarMensagem("COD0549") + " \n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("\n\n");

		texto.append("\\newpage\n");
		texto.append("\\section{" + this.retornarMensagem("COD0532") + "}\n\n");
		/* Caso o originalSpec seja selecionado o mesmo metodo ja percorrei
		 * as pilhas no sentido de desfazer as aes 
		 */ 
		if (!originalSpec) {
			this.gerInterface.undoToPrintLatex(texto);

		}

		String[] desText = null;
		if (comment.equals(DocCommentsType.ANTES_DE_LINHA)) {
			gerInterface.AtualizarComentariosUtils();
			DocGenerator printer = new DocGenerator(Text.DES_COMENTARIOS_ANTES);
			desText = (String[])printer.visitTerm(this.gerInterface.retornarProgAtual());

		}
		else if (comment.equals(DocCommentsType.DEPOIS_DE_LINHA)) {
			gerInterface.AtualizarComentariosUtils();
			DocGenerator printer = new DocGenerator(Text.DES_COMENTARIOS_DEPOIS);
			desText = (String[])printer.visitTerm(this.gerInterface.retornarProgAtual());

		}
		else {
			DocGenerator printer = new DocGenerator(Text.DESENVOLVIMENTO);
			desText = (String[])printer.visitTerm(this.gerInterface.retornarProgAtual());
		}
		/* retualizando os camposd de comentarios*/
		IdtUtils.prepararComentarios(this.gerInterface.retornarProgAtual());

		LinkedList<String> result = DefinindoPags(desText, numeroIdealPorpags);
		
		
		/**
		 * Caso o desenvolvimento seja um subdesenvolvimento.
		 * Entao seus termos serao Acoes ou Processos Definidos Isolodamente.
		 * Ou seja, nao haver paragrafos, isto  ActionPara ou ProcessPara.
		 * Dessa forma devera ser inserido o begin{circus} e end{circus} para
		 * que seja reconhecido.
		 */
		String str1 = "";
		String str2 = "";
		if (gerInterface.isPODevelopment()) {
			str1 = "\\begin{circus}\n";
			str2 = "\\end{circus}\n";
		}
		texto.append(str1);
		
		for (int i=0; i<result.size();i++) {
			texto.append(result.get(i) + "\n");
		}
		texto.append(str2);

		this.gerInterface.redoPrintLatex(texto, redosize);
	}


	/**
	 * Metodo que adiciona as OPS ao arquivo de saida
	 * representado pela StringBuffer texto. Essas OPS 
	 * poderao estar  na forma Expandida ou nao, dependendo da 
	 * selecao usurio.
	 * @param texto
	 */
	private void adicionandoPOs(StringBuffer texto) {
		texto.append("\n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("% " + this.retornarMensagem("COD0550") + " \n");
		texto.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n");
		texto.append("\n\n");


		texto.append("\\newpage\n");
		texto.append("\\section{" + this.retornarMensagem("COD0014") + "}\n\n");

		/*
		 * Iniciando Tabela
		 */
		texto.append("\\begin{tabular}{|c|c|l|}\n");
		texto.append( BRANCO + "\\hline \n");
		texto.append( BRANCO + "\\textbf{" + this.retornarMensagem("COD0604") + "}"
				+" & \\textbf{Status} & \\textbf{" + this.retornarMensagem("COD0569") + "} \\\\ \n");

		// -1 devido a primeira linha de identificacao de colunas
		LinkedList<String> toInsert = this.gerInterface.generatePOinDoc(formaExpandida, numeroIdealPorpags - 1);

		String[] res = new String[toInsert.size()];
		for (int i=0;i<res.length;i++) {
			res[i] = BRANCO + toInsert.get(i);
		}


		for (int i=0;i< res.length;i++) {
			texto.append(res[i] + "\n");
		}
		texto.append( BRANCO + "\\hline \n");
		texto.append("\\end{tabular}\n");
	}


	private String retornarMensagem(String string) {
		return gerInterface.getMessage(string);
	}

}
