package circusRefine.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.List;


/* This class can be used to clean the internationalization files */

public class MessageFileFilter {

    private static final String fileSep = System.getProperty("file.separator");
    private static final String lineSep = System.getProperty("line.separator");

    private static final String internacionalizationDirectory = "internacionalizacao";
    private static final String sourceDirectory = "src"+fileSep+"circusRefine";

	public static boolean searchForCodeInFile(File file, String code) 
	throws IOException{
		boolean retorno = false;

        FileReader reader = new FileReader(file);
        BufferedReader lineReader = new BufferedReader(reader);

        List<String> acceptedLines = new Vector<String>(); 
        
        boolean endOfFile = false;
        while (!endOfFile && !retorno) {
            String line = lineReader.readLine();
            if (line != null){
            	if (line.contains(code)) {
            		retorno = true;
            	}
            } else {
            	endOfFile = true;
            }
        }

        // Fechando
        lineReader.close();
        reader.close();
		
		return retorno;
	}

	public static void writeOutput(List<String> lines, File file) 
	throws IOException {
        String output = "";
        StringBuffer outputStr = new StringBuffer();

        for (int i=0; i<lines.size(); i++) {
			String linha = (String)lines.get(i);
			output = output + linha + MessageFileFilter.lineSep;  
		}
		
        if (file.exists()) {
        	file.delete();
        }

		FileWriter escritor = new FileWriter(file);
		BufferedWriter grava = new BufferedWriter(escritor);
        
		grava.write(output);
		grava.close();
		escritor.close();
	}
	
	public static boolean searchForCodeInDir(File sourceDir, String code) 
	throws IOException{
		boolean retorno = false;

		File[] sourceDirFiles = sourceDir.listFiles(); 

		for (int i = 0; i < sourceDirFiles.length && !retorno; i++) {
			File f = sourceDirFiles[i];
			if (!f.isDirectory()) {
				if(f.getName().endsWith(".java")) {
					retorno = searchForCodeInFile(f,code);
				}
			} else {
				retorno = searchForCodeInDir(f,code);
			}
		}
		
		return retorno;
	}

	public static List<File> getInterFiles(File dir) {
		File[] interDirFiles = dir.listFiles(); 

		List<File> interFiles = new Vector<File>(); 

		for (int i = 0; i < interDirFiles.length; i++) {
			File f = interDirFiles[i];
			if (!f.isDirectory() && f.getName().endsWith(".properties")) {
				interFiles.add(f);
			}
		}
		
		return interFiles;
	}

	public static void filterInterFile(File sourceDir, File file) 
	throws IOException {
		System.out.println("###################################################################################");
		System.out.println("Filtering file: "+file.getName());

		// List of lines that defines used codes 
        List<String> linesWithUsedCode = new Vector<String>(); 

		// List of lines that defines unused codes 
        List<String> linesWithUnusedCode = new Vector<String>(); 
		
		// Lendo linhas do arquivo 
        FileReader reader = new FileReader(file);
        BufferedReader lineReader = new BufferedReader(reader);

        boolean endOfFile = false;
        while (!endOfFile) {
            String line = lineReader.readLine();
            if (line != null){
            	StringTokenizer tokenizer = new StringTokenizer(line,"=");
            	if(tokenizer.hasMoreTokens()) {
            		String code = tokenizer.nextToken().trim();

            		boolean isUsed = MessageFileFilter.searchForCodeInDir(sourceDir, code);
					System.out.print("Checking Code "+code);
    				if (isUsed) {
    					linesWithUsedCode.add(line);
    					System.out.println(" OK");
    				} else {
    					linesWithUnusedCode.add(line);
    					System.out.println(" NOT OK");
    				}
            	}
            } else {
            	endOfFile = true;
            }
        }

        // Fechando
        lineReader.close();
        reader.close();

        // Writing filtered files
        File fileWithUsedCodes = new File(file.getCanonicalPath()+"_used"); 
        File fileWithUnusedCodes = new File(file.getCanonicalPath()+"_unused"); 
        
        MessageFileFilter.writeOutput(linesWithUsedCode, fileWithUsedCodes);
        MessageFileFilter.writeOutput(linesWithUnusedCode, fileWithUnusedCodes);
        
		System.out.println("OK Filtering file: "+file.getName());
		System.out.println("###################################################################################");
	}
	
	public static void main(String[] args) {
		try {
			
			// Finding all internacionalization files 
			File dir = new File (".");
			File currentDir = new File(dir.getCanonicalPath());
			File interDir = new File(currentDir.getCanonicalPath()+fileSep+MessageFileFilter.internacionalizationDirectory);
			File sourceDir = new File(currentDir.getCanonicalPath()+fileSep+MessageFileFilter.sourceDirectory);

			// Get the internationalization files
			List<File> interFiles = MessageFileFilter.getInterFiles(interDir); 

			// Filter one by one
			for (int i = 0; i < interFiles.size(); i++) {
				MessageFileFilter.filterInterFile(sourceDir, interFiles.get(i));
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

}
