package circusRefine.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.swing.JOptionPane;

public class Internacional{

	String linguagem;
	String pais;
	Locale localizacao;
	ResourceBundle mensagens;

	public Internacional(String linguagem, String pais) {
		this.linguagem = linguagem;
		this.pais = pais;
		this.localizacao = new Locale(linguagem, pais);
		this.mensagens = ResourceBundle.getBundle("MessagesBundle", localizacao);
	}
	public Locale getLocalizacao() {
		return this.localizacao;
	}
	public String retornarMensagem(String codigo) {
		try  {
			
			String mensagem = mensagens.getString(codigo);
			return mensagem;
		}
		catch (MissingResourceException e) {
			System.out.println(codigo);
			e.printStackTrace();
			JOptionPane.showMessageDialog(null, this.retornarMensagem("COD0594"), "Error", JOptionPane.ERROR_MESSAGE);
			System.exit(0);
		}
		return null;
	}
}
