/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.util;

// TODO fazer todas as excesses de CRefine herdarem dessa classe

/**
 * Super classe para todas as Excees geradas pelo CRefine 
 * 
 * @author crisgc
 */
public class CRefineException extends Exception {

	/** Nmero para serializao */
	private static final long serialVersionUID = -9176151984705257863L;
	
	/** String com o cdigo para o usurio */
	private String userMessageCode;
	
	/** Cdigo para o ttulo da janela */
	private String titleCode;
	
	/**
	 * @param arg0
	 */
	public CRefineException( String cod ) {
		this.setCodeOfMessageToTheUser( cod );
		this.setTitleCode( null );
	}

	/**
	 * @param arg0
	 * @param arg1
	 */
	public CRefineException( String msg, Throwable arg1 , String cod ) {
		super( msg , arg1 );
		this.setCodeOfMessageToTheUser( cod );
		this.setTitleCode( null );
	}

	/**
	 * @param arg0
	 */
	public CRefineException( String msg, String cod ) {
		super( msg );
		this.setCodeOfMessageToTheUser( cod );
		this.setTitleCode( null );
	}

	/**
	 * @param arg0
	 */
	public CRefineException( Throwable arg0, String cod ) {
		super(arg0);
		this.setCodeOfMessageToTheUser( cod );
		this.setTitleCode( null );
	}
	
	
	/**
	 * @param codeOfMessageToTheUser o cdigo a ser passado ao usurio
	 */
	private void setCodeOfMessageToTheUser(String codeOfMessageToTheUser) {
		this.userMessageCode = codeOfMessageToTheUser;
	}
	
	/**
	 * Acessa o cdigo para uma mensagem ao usurio
	 * 
	 * @return O cdigo para a mensagem ao usurio sobre o erro
	 */
	public String getCodeOfMessageToTheUser() {
		return userMessageCode;
	}

	public String getTitleCode() {
		return titleCode;
	}

	public void setTitleCode(String titleCode) {
		this.titleCode = titleCode;
	}
	
	
	
}
