package circusRefine.gui.stacks;

import java.util.Stack;

import circusRefine.gui.Comentario;

/**
 * Guarda todas as pilhas referentes a Tela de Desenvolvimento
 * @author alessandro87
 *
 */
public class TelaDesStacks {

	private Stack<Integer> textoPosAntigo;
	
	/* Pilha que guarda os comentarios inseridos e Removidos*/
	private Stack<Comentario> commentsR;
	private Stack<Comentario> commentsI;
	
	private Stack<Comentario> redoCommentsR;
	private Stack<Comentario> redoCommentsI;
	
	

	public TelaDesStacks(Stack<Integer> textoPosAntigo, Stack<Comentario> commentsR, Stack<Comentario> commentsI, Stack<Comentario> redoCommentsR, Stack<Comentario> redoCommentsI) {
		super();
		this.textoPosAntigo = textoPosAntigo;
		this.commentsR = commentsR;
		this.commentsI = commentsI;
		this.redoCommentsR = redoCommentsR;
		this.redoCommentsI = redoCommentsI;
	}

	public TelaDesStacks() {
		
		textoPosAntigo = new Stack<Integer>();
		
		commentsR = new Stack<Comentario>();
		commentsI = new Stack<Comentario>();
		
		redoCommentsR = new Stack<Comentario>();
		redoCommentsI = new Stack<Comentario>();
	}

	public Stack<Comentario> getCommentsI() {
		return commentsI;
	}

	public Stack<Comentario> getCommentsR() {
		return commentsR;
	}

	public Stack<Comentario> getRedoCommentsI() {
		return redoCommentsI;
	}

	public Stack<Comentario> getRedoCommentsR() {
		return redoCommentsR;
	}

	public Stack<Integer> getTextoPosAntigo() {
		return textoPosAntigo;
	}
	
	public void addInsertedComment(Comentario insertedComment){
		this.commentsI.push(insertedComment);
	}
	
	public void esvaziarRedoPilhas() {
		this.redoCommentsI.clear();
		this.redoCommentsR.clear();
	}

	public void esvaziarPilhas() {
		this.commentsI.clear();
		this.commentsR.clear();
		this.redoCommentsI.clear();
		this.redoCommentsR.clear();
	}

	public void addRemovedComment(Comentario comment) {
		this.commentsR.push(comment);
	}

	public Comentario lastInsertedComment() {
		return commentsI.pop();
	}

	public void addtoRedoInsertedComments(Comentario foiRemovido) {
		this.redoCommentsI.push(foiRemovido);
	}

	public Comentario lastRemovedComment() {
		return commentsR.pop();
	}

	public void addtoRedoRemovedComment(Comentario foiInserido) {
		this.redoCommentsR.push(foiInserido);
	}

	public Comentario redoInsertComment() {
		return redoCommentsI.pop();
	}
	
	public Comentario redoRemoveComment() {
		return redoCommentsR.pop();
	}

	public Object imprimirI() {
		String result = "comentarios : ";
		
		for (Comentario com : this.commentsI) {
			result = result + "C" + com.getIdentificador() + " ";
		}
		result += "\nRedo : ";
		for (Comentario com : this.redoCommentsI) {
			result = result + "C" + com.getIdentificador() + " ";
		}
		result += "\n";
		
		return result;
	}
}
