package circusRefine.gui;

import circusRefine.core.ExternalManager;
import circusRefine.Tactic.Excecao.LawNotFound;
import circusRefine.Tactic.Excecao.TacticNotFound;
import circusRefine.Tactic.Excecao.Unification;
import circusRefine.Tactic.Parser.Parser2;
import circusRefine.Tactic.Principal.*;

import java.awt.BorderLayout;
import javax.swing.JButton;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JOptionPane;

import circusRefine.Tactic.Parser.ParseException;
import circusRefine.Tactic.Util.GerenciadorTaticas;

import java.awt.event.ActionEvent;
import java.io.*;



public class TelaTatica extends JFrame{


	public TelaTatica(){

	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	static int opened = 0; 


	ExternalManager gerInterface;
	static File file = null;
	Tatica tatica = new Tatica();
	Parser2 parser = new Parser2();
	TecladoArcAngelC tecArcAngelC;

	JMenuBar Menu1 = new JMenuBar();

	JMenu Arquivo         = new JMenu();

	JMenuItem Salvar   = new JMenuItem();
	JMenuItem Compilar   = new JMenuItem();
	JMenuItem Sair 	 = new JMenuItem();


	JPanel panel1 = new JPanel();
	JButton btnCompilar = new JButton();
	JButton btnCancel = new JButton();
	JTextArea jTactic = new JTextArea();
	JScrollPane rolagem;
	JLabel labelEntrada = new JLabel();
	//JButton btnDigitacao = new JButton();
	JButton btnTecladoVirtual = new JButton();
	JButton btnLimpar = new JButton();
	JPanel panel2 = new JPanel();
	BorderLayout borderLayout1 = new BorderLayout();
	BorderLayout borderLayout2 = new BorderLayout();
	JPanel panel3 = new JPanel();
	GridLayout gridLayout1 = new GridLayout();
	JPanel panel4 = new JPanel();
	BorderLayout borderLayout3 = new BorderLayout();
	BorderLayout borderLayout4 = new BorderLayout();
	FlowLayout flowLayout1 = new FlowLayout();

	JPanel panel5 = new JPanel();
	JPanel panel6 = new JPanel();
	JPanel panel7 = new JPanel();
	JPanel panel8 = new JPanel();
	JPanel panel9 = new JPanel();

	FileWriter writer = null;
	JFileChooser fileChooser = new JFileChooser();

	public TelaTatica(ExternalManager gerExterno) {
		gerInterface = gerExterno;
		jbInit();
		tecArcAngelC = new TecladoArcAngelC(this);
	}


	private Tatica compilar_Action() {

		try{
			tatica = gerInterface.parseTatica(file);

			if (!gerInterface.verificarErroParser()){
				if(opened==0){
					JOptionPane.showMessageDialog
					(null,gerInterface.getMessage("AddTactic"));
					gerInterface.updateTacticList(tatica);	
				}
				else
					JOptionPane.showMessageDialog
					(null,gerInterface.getMessage("EditTactic"));


				
				limpar_Action();

				gerInterface.retornarTelaTatica().setVisible(false);
			}
		}catch(TacticNotFound e2){
			//linha = gerInterface.setarLinha();
			gerInterface.telaErro("TacticNotFound", "", "Tactic: " + e2.getNomeTactic() + "at line: " + gerInterface.setarLinha());
			System.out.println("TacticNotFound");
		}
		catch(LawNotFound e3){
			gerInterface.telaErro("LawNotFound", "", "Law: " + e3.getLei() + "at line: " + gerInterface.setarLinha());
			System.out.println("LawNotFound");
		}


		return tatica;

	}

	private void jbInit(){

		this.setLocation(300,80);
		this.setSize(700, 600);
		this.setResizable(true);
		this.setTitle("Parser ArcAngelC");

		this.setJMenuBar(Menu1);
		Arquivo.setText("Arquivo");
		//Arquivo.setMnemonic(gerInterface.getMessage("COD0001").charAt(0));
		/*Abrir.setText(gerInterface.getMessage("COD0003"));
		Abrir.setMnemonic(gerInterface.getMessage("COD0003").charAt(0));*/
		Salvar.setText("Save");
		//Salvar.setMnemonic(gerInterface.getMessage("COD0005").charAt(0));
		Compilar.setText("Compile");
		Sair.setText("Exit");
		//Sair.setMnemonic(gerInterface.getMessage("COD0008").charAt(0));

		jTactic.setFont(new Font ("CZT", Font.PLAIN, 14));
		jTactic.setText("");
		rolagem = new JScrollPane(jTactic);
		jTactic.setToolTipText("Parser");


		btnCompilar.setForeground(Color.RED);
		btnCompilar.setFont(new Font("Dialog", 1, 12));
		btnCompilar.setText(gerInterface.getMessage("Compile"));
		btnCompilar.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {


				//try {

				try {
					compilarActionPerformed();

				} catch (TacticNotFound e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();

				} catch (LawNotFound e2) {
					// TODO Auto-generated catch block
					e2.printStackTrace();
				}

				limpar_Action();
				gerInterface.retornarTelaTatica().setVisible(false);


			}

		}

		);

		btnLimpar.setForeground(Color.RED);
		btnLimpar.setFont(new Font("Dialog", 1, 12));
		btnLimpar.setText("Limpar");
		btnLimpar.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				limpar_Action();
			}
		}
		);

		btnCancel.setForeground(Color.red);
		btnCancel.setFont(new Font("Dialog", 1, 12));
		btnCancel.setText("Cancelar");
		btnCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btnCancel_actionPerformed(e);
				limpar_Action();
			}
		});

		btnTecladoVirtual.setForeground(Color.black);
		btnTecladoVirtual.setFont(new Font("Dialog", 1, 12));
		btnTecladoVirtual.setText(gerInterface.getMessage("Keybord"));
		btnTecladoVirtual.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				tecladoVirtual_Action(e);

			}
		});


		labelEntrada.setText(" Enter ArcAngelC Code:");
		panel1.setLayout(borderLayout1);
		panel2.setLayout(borderLayout2);
		panel3.setLayout(gridLayout1);
		panel4.setLayout(borderLayout3);
		panel9.setLayout(flowLayout1);

		this.getContentPane().add(panel1, BorderLayout.CENTER);
		panel1.add(panel2, BorderLayout.CENTER);

		panel2.add(rolagem,  BorderLayout.CENTER);
		panel2.add(panel5, BorderLayout.WEST);
		panel2.add(panel6,  BorderLayout.SOUTH);
		panel2.add(panel7,  BorderLayout.EAST);
		panel2.add(panel8, BorderLayout.NORTH);

		panel1.add(panel3,  BorderLayout.SOUTH);

		panel3.add(btnCompilar, null);
		//panel3.add(btnLimpar,null);
		panel3.add(btnTecladoVirtual, null);
		//panel3.add(btnCancel, null);


		panel1.add(panel4, BorderLayout.NORTH);
		//panel1.add(panel5, BorderLayout.NORTH);

		/*Menu1.add(Arquivo);
		Arquivo.add(Salvar);
		Arquivo.add(Compilar);
		Arquivo.addSeparator();
		Arquivo.add(Sair);*/

		Compilar.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {

				try {
					compilarActionPerformed();

				} catch (TacticNotFound e1) {
					// TODO Auto-generated catch block
					System.out.println(e1.getNomeTactic());

				} catch (LawNotFound e2) {
					// TODO Auto-generated catch block
					e2.printStackTrace();

				}
				limpar_Action();
				gerInterface.retornarTelaTatica().setVisible(false);
			}
		}
		);


		Salvar.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				salvarTatica();
			}
		}
		);

		Sair.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				btnCancel_actionPerformed(e);
				limpar_Action();
			}
		}
		);

		//panel5.add(Menu1,  BorderLayout.CENTER);
		panel4.add(labelEntrada,  BorderLayout.CENTER);

		// A parte do arquivo
		panel4.add(panel9,  BorderLayout.EAST);

	}


	protected void btnCancel_actionPerformed(ActionEvent e) {
		this.setVisible(false);


	}

	public void limparTexto() {
		jTactic.setText("");
	}

	private void limpar_Action() {
		this.limparTexto();

	}


	private void tecladoVirtual_Action(ActionEvent e){
		tecArcAngelC.pack();
		tecArcAngelC.setLocation(490, 200);
		tecArcAngelC.setVisible(true);
	}

	public static void sairTela(){
		Object[] botoes = {"Sim", "Não"};
		int opcao = 
			JOptionPane.showOptionDialog(
					null, "Deseja sair? [S/N]",
					"Fechar Tela Parser ArcAngelC",
					JOptionPane.DEFAULT_OPTION,
					JOptionPane.INFORMATION_MESSAGE,
					null, botoes, botoes[1] );
		if (opcao == 0) {
			System.exit(0);


		}
	}


	/**
	 * Método responsavel por retornar o código do arquivo para
	 * setar na telaTatica
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public void setarArquivo(File file) throws IOException{
		gerInterface.retornarEspecificacao(file);
	}

	public void setarTelaTatica(String codigo){
		jTactic.setText(codigo);
	}


	public int getLine() {
		String texto = this.jTactic.getText();
		int posicaoCursor = this.jTactic.getCaretPosition();
		int linha = 1;
		int coluna = 1;

		char[] arrayCaracteres = texto.toCharArray();

		for (int i = 0; i < posicaoCursor; i++){
			if (arrayCaracteres[i]=='\n') {
				linha++;
				coluna = 1;
			} else {
				coluna++;
			}	
		}

		//this.getStatusMsg1().setText("Lin: "+linha+" Col: "+coluna);

		return linha;
	}

	public void showErrorWindow(String mensagem, String details, String infoExtra){

		boolean retorno = false;
		String options[] = {"Close","Details"};
		int resposta = JOptionPane.showOptionDialog(this,
				infoExtra,
				//gerInterface.getMessage("TacticError"),
				gerInterface.getMessage(mensagem),
				JOptionPane.YES_NO_OPTION,
				JOptionPane.ERROR_MESSAGE,
				null,
				options,
				options[0]);

		switch (resposta) {
		case 0: 
			retorno = false;
			break;
		case 1:
			retorno = true;
			break;
		default:
			retorno = false;
		}
		if (retorno) {
			if (details == null || details.equals("")) {
				details = gerInterface.getMessage("NoDetails");
			}    
			JOptionPane.showMessageDialog(this, details, this.gerInterface.getMessage("ErrorDetails"), JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * Método que salva uma tática 
	 */
	private void salvarTatica(){


		JFileChooser fChooser = new JFileChooser();
		fChooser.setCurrentDirectory(new File("."));

		int result = fChooser.showDialog(null,gerInterface.getMessage("SaveT"));
		if(result == JFileChooser.APPROVE_OPTION)
		{
			file = fChooser.getSelectedFile();
		}
	}

	/**
	 * Método responsavel por pegar o texto que foi digitado na tela
	 * @return codigo O código digitado
	 */ 
	public String getText(){
		String codigo = jTactic.getText();
		return codigo;
	}

	/**
	 * Método que realiza o processo de compilar 
	 */
	private void compilarActionPerformed() throws TacticNotFound, LawNotFound{
		boolean overwrite = true;
		if (!jTactic.getText().equals("")){
			if (opened == 0 ){
				overwrite = false;
				JOptionPane.showMessageDialog(this,this.gerInterface.getMessage("SaveTactic"), 
						this.gerInterface.getMessage("SaveT"), JOptionPane.INFORMATION_MESSAGE);
				salvarTatica();
			}

			gerInterface.escreveArquivo(file, getText());
			tatica = compilar_Action();


			/**
			 * Serializar nova tatica
			 */
			if (tatica!=null)
			gerInterface.escreveTaticaSerializada(tatica);
			opened = 0;
		}
		else 
			JOptionPane.showMessageDialog(this,this.gerInterface.getMessage("EmptyFile"), 
					this.gerInterface.getMessage("EmptyFile"), JOptionPane.INFORMATION_MESSAGE);
	}


	/**
	 * M�todo utilizado para digitar com o auxilio do Teclado Virtual.
	 *
	 * @param carac      ........
	 *
	 */
	public void escrever(String carac) {

		/* captura posicao do cursor na tela */
		int position = jTactic.getCaret().getDot();

		this.jTactic.insert(carac, position);

	}
}