package circusRefine.gui;

import java.awt.Component;
import java.awt.Font;

import javax.swing.AbstractCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TelaObrigacaoRenderer  implements TableCellRenderer{

	private JTextArea text;

	public TelaObrigacaoRenderer() {
		text = new JTextArea();
		text.setLineWrap(true);
		text.setWrapStyleWord(true);
		text.setFont(new Font("CZT", Font.PLAIN, 12));
	}

	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		text.setText((String)value);
		int height_wanted = (int)text.getPreferredSize().getHeight();
		if (height_wanted != table.getRowHeight(row)) {
			table.setRowHeight(row, height_wanted);
		}
		if (isSelected) {
			TableCellRenderer tableCellRenderer = table.getCellRenderer(row, column);
			if (tableCellRenderer instanceof TelaObrigacaoRenderer){
				((TelaObrigacaoRenderer)tableCellRenderer).getText().setForeground(table.getSelectionForeground());
				((TelaObrigacaoRenderer)tableCellRenderer).getText().setBackground(table.getSelectionBackground());
				
				//deselecionando as outras colunas
			}

		}
		else{
			TableCellRenderer tableCellRenderer = table.getCellRenderer(row, column);
			((TelaObrigacaoRenderer)tableCellRenderer).getText().setForeground(table.getForeground());
			((TelaObrigacaoRenderer)tableCellRenderer).getText().setBackground(table.getBackground());
		}
		
		return text;
	}

	public JTextArea getText() {
		return text;
	}


}
