package circusRefine.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

import jcircus.JCircusController;
import jcircus.JCircusControllerFrame;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circuspatt.util.CircusLaw;

import circusRefine.Tactic.Principal.Tatica;
import circusRefine.core.CollectAnswer;
import circusRefine.core.ExternalManager;
import circusRefine.core.NoPrograma;
import circusRefine.core.TipoColeta;
import circusRefine.core.print.Printer;
import circusRefine.core.relations.RelationRowLaw;
import circusRefine.core.util.TermoColetado;
import circusRefine.util.CRefineException;
import circusRefine.util.CancelledInsertionOfParaExceptionn;
import circusRefine.util.CommentsMode;

/**
 * PopMenu com diversas funcionalidades que sera habilitada atraves da 
 * TelaDesenvolvimento que apesar de nao ser uma tela e sim uma janela interna,
 * seu nome perdurou como TelaDesenvolvimento por motivos históricos desde
 * as suas ligações hierárquicas com sua antencente REFINE.
 * Entre as diversas funcionalidades aqui presentes, destaco : a Coleta de Código
 * , Aplicação de Lei, Inserção de Comentarios, Visualizacao de Comentarios.
 * @author Alessandro 
 *
 */
public class PopMenuTelaDes extends JPopupMenu {

    /**
     *
     */
    private static final long serialVersionUID = 1L;
    private JMenu aplicarLei;
    /**
     * Para as táticas
     */
    private JMenu aplicarTatica;
    private JMenu animacao;
    private JMenu leiAplicada;
    private JMenuItem descricao;
    private JMenu comentarios;
    //private JMenuItem animar;
    private JMenuItem inserir;
    private JMenuItem visualizar;
    private JMenuItem editarComment;
    private JMenuItem remover;
    private JMenuItem parag;
    private JMenuItem copiar;
    private JMenu coletarCodigo;
    private JMenu acao;
    private JMenu processos;
    private JMenuItem termoInicial;
    private JMenu adicionar; /* opcao de adicionar Paragrafo no programa*/

    private JMenu editar; /* Opcao de copiar textos do programa*/

    private JMenu tradutor; //By Samuel Barrocas
    private JMenuItem abrirTradutor; //By Samuel Barrocas

    /*
     * Opção para ver o target em subdesenvolvimentos
     */
    private JMenu view;
    private JMenuItem target;
    private ExternalManager gerInterface;

    public PopMenuTelaDes(ExternalManager gerExt) {
        this.gerInterface = gerExt;
        jbInit();
    }

    private void jbInit() {


        aplicarLei = new JMenu();
        aplicarLei.setText(this.retornarMensagem("COD0288"));
        aplicarLei.setEnabled(false);


//Abaixo, código escrito por Samuel Barrocas
        abrirTradutor = new JMenuItem ();
        abrirTradutor.setText("Open JCircus");
        abrirTradutor.addActionListener (
        	new ActionListener () {
        		public void actionPerformed (ActionEvent e) {
        	        JCircusController controller = new JCircusControllerFrame(); //Este é o conteúdo do método "main" de JCircusPlusPlus
        		}
        	}
        );
        tradutor = new JMenu ();
        tradutor.setText("Translator to Java");
        tradutor.setEnabled(true);
        tradutor.add(abrirTradutor);
        tradutor.addActionListener (
        	new ActionListener () {
        		public void actionPerformed (ActionEvent e) {
        	        if (e.getSource() instanceof JMenuItem) {
        	        	
        	        }
        		}
        	}
        );
//Acima, código escrito por Samuel Barrocas
        /**
         * Para mostras as táticas que podem ser aplicadas
         */
        aplicarTatica = new JMenu();
        aplicarTatica.setText(this.retornarMensagem("ApplyTactic"));
        aplicarTatica.setEnabled(false);
        aplicarTatica.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                AplicarTatica_actionPerformed(e);
            }
        });

        /*animacao = new JMenu("Animar");
        animar = new JMenuItem("Animar");
        animar.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                TelaPrincipal tp = gerInterface.retornarTelaPrincipal();
                gerInterface.mostrarTelaAnimacao();
            }
        });

        animacao.add(animar);*/

        /** Metodo que verificara se a linha selecionada em questao ó uma linha
         * de uma lei aplicada*/
        habilitarAplicarLei();

        habilitarTaticas();

        leiAplicada = new JMenu();
        descricao = new JMenuItem();
        leiAplicada.setText(this.retornarMensagem("COD0286"));
        leiAplicada.setEnabled(false);

        /** Metodo que verificara se a linha selecionada em questao ó uma linha
         * de uma lei aplicada*/
        habilitarLeiAplicada();

        descricao.setText(this.retornarMensagem("COD0287"));

        descricao.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(ActionEvent e) {
                ExibirDetalhes_actionPerformed();
            }
        });

        leiAplicada.add(descricao);

        comentarios = new JMenu();
        comentarios.setText(this.retornarMensagem("COD0276"));


        inserir = new JMenuItem();
        inserir.setText(this.retornarMensagem("COD0129"));
        inserir.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                Comentario_actionPerformed(CommentsMode.INSERINDO);
            }
        });

        visualizar = new JMenuItem();
        visualizar.setText(this.retornarMensagem("COD0502"));
        visualizar.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                Comentario_actionPerformed(CommentsMode.VISUALIZANDO);
            }
        });

        editarComment = new JMenuItem();
        editarComment.setText(this.retornarMensagem("COD0507"));
        editarComment.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                Comentario_actionPerformed(CommentsMode.EDITANDO);
            }
        });

        remover = new JMenuItem();
        remover.setText(this.retornarMensagem("COD0508"));
        remover.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                RemoverComentario();
            }
        });

        habilitarComentarios();

        comentarios.add(inserir);
        comentarios.add(visualizar);
        comentarios.add(editarComment);
        comentarios.add(remover);

        coletarCodigo = new JMenu();
        coletarCodigo.setText(this.retornarMensagem("COD0290"));
        coletarCodigo.setEnabled(false);

        acao = new JMenu();
        acao.setText(this.retornarMensagem("COD0503"));
        acao.setEnabled(false);

        processos = new JMenu();
        processos.setText(this.retornarMensagem("COD0504"));
        processos.setEnabled(false);

        /*
         * Para SubDesenvolvimentos
         */
        termoInicial = new JMenuItem();
        termoInicial.setText(this.retornarMensagem("COD0505"));
        termoInicial.setEnabled(false);
        termoInicial.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                coletarTermoInicial();
            }
        });


        adicionar = new JMenu();
        adicionar.setText(this.retornarMensagem("COD0625"));
        adicionar.setEnabled(false);

        habilitarAdicionarParag();

        parag = new JMenuItem();
        parag.setText(this.retornarMensagem("COD0626"));
        parag.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                insertNewParagraph();
            }
        });

        adicionar.add(parag);

        if (gerInterface.isSubDevelopment(this.gerInterface.getSelectedDevelopment())) {

            view = new JMenu(this.retornarMensagem("COD0739"));
            target = new JMenuItem(this.retornarMensagem("COD0738"));
            target.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    visualizarTarget();
                }
            });
            view.add(target);
        }



        /* Editar->Copiar*/

        editar = new JMenu(this.retornarMensagem("COD0272"));
        editar.addMouseListener(new MouseListener() {

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                selecionarIntervalosLinhas();
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });

        copiar = new JMenuItem(this.retornarMensagem("COD0631"));

        copiar.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                copiarTextoSelecionado();
            }
        });
        editar.add(copiar);

        /* Verifica se o menu de acao e o menu devem ser habilitados*/
        if (this.gerInterface.retornarTelaPrincipal().getActionsPara().isEnabled()) {
            coletarCodigo.setEnabled(true);
            acao.setEnabled(true);
            processos.setEnabled(true);
            termoInicial.setEnabled(true);
        }

        getAcoes();
        getProcessos();

        /*
         * Adicionando itens ao coletarCodigo
         */
        if (this.gerInterface.isPODevelopment()) {
            /* Deve ser adicionado apenas ser */
            coletarCodigo.add(termoInicial);
        }
        coletarCodigo.add(acao);
        coletarCodigo.add(processos);



        //this.add(animacao);
        this.add(aplicarLei);
        this.add(leiAplicada);
        this.add(aplicarTatica);
        this.add(tradutor);
        this.add(new JSeparator());
        this.add(comentarios);
        this.add(coletarCodigo);
        this.add(new JSeparator());
        if (gerInterface.isSubDevelopment(this.gerInterface.getSelectedDevelopment())) {
            this.add(view);
        }
        this.add(adicionar);
        this.add(editar);

        //ANIMAR

       /* JMenuItem teste = new JMenuItem("teste");
        teste.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                teste();
            }
        });*/
        //this.add(teste);

    }

    /**
     * Coleta o Termo Inicial de um SubDesenvolvimento
     *
     */
    protected void coletarTermoInicial() {
        this.gerInterface.coletarTermoInicial();
        this.gerInterface.adicionarColetaInitialTermHist();
        this.gerInterface.updateScreen();
        this.gerInterface.atualizarOpcoes();
    }

    /**
     * Exibi uma janela contendo a impressóo do termo alvo
     * do subdesenvolvimento conrrente
     */
    protected void visualizarTarget() {
        String targetText = this.gerInterface.printTarget();

        CommentsFrame newFrame = new CommentsFrame(this.gerInterface, targetText);
        newFrame.setVisible(true);


    }

    /**
     * Seleciona um intervalo de linhas que esta apto a alguma
     * aplicacao de lei ou copiar algum texto
     *
     */
    protected void selecionarIntervalosLinhas() {
        this.gerInterface.retornarTelaDesenvolvimento().selecionarLinhas();
    }

    /**
     * Utilizado para copiar o texto selecionado do refinamento.
     *
     */
    protected void copiarTextoSelecionado() {
        this.gerInterface.copiarTextoSelecionado();
    }

    protected void teste() {
        int linhas[] = this.gerInterface.retornarLinhasSelecionadas();
        Term prog = (this.gerInterface.retornarProgramaSelecionado(linhas[0], linhas[1])).getPrograma();
        Printer printer = new Printer(false);
        String[] res = (String[]) printer.visitTerm(prog);
        for (int i = 0; i < res.length; i++) {
            System.out.println(res[i]);
        }
    }

    private void habilitarAdicionarParag() {
        if (this.gerInterface.getSizeOfHistorico() > 0) {
            this.adicionar.setEnabled(true);
        }
    }

    /**
     * Metodo que realiza a insercao de um novo paragrafo
     * no programa
     */
    protected void insertNewParagraph() {
        try {
            this.gerInterface.insertNewParagrah();
            this.gerInterface.updateScreen();
            this.gerInterface.atualizarTelaCodigo();
            this.gerInterface.retornarTelaPrincipal().habilitarUndo();
        } catch (CancelledInsertionOfParaExceptionn e) {
        } catch (CRefineException e) {
            ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, "",
                    e);
            errorDialog.setVisible(true);
        } catch (Exception except) {
            CRefineException e = new CRefineException(except, except.getMessage());
            ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, "",
                    e);
            errorDialog.setVisible(true);
        }

    }

    /**
     * Metodo verificar se podera inserir, visualizar e editar algum comentario
     *
     */
    private void habilitarComentarios() {

        int selectedIndices[] = this.gerInterface.retornarLinhasSelecionadas();
        boolean habilitandoCommentario = false;
        boolean habilitarInserir = false;
        boolean habilitarEditar = false;
        if (selectedIndices[0] != -1) {
            NoPrograma noprogs = this.gerInterface.retornarProgramaSelecionado(selectedIndices[0], selectedIndices[1]);
            Term result = null;
            if (noprogs != null) {
                result = noprogs.getPrograma();
            }
            //Verifica se ó a linha de inicio e final de algum termo
            if (result != null) {
                //Nesse caso deve-se verificar se o termo em questao ja possui comentario
                habilitarEditar = this.gerInterface.temComentario(selectedIndices[0], selectedIndices[1]);
                habilitarInserir = !habilitarEditar;
                habilitandoCommentario = true;
            }
        }
        //Verificação de Linha de Lei
        if (leiAplicada.isEnabled()) {
            //Nesse caso deve-se verificar se o termo em questao ja possui comentario
            habilitarEditar = this.gerInterface.temComentario(selectedIndices[0], selectedIndices[1]);
            ;
            habilitarInserir = !habilitarEditar;
            habilitandoCommentario = true;
        }

        comentarios.setEnabled(habilitandoCommentario);
        inserir.setEnabled(habilitarInserir);
        editarComment.setEnabled(habilitarEditar);
        visualizar.setEnabled(habilitarEditar);
        remover.setEnabled(habilitarEditar);

    }

    /**
     * Metodo que realiza a remocao do comentario na lista de Comentarios
     * guardada no Gerenciador Externo
     *
     */
    private void RemoverComentario() {
        int[] selectedIndices =
                this.gerInterface.retornarLinhasSelecionadas();
        this.gerInterface.removeComment(selectedIndices[0], selectedIndices[1]);
        this.gerInterface.retornarTelaDesenvolvimento().updateCommentIdentifierGUI(selectedIndices[0]);



    }

    private void Comentario_actionPerformed(CommentsMode e) {
        CommentsFrame newFrame = new CommentsFrame(this.gerInterface, e);
        newFrame.setVisible(true);
    }

    /**
     * Metodo que verificara quais das leis podem ser aplicadas ao termo
     * selecionado. Essas leis serao colocadas no JMenuItem, adicionadas ao
     * JMenu AplicarLei que ser ativado.
     */
    private void habilitarAplicarLei() {

        NoPrograma noProgramaSelected = this.gerInterface.getSelectedProg();

        Term termSelected = null;
        boolean habilitando = false;

        if (noProgramaSelected != null) {
            termSelected = noProgramaSelected.getPrograma();

        }

        if (termSelected != null) {
            List<CircusLaw> leisAplicaveis = this.gerInterface.aplicableLaws(termSelected);
            if (leisAplicaveis.size() > 0) {
                habilitando = true;
                SelecionarLinhasTermo();
                for (CircusLaw lei : leisAplicaveis) {
                    JMenuItem law = new JMenuItem(lei.getName());
                    law.addActionListener(new ActionListener() {

                        public void actionPerformed(ActionEvent e) {
                            AplicarLei_actionPerformed(e);
                        }
                    });

                    this.aplicarLei.add(law);
                }
            }

        }
        aplicarLei.setEnabled(habilitando);
    }

    /**
     * Metodo que seleciona o termo que sera alvo de uma possivel lei.
     */
    public void SelecionarLinhasTermo() {
        this.gerInterface.retornarTelaDesenvolvimento().selecionarLinhas();
    }

    private void AplicarLei_actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String lawName = ((JMenuItem) e.getSource()).getText();
            CircusLaw leiSelecionada = null;
            if (lawName != null) {
                List<CircusLaw> laws = this.gerInterface.getLaws();
                for (CircusLaw law : laws) {
                    if (law.getName() == lawName) {
                        leiSelecionada = law;
                    }
                }

                if (leiSelecionada != null) {
                    this.gerInterface.retornarCaixaLeis().aplicarLei(leiSelecionada);
                    this.gerInterface.desceRoll();
                }
            }

        }
    }

    /**
     * Método que aplica uma Tática ao Termo
     * @param e
     */
    private void AplicarTatica_actionPerformed(ActionEvent e) {


        if (e.getSource() instanceof JMenuItem) {
            String taticaName = ((JMenuItem) e.getSource()).getText();
            Tatica taticaSelecionada = null;
            if (taticaName != null) {
                List<Tatica> listaTaticas = this.gerInterface.retornarListaTaticas();
                for (Tatica tatica : listaTaticas) {
                    if (tatica.getId() == taticaName) {
                        taticaSelecionada = tatica;
                    }
                }

                if (taticaSelecionada != null) {
                    this.gerInterface.aplicarTatica(taticaSelecionada);
                    this.gerInterface.desceRoll();
                }
            }

        }
    }

    /**
     * Habilita o JMenu leiaplicada, verificando se a linha selecionada ó uma linha
     * de uma lei aplicada.
     *
     */
    private void habilitarLeiAplicada() {

        int[] selectedIndex = this.gerInterface.retornarLinhasSelecionadas();
        int linhaSelecionada = -1;
        if (selectedIndex[0] == selectedIndex[1]) {
            linhaSelecionada = (this.gerInterface.retornarLinhasSelecionadas())[0];
        }
        boolean habilitando = false;
        for (RelationRowLaw leiLinha : this.gerInterface.retornarPilhaDeLeis()) {

            if (linhaSelecionada == leiLinha.getLinha()) {
                habilitando = true;
            }
        }
        this.leiAplicada.setEnabled(habilitando);

    }

    private void getProcessos() {
        if (processos.isEnabled()) {

            List<String> nomes = this.gerInterface.listarNomesProcessPara();
            if (nomes != null) {

                for (String nomeDeProcesso : nomes) {
                    if (nomeDeProcesso != this.retornarMensagem("COD0514")) {

                        JMenuItem procColetado = new JMenuItem();
                        procColetado.setText(nomeDeProcesso);
                        procColetado.addActionListener(new ActionListener() {

                            public void actionPerformed(ActionEvent e) {
                                ColetarProcesso_actionPerformed(e);
                            }
                        });
                        this.processos.add(procColetado);
                    }
                }
            }

        }
    }

    public void ColetarProcesso_actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String key = ((JMenuItem) e.getSource()).getText();
            if (key != null) {
                CollectAnswer resposta = this.gerInterface.coletarCodigoProcesso(key);
                if (resposta != null) {
                    this.gerInterface.adicionarColetaAoHistorico(resposta);
                }
                this.gerInterface.updateScreen();
                this.gerInterface.desceRoll();
                TermoColetado newTerm = new TermoColetado(key, TipoColeta.PROCESSO);
                this.gerInterface.adicionarTermoColetado(newTerm);
                this.gerInterface.retornarTelaPrincipal().image_undo.setEnabled(true);
                this.gerInterface.esvaziarRedoPilhas();
            }
        }
    }

    /**
     * Metodo que sera utilizada para inserir os diversos JMenuItem referentes
     * as ações que podem ser coletadas.
     *
     */
    private void getAcoes() {

        //* Metodo so funcionara quando houver acoes a serem coletadas*/
        if (acao.isEnabled()) {

            List<String> nomes = this.gerInterface.listarNomesActionPara();
            if (nomes != null) {

                for (String nomeDeAcao : nomes) {
                    if (nomeDeAcao != this.retornarMensagem("COD0472")) {

                        JMenuItem acaoColetada = new JMenuItem();
                        acaoColetada.setText(nomeDeAcao);
                        acaoColetada.addActionListener(new ActionListener() {

                            public void actionPerformed(ActionEvent e) {
                                ColetarAcao_actionPerformed(e);
                            }
                        });
                        this.acao.add(acaoColetada);
                    }
                }
            }
        }
    }

    /**
     * Mótodo que retorna uma mensagem que seró impressa na tela, tanto na forma
     * de tótulo quanto na forma de mensagem de erro.
     *
     * @param codigo     O código da mensagem que seró retornada.
     *
     * @return           Uma String que representa a mensagem de retorno.
     *
     */
    public String retornarMensagem(String codigo) {
        String mensagem = gerInterface.getMessage(codigo);
        return mensagem;
    }

    /**
     * Metodo utilizado para tornar visivel a janela de inforamações de leis
     * Bem como os minuciosos detalhes da lei aplicada;
     */
    private void ExibirDetalhes_actionPerformed() {

        int selection = this.gerInterface.retornarLinhasSelecionadas()[0];
        CircusLaw leiSelecionada = null;
        for (RelationRowLaw leiLinha : this.gerInterface.retornarPilhaDeLeis()) {
            if (selection == leiLinha.getLinha()) {
                leiSelecionada = leiLinha.getLaw();
            }
        }
        if (leiSelecionada != null) {
            InfoLei infoLei = new InfoLei(leiSelecionada, this.gerInterface);
            infoLei.setVisible(true);
        }
    }

    /**
     * Método que realiza a coleção de ação
     *
     */
    void ColetarAcao_actionPerformed(ActionEvent e) {

        if (e.getSource() instanceof JMenuItem) {
            String key = ((JMenuItem) e.getSource()).getText();
            if (key != null) {
                CollectAnswer resposta = this.gerInterface.coletarCodigoAcao(key);
                if (resposta != null) {
                    this.gerInterface.adicionarColetaAoHistorico(resposta);
                }
                this.gerInterface.updateScreen();
                this.gerInterface.desceRoll();
                TermoColetado newTerm = new TermoColetado(key, TipoColeta.ACAO);
                this.gerInterface.adicionarTermoColetado(newTerm);
                this.gerInterface.retornarTelaPrincipal().image_undo.setEnabled(true);
                this.gerInterface.retornarTelaPrincipal().habilitarUndo();
                this.gerInterface.esvaziarRedoPilhas();
            }
        }
    }

    /**
     * Método que recebe as táticas da lista de Táticas atualizada
     *  e adiciona no JMenuItem para seram vizualizadas
     */
    private void habilitarTaticas() {


        popUpTaticas();

    }

    /**
     *  Método responsável por setar no menu
     *  aplicarTatica as Táticas do sistema
     */
    private void popUpTaticas() {

        boolean habilitando = false;
        List<Tatica> listaTaticas = this.gerInterface.retornarListaTaticas();
        if (listaTaticas.size() > 0) {
            habilitando = true;
            SelecionarLinhasTermo();
            for (Tatica tatica : listaTaticas) {
                JMenuItem itemTac = new JMenuItem(tatica.getId());
                itemTac.addActionListener(new ActionListener() {

                    public void actionPerformed(ActionEvent e) {
                        AplicarTatica_actionPerformed(e);
                    }
                });

                this.aplicarTatica.add(itemTac);
            }
        }


        aplicarTatica.setEnabled(habilitando);

    }
}
	
	

