package circusRefine.gui;

import java.awt.Font;
import java.awt.SystemColor;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import circusRefine.core.ExternalManager;

import net.sourceforge.czt.circus.ast.Transformation;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.z.util.ZString;

/**
 * Janela de exibio de detalhes de leis,  chamada atravs de um pop-up menu
 * na caixa de Leis. Mostra o nome da lei, seu tipo, as obrigaes, detalhes e 
 * 
 * @author Alessandro
 *
 */
public class InfoLei extends JFrame{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/* gerenciador de interface */
	private ExternalManager gerInterface;
	
	private JLabel nome;
	private JLabel obrigacoes;
	private JLabel observacoes;
	private JLabel termoAntes;
	private JLabel termoDepois;
	
	private JTextField campoNome;
	private JTextField simbolo;
	
	private JTextArea campoObrigacoes;
	private JTextArea campoObservacoes;
	private JTextArea antes;
	private JTextArea depois;
	
	private static final String BRANCO = "     ";
	private boolean first = true; /*utilizado na insero do campoObrigaes */
	
	
	
	public InfoLei(CircusLaw law, ExternalManager gerExt) {
		/*Nome da Lei inseriado na parte superior do Frame*/
		super(gerExt.getMessage("COD0483") + law.getName());
		gerInterface = gerExt;
		jbInit(law);
	}
	
	/**
	 * Metodo que inicializa os componentes do frame
	 *
	 */
	private void jbInit(CircusLaw lei){
		
		this.setResizable(false);
		this.setLayout(null);
		
		this.setSize(470, 540);
		this.setLocation(400, 50);
		
		/*Setando o Text dos Labels -> ver Internacionalizao*/
		nome = new JLabel(gerInterface.getMessage("COD0484"));
		obrigacoes = new JLabel(gerInterface.getMessage("COD0485"));
		observacoes = new JLabel(gerInterface.getMessage("COD0486"));
		termoAntes = new JLabel(gerInterface.getMessage("COD0487"));
		termoDepois = new JLabel(gerInterface.getMessage("COD0488"));
		
		/* JTextFields*/
		campoNome = new JTextField(35);
		simbolo = new JTextField(2);
		
		/*JTextArea*/
		
		campoObrigacoes = new JTextArea(6,35);
		campoObservacoes = new JTextArea(5,35);
		antes = new JTextArea(5,10);
		depois = new JTextArea(5,10);
		
		/* Setando o simbolo de acordo com o tipo de lei*/
		setTexts(lei);
				
		/* Setando Fonts*/
		
		campoNome.setFont(new Font("CZT",Font.ITALIC,12));
		campoObrigacoes.setFont(new Font("CZT",Font.PLAIN,12));
		campoObservacoes.setFont(new Font("CZT",Font.ITALIC,12));
		antes.setFont(new Font("CZT",Font.PLAIN,12));
		depois.setFont(new Font("CZT",Font.PLAIN,12));
		simbolo.setFont(new Font("CZT", Font.ROMAN_BASELINE,16));
		
		
		/* Configurando JTextAreas*/
		
		campoNome.setEditable(false);
		campoObrigacoes.setEditable(false);
		campoObservacoes.setEditable(false);
		antes.setEditable(false);
		depois.setEditable(false);
		simbolo.setEditable(false);
		
		campoNome.setBackground(SystemColor.WHITE);
		campoObrigacoes.setBackground(SystemColor.WHITE);
		campoObservacoes.setBackground(SystemColor.WHITE);
		antes.setBackground(SystemColor.WHITE);
		depois.setBackground(SystemColor.WHITE);
		simbolo.setBackground(SystemColor.WHITE);
		
		
		/* Setando JScrollPanes*/

		JScrollPane obri = new JScrollPane(campoObrigacoes);
		JScrollPane obs = new JScrollPane(campoObservacoes);
		JScrollPane before = new JScrollPane(antes);
		JScrollPane after = new JScrollPane(depois);
		
		/* Confogurando Tamanhos e adicionando ao Frame*/
		
		nome.setBounds(10, 10, 60, 20);
		campoNome.setBounds(10, 35, 445, 25);
		obrigacoes.setBounds(10, 70, 90,20 );
		obri.setBounds(10, 95, 445, 110);
		observacoes.setBounds(10, 215, 90, 20);
		obs.setBounds(10, 240, 445, 75);
		termoAntes.setBounds(10, 315, 50, 20);
		termoDepois.setBounds(255,315,50,20);
		before.setBounds(10, 350, 190, 145);
		after.setBounds(265, 350, 190, 145);
		simbolo.setBounds(217,415,30,30 );
		
		add(nome);
		add(campoNome);
		add(obrigacoes);
		add(obri);
		add(observacoes);
		add(obs);
		add(termoAntes);
		add(termoDepois);
		add(before);
		add(after);
		add(simbolo);
		
	}
	
	/**
	 * Metodo que determina se o simbolo sera um simbolo de refinamento, 
	 * de simulacao ou de equivalencia
	 * @param law Lei corrente na janela
	 */
	private void setSymbol(CircusLaw law) {
		
		Transformation res = this.gerInterface.getType(law);
		if (res.equals(Transformation.Equivalence)){
			simbolo.setText( " " + CircusString.EQUALS);
		}
		else if (res.equals(Transformation.Refinement)){
			simbolo.setText("  " + CircusString.CIRCREFINES);
		}
		else {
			simbolo.setText( " " + CircusString.CIRCSIMULATES);
		}
	}
	
	/**
	 * Metodo que ira setar o texto dos diversos componenetes dentro
	 * do frame de informao da lei
	 * @param law a Lei base desse container
	 */
	public void setTexts (CircusLaw law) {
		this.campoNome.setText(law.getName());
		setSymbol(law);
		this.gerInterface.setarObrigacoesDaLei(law, this);
		this.gerInterface.setarObservacaoDaLei(law, this);
		this.gerInterface.setarAntesDaLei(law,this);
		this.gerInterface.setarDepoisDaLei(law,this);
		this.repaint();
	}
	
	/**
	 * Metodo que seta o conteudo do JTextArea observacoes
	 * @param str Vetor de Strings que sera as observacoes a respeito
	 * da lei corrente na InfoLei
	 */
	public void setarObservacoes(String[] str) {
		String result = "";
		for (int i=0;i< str.length;i++) {
			result+= ZString.SPOT + " " + str[i] + "\n";
		}
		this.campoObservacoes.setText(result);
	}
	/**
	 * Metodo que seta as obrigacoes no campo de Obrigacoes
	 * @param str A string obtida atraves do visitor de printer no Gerenciador
	 * Externo 
	 * @param identificador Identificador para saber em qual posicao sera 
	 * setada a String.  o simbolo romano a frente da obrigao de prova.
	 */
	public void setObrigacoes (String[] str, int identificador) {
		String romano =this.gerInterface.natToRom(identificador, 0);
		String result = "";
		String space = "";
		for (int i =0;i< romano.length();i++) {
			space += " ";
		}

		result = romano + BRANCO + str[0] + "\n";

		for (int i=1;i<str.length;i++) {
			result+= space + BRANCO + str[i] + "\n"; 
		}
		
		if (first) {
			this.campoObrigacoes.setText(result);
			first = false;
		}
		else {
			String originalText = this.campoObrigacoes.getText();
			originalText += "\n" + result;
			this.campoObrigacoes.setText(originalText);
		}
		identificador++;
	}
	/**
	 * Metoto Set do campo Antes
	 * @param str String a ser setada, representa a situao anterior a aplicao
	 * da lei
	 */
	public void setAntes (String[] str) {
		
		String result = "";
		for (int i=0;i<str.length;i++) {
			result += str[i] + "\n";
		}
		this.antes.setText(result);
	}
	
	/**
	 * Metoto Set do campo Depois
	 * @param str String a ser setada, representa a situao posterior a aplicao
	 * da lei
	 */
	public void setDepois (String[] str) {
		
		String result = "";
		for (int i=0;i<str.length;i++) {
			result += str[i] + "\n";
		}
		this.depois.setText(result);
	}
	
	
	
}
