package circusRefine.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import circusRefine.core.ExternalManager;

/**
 * Menu chamado para salvar um programa antes que haja alguma operacao de carregar uma nova especificacao,
 * carregar um programa salvou ou fechar o CRefine
 * @author alessandro87
 *
 */
public class DialogSave extends JDialog {

	private JButton save;
	private JButton discard;
	private JButton cancel;
	private ExternalManager gerInterface;
	private JLabel label;
	private SaveChanges answer;
	private boolean toQuit;
	
	public DialogSave (ExternalManager ext, String nome, boolean quit){
		this.setTitle(nome);
		gerInterface = ext;
		this.setModal(true);
		this.setResizable(true);
		this.setLayout(null);
		answer = SaveChanges.CANCELAR;
		toQuit = quit;
		jbInit();
		
	}

	public String getMessage(String cod){
		return gerInterface.getMessage(cod);
	}
	
	public SaveChanges getAnswer(){
		return answer;
	}
	
	private void jbInit() {
		
		this.setLocation(250, 200);
		this.setSize(400, 110);
		
		
		label = new JLabel(this.getMessage("COD0730"));
		label.setLocation(15, 10);
		label.setSize(500, 20);
		
		save = new JButton(this.getMessage("COD0005"));
		save.setSize(80, 20);
		save.setLocation(label.getX() + 20, label.getY() + 40);
		save.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				salvarAlteracoes();
			}
			
		});
		
		cancel = new JButton(this.getMessage("COD0078"));
		cancel.setSize(120,20);
		cancel.setLocation(save.getX() + save.getWidth() + 10, save.getY());
		cancel.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				cancelar();
			}
			
		});
		
		discard = new JButton(this.getMessage("COD0079"));
		discard.setSize(100, 20);
		discard.setLocation(cancel.getX() + cancel.getWidth() + 10, save.getY());
		discard.addActionListener( new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				discartarAlteracoes();
			}
			
		});
		
		add(save);
		if (toQuit) {
			JButton discardALL = new JButton(this.getMessage("COD0737"));
			discardALL.setSize(120,20);
			discardALL.setToolTipText(this.getMessage("COD0737"));
			discardALL.setLocation(save.getX() + save.getWidth() + 10, save.getY());
			discardALL.addActionListener(new ActionListener(){

				public void actionPerformed(ActionEvent e) {
					descartarTodos();
				}
				
			});
			this.add(discardALL);
		}
		else {
			add(cancel);
		}
		
		add(label);
		add(discard);
		
	}

	protected void discartarAlteracoes() {
		answer = SaveChanges.DESCARTAR_ALTERACOES;
		this.setVisible(false);
	}

	protected void cancelar() {
		answer = SaveChanges.CANCELAR;
		this.setVisible(false);
	}
	
	protected void descartarTodos() {
		answer = SaveChanges.DESCARTAR_TODOS;
		this.setVisible(false);
	}

	protected void salvarAlteracoes() {
		answer = SaveChanges.SALVAR_ALTERACOES;
		this.setVisible(false);
	}
}
