/*
 * Projeto : Refine - Ferramenta Educacional para Refinamentos
 *
 * Tipo : TelaLeis
 *
 */
package circusRefine.gui;

import java.awt.Dimension;
import java.awt.Font;

import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circuspatt.util.CircusLaw;
import net.sourceforge.czt.rules.unification.UnificationException;
import circusRefine.Tactic.Util.GerenciadorTaticas;
import circusRefine.core.ExternalManager;
import circusRefine.core.NoPrograma;
import circusRefine.core.crules.CRulesException;
import circusRefine.core.crules.CancelledApplException;
import circusRefine.util.CRefineException;
import circusRefine.util.CodigoParametro;

/**
 * TelaLeis � um tipo que representa a tela que exibe todas as leis de c�lculo
 * de refinamentos que s�o suportadas pela ferramenta.
 * @author Alessandro
 */
public class CaixaLeis extends JTextField{

	private static final long serialVersionUID = -1715076912517106544L;
	private ExternalManager gerInterface;
	private JDialog telaParametro;

	/*indica qual a tela de Parametro esta sendo usada */
	private int numeroTelaParam = 0;
	private boolean changeFont;
	
	JPopupMenu popUpMenu;
	
	/* Itens utilizados no JPopMenu*/
	private JMenuItem aplicar;
	private JMenuItem exibir;

	
	/**
	 * Construtor da classe FapLeis.
	 *
	 * @param gerInterface   Gerenciador de todas as telas do sistema.
	 *
	 */
	public CaixaLeis(ExternalManager gerInterface) {
		try  {
			this.gerInterface = gerInterface;
			this.changeFont = false;
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	/**
	 * Classe utilizada para os inserir tooltiptext nas celulas do JComboBox
	 * - comentada apos mudanca de Caixa Leis para JTextField
	 */
	/*class MyComboBoxRenderer extends BasicComboBoxRenderer {
		
		private int quant; // quantidade de leis
		
		public MyComboBoxRenderer(int x) {
			quant = x;
		}
		
		public Component getListCellRendererComponent( JList list,
				Object value, int index, boolean isSelected, boolean cellHasFocus) {
			if (isSelected) {
				setBackground(list.getSelectionBackground());
				setForeground(list.getSelectionForeground());
				if (index > -1) {
					list.setToolTipText(tooltips[index]);
				}
			} else {
				setBackground(list.getBackground());
				setForeground(list.getForeground());
			}
			setFont(list.getFont());
			setText((value == null) ? "" : value.toString());
			return this;
		}
	}*/
	
	
	

	/**
	 * Metodo que realiza a plica��o de lei atrav�s da chamada de m�todos
	 * de outras classes.
	 * @param leiSelecionada lei que sera aplicada ao termo selecionado na tela
	 * Desenvolvimento
	 * @throws UnificationException 
	 *
	 */
	public void aplicarLei(CircusLaw leiSelecionada)   {

		NoPrograma noPrograma = gerInterface.getSelectedProg();
		GerenciadorTaticas.lastProcess = noPrograma.getPrograma();
		if(noPrograma != null) {
			if(leiSelecionada != null) {
				try {
					gerInterface.applyLaw(noPrograma, leiSelecionada);
					gerInterface.updateScreen();
					gerInterface.updateLawIdentifierGUI(false);
					gerInterface.atualizarTelaObrigacoes();
					gerInterface.atualizarTelaCodigo();
					gerInterface.atualizarOpcoesColeta();
					
				}
				catch (CRefineException except) {
					except.printStackTrace();
					ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, "", 
							except);
					errorDialog.setVisible(true);
				}
				catch (CancelledApplException e){
					
				}
				catch (CRulesException except){
					except.printStackTrace();
					ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, "", 
							except);
					errorDialog.setVisible(true);
				}
				catch (Exception e){
					ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, e);
					errorDialog.setVisible(true);
					e.printStackTrace();
				}

			} else {
				JOptionPane.showMessageDialog(null, this.retornarMensagem("COD0063"), "Erro", JOptionPane.ERROR_MESSAGE);
				gerInterface.setarStatus("");
				gerInterface.setarFocus();
			}
		} else {
			JOptionPane.showMessageDialog(null, this.retornarMensagem("COD0464"), "Erro", JOptionPane.ERROR_MESSAGE);
			gerInterface.setarStatus("");
			gerInterface.setarFocus();
		}
	}


	/**
	 * Metodo que retornar a lei Selecionado no TextField de Leis
	 * @return
	 */
	public String retornarLeiSelecionada (){
		return this.getText();
	}

	/**
	 * Metodo que realiza a plica��o de lei atrav�s da chamada de m�todos
	 * de outras classes.
	 * @throws UnificationException 
	 *
	 */
	public void aplicarLei()   {

		NoPrograma noPrograma = gerInterface.getSelectedProg();
		if(noPrograma != null) {
			CircusLaw leiSelecionada = this.gerInterface.retornarLeiSelecionada();
			if(leiSelecionada != null) {
				try {
					gerInterface.applyLaw(noPrograma, leiSelecionada);
					gerInterface.updateScreen();
					gerInterface.atualizarTelaObrigacoes();
					gerInterface.retornarTelaDesenvolvimento().
					updateLawIdentifierGUI(false);
					gerInterface.atualizarTelaCodigo();
					gerInterface.atualizarOpcoesColeta();
				}
				catch(CRefineException e) {
					ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, "", 
							e);
					errorDialog.setVisible(true);
					e.printStackTrace();
				}
				catch (CancelledApplException e){
					
				}
				catch (CRulesException e){
					ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, "", 
							e);
					errorDialog.setVisible(true);
					e.printStackTrace();
				}
				catch (Exception e){
					ErrorDialog errorDialog = new ErrorDialog(this.gerInterface, e);
					errorDialog.setVisible(true);
					e.printStackTrace();
				}
				

			} else {
				JOptionPane.showMessageDialog(null, this.retornarMensagem("COD0063"), "Erro", JOptionPane.ERROR_MESSAGE);
				gerInterface.setarStatus("");
				gerInterface.setarFocus();
			}
		} else {
			JOptionPane.showMessageDialog(null, this.retornarMensagem("COD0464"), "Erro", JOptionPane.ERROR_MESSAGE);
			gerInterface.setarStatus("");
			gerInterface.setarFocus();
		}
	}

	/**
	 * M�todo que executa a a��o de se clicar no botao Aplicar.
	 *
	 * @param e          Evento do bot�o aplicar.
	 * @throws UnificationException 
	 *
	 */
	public void btnAplicar_actionPerformed(ActionEvent e) throws UnificationException {
		gerInterface.setarStatus(this.retornarMensagem("COD0040"));
		this.aplicarLei();
	}


	/**
	 * M�todo que retorna o n�mero da janela de par�metro corrente.
	 *
	 */
	public int getNumJanelaParam() {
		return numeroTelaParam;
	}

	/**
	 * Torna o popmenu das leis visivel. 
	 */
	private void mostrarPopMenu(MouseEvent e) {
		if (!(this.getText().equals(this.retornarMensagem("COD0592")))){
			this.popUpMenu.show(e.getComponent(), e.getX(),e.getY());
		}

	}

	/**
	 * Metodo utilizado para tornar visivel a janela de inforama��es de leis
	 * Bem como os minuciosos detalhes da lei;
	 */
	private void ExibirDetalhes_actionPerformed(){

		CircusLaw leiSelecionada = this.gerInterface.retornarLeiSelecionada();
		if (leiSelecionada != null) {
			InfoLei infoLei = new InfoLei(leiSelecionada, this.gerInterface);
			infoLei.setVisible(true);
		}

	}
	/**
	 * Inicializa os atributos da tela de leis.
	 *
	 */
	private void jbInit() throws Exception {
		
		this.setEditable(false);
		this.setEnabled(true);
		this.setBackground(SystemColor.WHITE);
		this.setText(this.retornarMensagem("COD0592"));
		this.setFont(new Font("",Font.ITALIC,10));
		
		this.setMinimumSize(new Dimension(gerInterface.getTamanhoHorizontal()*8/100, 20));
		this.setMaximumSize(new Dimension(gerInterface.getTamanhoHorizontal()*35/100, 20));
		this.setPreferredSize(new Dimension(gerInterface.getTamanhoHorizontal()*20/100, 20));

		popUpMenu = new JPopupMenu();
		aplicar = new JMenuItem();
		exibir = new JMenuItem();

		aplicar.setText(this.retornarMensagem("COD0288"));
		exibir.setText(this.retornarMensagem("COD0273"));

		aplicar.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					btnAplicar_actionPerformed(e);
				} catch (UnificationException e1) {
					e1.printStackTrace();
				}
			}
		});

		exibir.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ExibirDetalhes_actionPerformed();
			}
		});


		popUpMenu.add(aplicar);
		popUpMenu.add(new JSeparator());
		popUpMenu.add(exibir);

		this.addMouseListener(new MouseListener(){

			public void mouseClicked(MouseEvent e) {
				/* Butao Esquerdo do Mouse*/
				if (e.getButton() == e.BUTTON1) {
					mostrarLeis(e);
				}
				/*Butao Direito*/
				else if (e.getButton()== e.BUTTON3){
					mostrarPopMenu(e);
				}	
				HabilitarAplicarLei();
			}
			public void mouseEntered(MouseEvent e) {
			}
			public void mouseExited(MouseEvent e) {
			}
			public void mousePressed(MouseEvent e) {
			}
			public void mouseReleased(MouseEvent e) {
			}
		});
	}
	
	/**
	 * Esse metodo serve para abrir um popMenu de selecao de leis.
	 * A lei selecionada tera seu namo setado no JTextField de Lei
	 * @param e
	 */
	protected void mostrarLeis(MouseEvent e) {
		JPopupMenu menuLeis = new JPopupMenu();
		JMenu lei = new JMenu();
		
		ActionListener action = new ActionListener(){

			public void actionPerformed(ActionEvent e) {
				setarTexto(e);
			}
			
		};
		
		this.gerInterface.inicializarMenuDeLeis(lei, action);
		menuLeis.add(lei);
		menuLeis.show(e.getComponent(), e.getX(),e.getY());
	}

	/**
	 * Seta o nome da Lei selecionada no TextField
	 * @param e
	 */
	protected void setarTexto(ActionEvent e) {
		if (e.getSource() instanceof JMenuItem){
			if (!changeFont){
				this.setFont(new Font("",Font.PLAIN,10));
				changeFont = true;
			}
			
			this.setText(((JMenuItem)e.getSource()).getText());
			this.setToolTipText(((JMenuItem)e.getSource()).getText());
			this.gerInterface.retornarTelaDesenvolvimento().atualizar_Selecao();
		}
	}


	/**
	 * Metodo que habilita o JmenuItem responsavel por aplica��o de lei.
	 *
	 */
	private void HabilitarAplicarLei() {

		NoPrograma noProgramaSelecionado = this.gerInterface.getSelectedProg();
		CircusLaw leiInBox = this.gerInterface.retornarLeiSelecionada();
		Term termoSelecionado = null;
		if (noProgramaSelecionado != null) {
			termoSelecionado = noProgramaSelecionado.getPrograma();
		}
		this.aplicar.setEnabled(false);
		if (termoSelecionado != null){
			if (this.gerInterface.aplicableLaws(termoSelecionado).contains(leiInBox)){
				this.gerInterface.HabilitarAplicarLei();
				this.aplicar.setEnabled(true);
				this.gerInterface.retornarTelaDesenvolvimento().selecionarLinhas();
			}
			else {
				this.gerInterface.DesabilitarAplicarLei();
			}
		}
	}

	/**
	 * Metodo que exibi a TelaParametro coom o correspondente codigo
	 * @param cod codigo que representa o tipo de argumento a ser digitado
	 * @param str Guarda o nome do argumento(nome da metavari�vel)
	 * @return
	 */
	public String mostrarTelaParametro(CodigoParametro cod, String str){
		telaParametro = new TelaParametro(gerInterface);
		((TelaParametro)telaParametro).mostrarTelaParametro(cod, str);
		return ((TelaParametro)telaParametro).getArgument();
	}


	/**
	 * M�todo que retorna uma mensagem que ser� impressa na tela, tanto na forma
	 * de t�tulo quanto na forma de mensagem de erro.
	 *
	 * @param codigo     O c�digo da mensagem que ser� retornada.
	 *
	 * @return           Uma String que representa a mensagem de retorno.
	 *
	 */
	public String retornarMensagem(String codigo) {
		String mensagem = gerInterface.getMessage(codigo);
		return mensagem;
	}



}
