/*
 * Cristiano Gurgel de Castro
 * 
 * Projeto: Circus Refine
 */
package circusRefine.core.util;

import java.io.StringWriter;

import circusRefine.core.relations.RelationsUtils;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;

/**
 * Implementa o viditor com a funcionalidade de clone da AST
 * 
 * @author Cristiano Gurgel
 * @param <E>
 */
public class ClonerVisitor implements TermVisitor<Term> {

	/**
	 * Clona um termo da AST
	 * 
	 * @param term o termo a ser clonado
	 * @return o clone do termo
	 * @see #visitTerm(Term)
	 */
	@SuppressWarnings("unchecked")
	public static <T extends Term> T cloneTerm(T term) {
		ClonerVisitor cloner = new ClonerVisitor();
		T result = (T)term.accept(cloner);
		//System.out.println(cloner.getInfo());
		return result;
	}
	
	/**
	 * Clona um termo da AST removendo a pilha de relacionamentos do 
	 * clone.
	 * 
	 * @param term o termo a ser clonado
	 * @return o clone do termo
	 * @see #cloneTerm(Term)
	 */
	public static <T extends Term> T cloneTermRemovingRelationsStack(T term) {
		T clone = ClonerVisitor.cloneTerm(term);
		RelationsUtils.removeStack(clone);
		return clone;
	}
	
	/** Log para a documenta��o */
	private StringWriter log;
	
	/**
	 * Construtor vazio
	 */
	public ClonerVisitor() {
		this.setLog(new StringWriter());
		this.addMessage("Novo log do Cloner: " + this);
	}

	/**
	 * Acessa o log da classe
	 * 
	 * @return a informacao sobre unificacao
	 */
	public String getInfo() {
		return this.getLog().toString();
	}
	
	private StringWriter getLog() {
		return log;
	}
	
	private void setLog(StringWriter log) {
		this.log = log;
	}
	
	/**
	 * Adiciona uma mensagem ao log de unificacao
	 * 
	 * @param msg a mensagem a ser adicionada
	 */
	private void addMessage(String msg) {
		this.getLog().append(msg + "\n");
	}
	
	/**
	 * Percorre a AST recursivamente e clona seus termos
	 * 
	 * @param termo o termo a ser clonado
	 * @return o clone do termo
	 */
	public Term visitTerm(Term termo) {
		return VisitorUtils.visitTerm(this, termo, false);
	}
	
}
