/*
 * Projeto: Circus Refine
 */
package circusRefine.core.storage;

import javax.swing.JOptionPane;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

import circusRefine.core.ExternalManager;

/**
 * Classe que guarda a ao de adicionar um comentrio a um termo do 
 * refinamento
 * 
 * @author Cristiano Castro
 */
@XStreamAlias("NewComment")
public class AdicaoComentario implements StepOfExecution {

	/**
	 * Nmero da serializao
	 */
	private static final long serialVersionUID = -8342193959240102533L;

	/** Comentrio adicionado */
	private String comentario;
	
	/** Linha inicial */
	@XStreamAsAttribute
	private int linhaInicial;
	
	/** Linha final */
	@XStreamAsAttribute
	private int linhaFinal;
	
	/** Identificador de Comentario */
	private int identificador;

	/**
	 * Inicia a adio de comentrio. 
	 * 
	 * @param comentario a string com o comentrio
	 * @param linhaInicial a linha inicial no qual foi aplicado o 
	 * comentrio
	 * @param linhaFinal a linha final no qual foi aplicado o comentrio
	 */
	public AdicaoComentario(String comentario, int linhaInicial, 
			int linhaFinal, int idt) {
		super();
		this.setComentario(comentario);
		this.setLinhaInicial(linhaInicial);
		this.setLinhaFinal(linhaFinal);
		this.setIdentificador(idt);
	}

	/**
	 * Acessao o contedo do comentrio adicionado
	 * 
	 * @return o comentrio que foi adicionado
	 */
	public String getComentario() {
		return comentario;
	}

	public void setComentario(String comentario) {
		this.comentario = comentario;
	}

	public int getLinhaFinal() {
		return linhaFinal;
	}

	public void setLinhaFinal(int linhaFinal) {
		this.linhaFinal = linhaFinal;
	}

	public int getLinhaInicial() {
		return linhaInicial;
	}

	public void setLinhaInicial(int linhaInicial) {
		this.linhaInicial = linhaInicial;
	}

	public void doStep(ExternalManager externo) {
		
		externo.insertComment(this.getComentario(), this.getLinhaInicial(), 
				this.getLinhaFinal());
		
	}

	public void undoStep(ExternalManager externo) {
		externo.desfazerAdicaoComentario();
	}

	public int getIdentificador() {
		return identificador;
	}

	public void setIdentificador(int identificador) {
		this.identificador = identificador;
	}

	public void redoStep(ExternalManager externo) {
		externo.refazerAdicaoComentario();
	}
	
	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void redoPrintLatexStep(ExternalManager externo) {
		
	}
	/**
	 * Nao realizam funcao alguma na impressao de saida do docgenerator
	 */
	public void undoPrintLatexStep(ExternalManager externo) {
		
	}

}
