package circusRefine.core.relations;

import java.util.List;

import javax.swing.JOptionPane;

import circusRefine.core.relations.RelationsUtils;
import circusRefine.core.util.ChildrenTermExtractor;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;

/**
 * Classe visitor utilizada para atualizar as anotaes referentes ao relacionamento
 * entre termos e linhas iniciais e finais. Ela sera sempre chamada quando houver uma 
 * aplicao de lei ou uma coleo de ao ou processo. 
 * @author Alessandro
 *
 */
public class UpdateRelationsVisitor implements TermVisitor<Void> {
	
	/* Aumento na atualizao do term  */
	private int adder;
	
	public UpdateRelationsVisitor (int x) {
		adder = x;
	}
	
	public void setAdder (int y){
		adder = y;
	}
	
	/**
	 * Metodo que gera a atualizao dos relacionamentos
	 * @param termo Objeto em que sera feia a atualizao do relacionamento, seus 
	 * filhos tambm sero alterados
	 */
	public Void visitTerm(Term termo) {

		if (!RelationsUtils.retornaPilha(termo).isEmpty()) {
			
			RelationsUtils.retornarTopo(termo).addLinhas(adder);
		}

		/*  importante lembrar que os filhos tb devem ter seus campos
		 * atualizados
		 */
		ChildrenTermExtractor extrator = new ChildrenTermExtractor();
		List<Term> filhos = termo.accept(extrator);

		for (Term filho : filhos) {
			filho.accept(this);
		}
		return null;
	}
		
}
