package circusRefine.core.relations;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;

public class StackForRedoRemoveVisitor implements TermVisitor {

	/** Construtor padro */
	public StackForRedoRemoveVisitor() { }
	
	/**
	 * Remove a pilha de relacionamentos de redo de uma AST.
	 * 
	 * @param termo o termo a ser visitado
	 * @return <code>null</code>.
	 * @throws NullPointerException caso termo seja 
	 * 		<code>null</code>.
	 */
	public Void visitTerm(Term termo) {
		int cont = -1;
		int i = 0;
		for (Object ann : termo.getAnns()) {
			if (ann instanceof RelationsAnnStackForRedo) {
				cont = i;
			}
			i++;
		}
		
		if (cont != -1) {
			termo.getAnns().remove(cont);
		}
		
		/* Remove a pilha de relacionamento dos filhos */
		VisitorUtils.visitTerm(this, termo);
		return null;
	}
}
