/*
 * Projeto: Circus Refine 
 */
package circusRefine.core.relations;

import java.util.EmptyStackException;

import net.sourceforge.czt.base.ast.Term;

/**
 * Visitor utilizado para remover o relacionamento mais atual de um 
 * termo.
 * 
 * @author Cristiano Gurgel
 */
public class RemoveVisitor {

	public RemoveVisitor() { }
	
	/**
	 * Mtodo utilitrio para remover o relacionamento mais atual de 
	 * um termo
	 * 
	 * @param termo o termo a ter o relacionamento removido
	 */
	public static void removeRelationsAnn(Term termo) {
		RelationsAnnStackGetter getter = new RelationsAnnStackGetter();
		RelationsAnnStack pilha = termo.accept(getter);
		
		try {
			pilha.pop();
		} catch (EmptyStackException e){
			// nao faz nada
		}
		
	}
	
}
	
