/*
 * Projeto: Circus Refine 
 */
package circusRefine.core.relations;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;

/**
 * Visitor para acessar a pilha de Redo de um term.
 * 
 * @author Cristiano Gurgel
 */
public class RelationsAnnStackForRedoGetter implements 
		TermVisitor<RelationsAnnStackForRedo> {
	
	/** Construtor padro */
	public RelationsAnnStackForRedoGetter() { }

	/**
	 * Visita o termo retorna a pilha de redo, caso esta exista. Caso
	 * contrrio, este visitor cria a pilha e a retorna.
	 * 
	 * @param termo o termo a ser visitado
	 * @return a pilha de redo do termo, criando-a caso essa no 
	 * 		exista.
	 */
	public RelationsAnnStackForRedo visitTerm(Term termo) {
		for (Object ann : termo.getAnns()) {
			if (ann instanceof RelationsAnnStackForRedo) {
				return (RelationsAnnStackForRedo)ann;
			}
		}
		
		/* Adiciona a anotao no termo e a retorna */
		RelationsAnnStackForRedo nova = new RelationsAnnStackForRedo();
		termo.getAnns().add(nova);
		return nova;
	}

}
