/*
 * ProcessPrint.java
 *
 * Created on 19 de Setembro de 2005, 19:18
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import java.util.List;


import net.sourceforge.czt.circus.ast.AlphabetisedParallelProcessIdx;
import net.sourceforge.czt.circus.ast.AlphabetisedParallelProcessIte;
import net.sourceforge.czt.circus.ast.AssignmentPairs;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CallUsage;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ExtChoiceProcessIdx;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.IndexedProcess;
import net.sourceforge.czt.circus.ast.IntChoiceProcessIdx;
import net.sourceforge.czt.circus.ast.InterleaveProcess;
import net.sourceforge.czt.circus.ast.InterleaveProcessIdx;
import net.sourceforge.czt.circus.ast.InterleaveProcessIte;
import net.sourceforge.czt.circus.ast.ParProcessIdx;
import net.sourceforge.czt.circus.ast.ParProcessIte;
import net.sourceforge.czt.circus.ast.ParallelProcess;
import net.sourceforge.czt.circus.ast.ParallelProcessIdx;
import net.sourceforge.czt.circus.ast.ParallelProcessIte;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.Process1;
import net.sourceforge.czt.circus.ast.Process2;
import net.sourceforge.czt.circus.ast.ProcessD;
import net.sourceforge.czt.circus.ast.ProcessIdx;
import net.sourceforge.czt.circus.ast.ProcessIte;
import net.sourceforge.czt.circus.ast.RenameProcess;
import net.sourceforge.czt.circus.ast.SeqProcessIdx;
import net.sourceforge.czt.circus.visitor.AlphabetisedParallelProcessIdxVisitor;
import net.sourceforge.czt.circus.visitor.AlphabetisedParallelProcessIteVisitor;
import net.sourceforge.czt.circus.visitor.BasicProcessVisitor;
import net.sourceforge.czt.circus.visitor.CallProcessVisitor;
import net.sourceforge.czt.circus.visitor.CircusProcessVisitor;
import net.sourceforge.czt.circus.visitor.ExtChoiceProcessIdxVisitor;
import net.sourceforge.czt.circus.visitor.HideProcessVisitor;
import net.sourceforge.czt.circus.visitor.IndexedProcessVisitor;
import net.sourceforge.czt.circus.visitor.IntChoiceProcessIdxVisitor;
import net.sourceforge.czt.circus.visitor.InterleaveProcessIdxVisitor;
import net.sourceforge.czt.circus.visitor.InterleaveProcessIteVisitor;
import net.sourceforge.czt.circus.visitor.ParProcessIdxVisitor;
import net.sourceforge.czt.circus.visitor.ParProcessIteVisitor;
import net.sourceforge.czt.circus.visitor.ParallelProcessIdxVisitor;
import net.sourceforge.czt.circus.visitor.ParallelProcessIteVisitor;
import net.sourceforge.czt.circus.visitor.ParamProcessVisitor;
import net.sourceforge.czt.circus.visitor.Process1Visitor;
import net.sourceforge.czt.circus.visitor.Process2Visitor;
import net.sourceforge.czt.circus.visitor.ProcessDVisitor;
import net.sourceforge.czt.circus.visitor.ProcessIdxVisitor;
import net.sourceforge.czt.circus.visitor.ProcessIteVisitor;
import net.sourceforge.czt.circus.visitor.RenameProcessVisitor;
import net.sourceforge.czt.circus.visitor.SeqProcessIdxVisitor;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.InclDecl;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZNameList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.ast.JokerProcess;
import net.sourceforge.czt.circuspatt.visitor.JokerProcessVisitor;
import circusRefine.core.NoPrograma;
import circusRefine.core.Relacionamento;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;

/**
 *
 * @author comp
 */
public class ProcessPrint 
extends Print 
implements CircusProcessVisitor,
Process1Visitor,
Process2Visitor,
CallProcessVisitor,
BasicProcessVisitor,
ProcessDVisitor,
ProcessIteVisitor,
ProcessIdxVisitor,
IndexedProcessVisitor,
ParamProcessVisitor,
ParProcessIteVisitor,
AlphabetisedParallelProcessIteVisitor,
InterleaveProcessIteVisitor,
ParallelProcessIteVisitor,
IntChoiceProcessIdxVisitor,
ExtChoiceProcessIdxVisitor,
AlphabetisedParallelProcessIdxVisitor,
ParProcessIdxVisitor,
SeqProcessIdxVisitor,
ParallelProcessIdxVisitor,
InterleaveProcessIdxVisitor,
HideProcessVisitor,
RenameProcessVisitor,
JokerProcessVisitor{

	/** Creates a new instance of ProcessPrint */
	public ProcessPrint(Printer printer) {
		super(printer);
	}

	public Object visitCircusProcess(CircusProcess term)
	{
		return term.accept(this);
	}

	//ok - verificado em 15/09/2005 �s 19:03
	public Object visitProcess1(Process1 term)
	{
		return term.getCircusProcess().accept(this);
	}

	public Object visitProcess2(Process2 term)
	{
		getPercurso().append("Process2\n");
		String[] result = null;

		int index = 0;
		int linhaInicial = this.getCounterRow();

		String[] strProcL = (String[])term.getLeftProcess().accept(this);

		this.addCounterRow(1); 
		//Como o "\\extchoice" encontra-se ao meio dos outros termos o incremento
		// o incremento so podera ser realizado apos o visit da primeira parte

		String[] strProcR = (String[])term.getRightProcess().accept(this);
		result = new String[strProcL.length + strProcR.length + 1];

		for(int i=0; i<strProcL.length; i++) {
			result[index++] = BRANCO + strProcL[i];
		}

		result[index] = BRANCO + ((String[])term.accept(processPrint2()))[0];

		index++;
		for(int i=0; i<strProcR.length; i++) {
			result[index++] = BRANCO + strProcR[i];
		}


		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;

	}

	// ParamProcess ::= Declaration \odot Process
	//ok - verificado em 15/09/2005 �s 19:05
	public Object visitIndexedProcess(IndexedProcess term)
	{

		getPercurso().append("IndexedProcess\n");

		String[] result = null;
		int linhaInicial = this.getCounterRow();

		List<Decl> decsLaw = term.getZDeclList();
		String strDec = "";
		int size = decsLaw.size();
		int counter = 0;
		for(Decl vDec: decsLaw) {
			strDec = strDec + ((String[])vDec.accept(declPrint()))[0];
			if(counter < size-1) {
				strDec = strDec + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 2];
		if (!getUnicoded())
			result[0] = "(" + strDec + Space + "\\circindex" + Space;
		else 
			result[0] = "(" + strDec + Space + CircusString.CIRCINDEX + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		result[index] = ")";

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);


		return result;
	}

	// ParamProcess ::= Declaration @ Process
	//ok - verificado em 15/09/2005 �s 19:08
	public Object visitParamProcess(ParamProcess term)
	{
		String[] result = null;
		getPercurso().append("ParamProcess\n");
		int linhaInicial = this.getCounterRow();

		List<Decl> decsLaw = term.getZDeclList();
		String strDec = "";
		int size = decsLaw.size();
		int counter = 0;
		for(Decl vDec: decsLaw) {
			strDec = strDec + ((String[])vDec.accept(declPrint()))[0];
			if(counter < size-1) {
				strDec = strDec + ZString.SEMICOLON;
			}
			counter++;
		}

		this.addCounterRow(1);

		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 2];
		if (!getUnicoded())
			result[0] = "(" + strDec + " \\circspot ";
		else
			result[0] = "(" + strDec + Space + ZString.SPOT + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		result[index] = ")";

		int length = result.length;

		NoPrograma noProg = new NoPrograma(term);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;
	}

	// Process ::= begin PParagraph* state StateParagraph PParagraph* @ Action end
	// Process ::= begin PParagraph* @ Action end
	//ok - verificado em 15/09/2005 �s 19:11
	public Object visitBasicProcess(BasicProcess term)
	{
		String[] result = null;
		getPercurso().append("BasicProcessa\n");
		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1); // devido ao circbegin
		boolean isZParaList = true;

		//Isso deve-se ao fato de imprimirmos sempre a main action no final,
		//assim temos que certificar se eh realmente uma JJokerParalist que nao
		//contem Main Action;
		if (term.getParaList() instanceof JokerParaList) {
			isZParaList = false;
		}

		getPercurso().append("----->>>LOCALPARA\n");
		String[] strParas = (String[])term.getParaList().accept(paraLisPrint());

		//Caso em que nao ha a��o principal, apenas um nome de um JokerParaList
		if (!isZParaList) {
			int index =1;
			if (strParas != null ) {
				result = new String[strParas.length + 2];
				result[0] = "\\circbegin ";
				if (getUnicoded()){
					result[0] = CircusString.CIRCBEGIN;
				}
				for (int i=0; i< strParas.length; i++) {
					result[index++] = BRANCO + strParas[i];
				}
				result[index] = "\\circend";
				if (getUnicoded()) {
					result[index] = CircusString.CIRCEND;
				}
			}		  

		}
		//Caso ZParaList, contendo Main Action
		else {
			CircusAction main =  term.getMainAction();//term.getMainAction();

			//MainAction
			getPercurso().append("--->MAIN\n");

			this.addCounterRow(2);

			String[] strActMain = (String[])main.accept(actionPrint());
			String[] strMain = new String[strActMain.length + 3];
			strMain[0] = "";
			if (!getUnicoded()) {
				strMain[1] = BRANCO + Space + "\\circspot" + Space;
			}
			else{
				strMain[1] = BRANCO + Space + ZString.SPOT + Space;
			}
			int idx = 2;
			for(int i=0; i<strActMain.length; i++) {
				strMain[idx++] = BRANCO + strActMain[i];
			}
			strMain[idx] = "";

			int index =1;
			if (strParas != null ) {
				result = new String[strParas.length + strMain.length + 2];
				result[0] = "\\circbegin ";
				if (getUnicoded()){
					result[0] = CircusString.CIRCBEGIN;
				}
				for (int i=0; i< strParas.length; i++) {
					result[index++] = BRANCO + strParas[i];
				}
				for(int i=0; i<strMain.length; i++) {
					result[index++] = strMain[i];
				}
				result[index] = "\\circend";
				if (getUnicoded()) {
					result[index] = CircusString.CIRCEND;
				}
			}
			else {
				result = new String[strMain.length + 2];
				result[0] = "\\circbegin ";
				if (getUnicoded()){
					result[0] = CircusString.CIRCBEGIN;
				}
				for(int i=0; i<strMain.length; i++) {
					result[index++] = strMain[i];
				}
				result[index] = "\\circend";
				if (getUnicoded()) {
					result[index] = CircusString.CIRCEND;
				}
			}    
		}
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;
	}


	public Object visitCallProcess(CallProcess term)
	{
		String[] result =null;
		getPercurso().append("CAllProcess\n");

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);

		String[] strExprs; 
		strExprs = ((String[])term.getCallExpr().accept(exprPrint()));
		List<Expr> actualParams = term.getZActuals();
		String actParams = "";
		int size = actualParams.size();
		int counter = 0;
		for(Expr expr : actualParams) {
			actParams = actParams + ((String[])expr.accept(exprPrint()))[0];
			if(counter < size-1) {
				actParams = actParams + ",";
			}
			counter++;
		}

		int index = 0;
		//Caso em que nao ha parametros
		if (size == 0) {
			result = new String[strExprs.length ];
			for (int i =0 ; i< strExprs.length ; i++) {
				result[index++] = strExprs[i];
			}
		}
		else {

			result = new String[strExprs.length + 1];
			result[index++] = "(" + strExprs[0];

			for (int i =1 ; i< strExprs.length ; i++) {
				result[index++] = strExprs[i];
			}
			result[index++] = ")";
			index--;
			if(term.getUsage().equals(CallUsage.Parameterised)) {
				result[index] = result[index] + "(" + actParams + ")";
			}
			else if(term.getUsage().equals(CallUsage.Indexed)) {
				if (!getUnicoded())
					result[index] = result[index] + Space + "\\lcircindex" + Space 
					+ actParams + Space + "\\rcircindex" + Space;
				else
					result[index] = result[index] + Space + CircusString.CIRCLINST + Space 
					+ actParams + Space + CircusString.CIRCRINST + Space;
			}
		}

		int length = result.length;

		NoPrograma noProg = new NoPrograma(term);
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);

		return result;
	}

	//ok - verificado em 15/09/2005 �s 19:18
	public Object visitProcessD(ProcessD term)
	{
		return term.accept(processPrint());
	}

	public Object visitProcessIte(ProcessIte term)
	{
		String[] result = null;

		getPercurso().append("Processite\n");

		int linhaInicial = this.getCounterRow();
		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}
		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		String symbol = ((String[])term.getCircusProcess().accept(processItePrint()))[0];
		result = new String[strAct.length + 1];
		if (!getUnicoded())
			result[0] = symbol + Space + strDecls + Space + "\\circspot" + Space;
		else
			result[0] = symbol + Space + strDecls 
			+ Space + ZString.SPOT + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;
	}

	//ok
	public Object visitProcessIdx(ProcessIdx term)
	{
		return term.accept(this);
	}

	//ok
	public Object visitParProcessIte(ParProcessIte term)
	{
		return term.accept(this);
//		return visitProcessIte(term);
	}

	// Process ::= \Parallel Declaration @ |[CSExpression]| Process
	//ok - verificado em 15/09/2005 �s 19:27
	public Object visitAlphabetisedParallelProcessIte(AlphabetisedParallelProcessIte term)
	{
		String[] result = null;

		getPercurso().append("AlphabetisedPArallelProcesseIte\n");
		int linhaInicial = this.getCounterRow();

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 1];
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		if (!getUnicoded())
			result[0] = "\\Parallel" + Space + strDecls + Space + "\\circspot" + Space + "\\lpar" + 
			Space + strCS + Space + "\\rpar";
		else
			result[0] = CircusString.REPPARALLEL + Space + strDecls + Space + ZString.SPOT
			+ Space + CircusString.LPAR + Space + strCS + Space + CircusString.RPAR;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);


		return result;
	}

	// Process ::= \Interleave Declaration @ Process
	//ok - verificado em 15/09/2005 �s 19:28
	public Object visitInterleaveProcessIte(InterleaveProcessIte term)
	{
		String[] result = null;
		getPercurso().append("InterleaveProcessIte\n");
		int linhaInicial = this.getCounterRow();

		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 1];
		if (!getUnicoded())
			result[0] = "\\Interleave" + Space + strDecls + Space + "\\circspot" + Space ;
		else
			result[0] = CircusString.REPINTCHOICE + Space + strDecls 
			+ Space + ZString.SPOT + Space ;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);


		return result;
	}

	// Process ::= |[CSExpression]| Declaration @ Process
	//ok - verificado em 15/09/2005 �s 19:28
	public Object visitParallelProcessIte(ParallelProcessIte term)
	{
		String[] result = null;

		getPercurso().append("ParallelProcess\n");

		int linhaInicial = this.getCounterRow();
		List<Decl> decls = term.getZDeclList();
		String strDecls = "";
		int size = decls.size();
		int counter = 0;
		for(Decl decl : decls) {
			strDecls = strDecls + ((String[])decl.accept(declPrint()))[0];
			if(counter < size-1) {
				strDecls = strDecls + ";";
			}
			counter++;
		}

		this.addCounterRow(1);
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		result = new String[strAct.length + 1];
		if (!getUnicoded())
			result[0] = "\\lpar" + Space + strCS + Space + "\\rpar" + Space 
			+ strDecls + Space + "\\circspot" + Space;
		else
			result[0] = CircusString.LPAR + Space + strCS + Space + CircusString.RPAR + Space 
			+ strDecls + Space + ZString.SPOT + Space;
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), 
				term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;
	}

	public Object visitIntChoiceProcessIdx(IntChoiceProcessIdx term)
	{
		getPercurso().append("InterleaveProcessIdx\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);

		String[] strPrc = ((String[])term.getCircusProcess().accept(this));
		String strDecls = "";
		for (Decl decl : term.getZDeclList()) {
			strDecls += strDecls + ((String[])decl.accept(declPrint()))[0];
		}
		result = new String [1 + strPrc.length];
		if (!getUnicoded())
			result[0] = "\\Intchoice" + Space + strDecls + Space + "\\circindex";
		else
			result[0] = CircusString.REPINTCHOICE + Space + strDecls + Space + CircusString.CIRCINDEX;
		int index =1;
		for (int i = 0; i < strPrc.length;i++) {
			result[index++] = BRANCO + strPrc[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);


		return result;
	}

	//n�o existe mais
	public Object visitExtChoiceProcessIdx(ExtChoiceProcessIdx term)
	{
		getPercurso().append("ExtChoiceProcessIdx\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);
		
		String[] strPrc = ((String[])term.getCircusProcess().accept(this));
		String strDecls = "";
		for (Decl decl : term.getZDeclList()) {
			strDecls += strDecls + ((String[])decl.accept(declPrint()))[0];
		}
		result = new String [1 + strPrc.length];
		if (!getUnicoded())
			result[0] = "\\Extchoice" + Space + strDecls + Space + "\\circindex";
		else
			result[0] = CircusString.REPEXTCHOICE + Space + strDecls + Space + CircusString.CIRCINDEX;
		int index =1;
		for (int i = 0; i < strPrc.length;i++) {
			result[index++] = BRANCO + strPrc[i];
		}
		
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1),
				term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);
		
		
		return result;
	}

	//n�o existe mais
	public Object visitAlphabetisedParallelProcessIdx(AlphabetisedParallelProcessIdx term)
	{

		getPercurso().append("AlphabetisedParallelProcessIdx\n");
		String[] result = null;
		return result;
		/*    ChanSetType typeCS = (ChanSetType)term.getChannelSet().accept(exprChecker());
    // adicionando os canais usados...
    localCircTypeEnv().addUsedChans(typeCS.getChannels().getNameTypePair());
    //

    ProcessSignature procSignature = (ProcessSignature)visitProcessIdx(term);
    addProcessAnn(term, procSignature);

    return procSignature; */
	}

	//n�o existe mais
	public Object visitParProcessIdx(ParProcessIdx term)
	{	 getPercurso().append("ParProcessIdx\n");
	String[] result = null;
	return result;
//	return visitProcessIdx(term);
	}

	public Object visitSeqProcessIdx(SeqProcessIdx term)
	{
		getPercurso().append("SeqProcessIdx\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);
		
		String[] strPrc = ((String[])term.getCircusProcess().accept(this));
		String strDecls = "";
		for (Decl decl : term.getZDeclList()) {
			strDecls += strDecls + ((String[])decl.accept(declPrint()))[0];
		}
		result = new String [1 + strPrc.length];
		if (!getUnicoded())
			result[0] = "\\Semi" + Space + strDecls + Space + "\\circindex";
		else
			result[0] = CircusString.SEMI + Space + strDecls + Space + CircusString.CIRCINDEX;
		int index =1;
		for (int i = 0; i < strPrc.length;i++) {
			result[index++] = BRANCO + strPrc[i];
		}
		
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1),
				term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);
		
		
		return result;
	}
	
	public Object visitParallelProcessIdx(ParallelProcessIdx term)
	{	 
		getPercurso().append("ParallelProcessIdx\n");
		String[] result = null;
		return result;
		/*    ChanSetType typeCS = (ChanSetType)term.getChannelSet().accept(exprChecker());
    // adicionando os canais usados...
    localCircTypeEnv().addUsedChans(typeCS.getChannels().getNameTypePair());
    //

    ProcessSignature procSignature = (ProcessSignature)visitProcessIdx(term);
    addProcessAnn(term, procSignature);

    return procSignature; */
	}

	public Object visitInterleaveProcessIdx(InterleaveProcessIdx term)
	{
		getPercurso().append("InterleaveProcessIdx\n");
		String[] result = null;

		int linhaInicial = this.getCounterRow();
		this.addCounterRow(1);

		String[] strPrc = ((String[])term.getCircusProcess().accept(this));
		String strDecls = "";
		for (Decl decl : term.getZDeclList()) {
			strDecls += strDecls + ((String[])decl.accept(declPrint()))[0];
		}
		result = new String [1 + strPrc.length];
		if (!getUnicoded())
			result[0] = "\\Interleave" + Space + strDecls + Space + "\\circindex";
		else
			result[0] = CircusString.REPINTERLEAVE + Space + strDecls + Space + CircusString.CIRCINDEX;
		int index =1;
		for (int i = 0; i < strPrc.length;i++) {
			result[index++] = BRANCO + strPrc[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), 
				term, isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);


		return result;

	}


	// Process ::= Process \ CSExpression
	//ok - verificado em 15/09/2005 �s 19:36
	public Object visitHideProcess(HideProcess term)
	{
		String[] result = null;

		getPercurso().append("HideProcess\n");
		
		int linhaInicial = this.getCounterRow();

		int index = 1;
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		String[] strCS = (String[])term.getChannelSet().accept(exprPrint());
		result = new String[strAct.length + strCS.length];

		result[0] = "(" + strAct[0];
		for(int i=1; i<strAct.length; i++) {
			result[index++] = strAct[i];
		}

		if (!getUnicoded()) {
			result[index] = ")" + Space  + "\\circhide" + Space + strCS[0];
		}
		else {
			result[index] = ")" + Space  + CircusString.ZHIDE+ Space + strCS[0];
		}

		index++;
		for(int i=1; i<strCS.length; i++) {
			result[index++] = strCS[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial );

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);


		return result;
	}

	// Process ::= Process[N+ := N+]
	//ok - verificado em 15/09/2005 �s 19:38
	public Object visitRenameProcess(RenameProcess term)
	{
		String[] result = null;

		getPercurso().append("RenameProcess\n");
		int linhaInicial = this.getCounterRow();
		int index = 1;
		String[] strAct = (String[])term.getCircusProcess().accept(this);
		result = new String[strAct.length + 1];

		result[0] = "(" + strAct[0];
		for(int i=1; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		index--;
		result[index] = result[index] + ")";

		AssignmentPairs assignPairs = term.getAssignmentPairs();
		ZNameList namesLeft = assignPairs.getZLHS();
		ZExprList exprsRight = assignPairs.getZRHS();
		String str = "";
		int size = namesLeft.size();
		int counter = 0;
		for(Name name : namesLeft) {
			str = str + ((String[])name.accept(namePrint()))[0];

			if(counter < size-1) {
				str = str + Space + "," + Space;
			}
			counter++;
		}

		String strNew = "";
		size = exprsRight.size();
		counter = 0;
		for(Expr expr : exprsRight) {
			strNew = strNew + ((String[])expr.accept(exprPrint()))[0]; 
			if(counter < size-1) {
				strNew = strNew +  Space + "," + Space;
			}
			counter++;
		}

		index++;
		if (!getUnicoded())
			result[index] = "\\lcircrename" + Space + str + Space + ":=" + Space 
			+ strNew + Space + "\\rcircrename";
		else
			result[index] = CircusString.LCIRCRENAME + Space + str + Space + ":=" 
			+ Space + strNew + Space + CircusString.RCIRCRENAME;


		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial );

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());

		addRelacionamento(rel);

		return result;
	}

	// Process ::= Process \	 Process
	//ok - verificado em 15/09/2005 �s 19:39
	public Object visitInterleaveProcess(InterleaveProcess term)
	{
		getPercurso().append("InterleaveProcess\n");
		String[] result = null;

		int index = 0;
		int linhaInicial = this.getCounterRow();
		
		String[] strProcL = (String[])term.getLeftProcess().accept(this);
		this.addCounterRow(1);
		String[] strProcR = (String[])term.getRightProcess().accept(this);
		
		result = new String[strProcL.length + strProcR.length + 1];

		for(int i=0; i<strProcL.length; i++) {
			result[index++] = BRANCO + strProcL[i];
		}
		if (!getUnicoded())
			result[index] = BRANCO + "\\interleave";
		else
			result[index] = BRANCO + CircusString.INTERLEAVE;
		index++;
		for(int i=0; i<strProcR.length; i++) {
			result[index++] = BRANCO + strProcR[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial );

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);


		return result;
	}

	// Process ::= Process |[CSExpression]| Process
	//ok - verificado em 15/09/2005 �s 19:41
	public Object visitParallelProcess(ParallelProcess term)
	{
		getPercurso().append("ParallelProcess\n");
		int linhaInicial = this.getCounterRow();
		String[] result = null;

		int index = 0;

		String[] strProcL = (String[])term.getLeftProcess().accept(this);
		this.addCounterRow(1);
		String[] strProcR = (String[])term.getRightProcess().accept(this);
		String strCS = ((String[])term.getChannelSet().accept(exprPrint()))[0];
		result = new String[strProcL.length + strProcR.length + 1];

		for(int i=0; i<strProcL.length; i++) {
			result[index++] = BRANCO + strProcL[i];
		}

		if (!getUnicoded())
			result[index++] = BRANCO + "\\lpar" + Space + strCS + Space + "\\rpar"; 
		else
			result[index++] = BRANCO + CircusString.LPAR + Space + strCS + Space + CircusString.RPAR;
		for(int i=0; i<strProcR.length; i++) {
			result[index++] = BRANCO + strProcR[i];
		}

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length -1, noProg);
		this.setCounterRow(length +  linhaInicial );

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
		, term, isToInsertingRelAnn());
		addRelacionamento(rel);

		return result;
	}

	private boolean isSchExprAction(Para para, String stateName) {
		boolean result = false;

		if(para instanceof AxPara) {
			Decl axDecl = (Decl)((AxPara)para).getZSchText().getZDeclList().get(0);
			if(axDecl instanceof ConstDecl) {
				Expr exprAx = ((ConstDecl)axDecl).getExpr();
				if(exprAx instanceof SchExpr) {
					ZSchText schText = ((SchExpr)exprAx).getZSchText();
					List<Decl> decls = schText.getZDeclList();
					for(Decl decl : decls) {
						if(decl instanceof InclDecl) {
							Expr expr = ((InclDecl)decl).getExpr();
							if(expr instanceof RefExpr) {
								String refName = ((RefExpr)expr).getZName().getWord();
								if(refName.equals(stateName) 
										|| refName.equals(ZString.DELTA + stateName) 
										|| refName.equals(ZString.XI + stateName)
										|| refName.equals(stateName + "'")) 
								{
									result = true;
									break;
								}
							}
						}
					}
				}
			}
		}

		return result;
	}

	public Object visitJokerProcess(JokerProcess term) {
		getPercurso().append("JokerProcess\n");
		String[] result = new String[1];
		result[0] = term.getName();
		return result;
	}

}
