package circusRefine.core.print;

import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.util.CircusUtils;
import net.sourceforge.czt.circuspatt.ast.JokerPara;
import net.sourceforge.czt.circuspatt.ast.JokerParaList;
import net.sourceforge.czt.circuspatt.visitor.JokerParaListVisitor;
import net.sourceforge.czt.z.ast.LatexMarkupPara;
import net.sourceforge.czt.z.ast.NarrPara;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.visitor.ZParaListVisitor;


/**
 * Classe que implementa os Visitors ZParaListVisitor e JokerParaListVisitor
 * @author alessandro87
 *
 */
public class ParaListPrint extends Print
implements ZParaListVisitor,
		   JokerParaListVisitor{

	public ParaListPrint(Printer printer) {
		super(printer);
	}

	/**
	 * ZParaListVisitor, utilizado principalmente no BasicProcess,  visto algumas
	 * peculiaridades como no caso que a ao  um circusState.
	 */
	public Object visitZParaList(ZParaList paras) {

		String[] strParas = null;
		getPercurso().append("ZParaList\n");

		for (Para para : paras) {
			boolean isMainPara = false;
			//Verifica se  a Ao Principal, isso deve-se ao fato de getZParalist,
			// tb retornar o paragrafo da acao principal
			if ( para instanceof ActionPara) {
				ZName name = ((ActionPara)para).getZName();
				if (name.getWord().startsWith(CircusUtils.DEFAULT_MAIN_ACTION_NAME)) {
					isMainPara = true;
				}
			}
			if (!(para instanceof LatexMarkupPara || para instanceof NarrPara || isMainPara )) {

				String[] lPara = (String[])para.accept(paraPrint());
				
				for (int i=0; i< lPara.length;i++){
					getPercurso().append(lPara[i] + "\n");
				}
				
				if (CircusUtils.isStatePara(para)) {
					if (!getUnicoded()) {
						lPara[0] = "\\circstate\\ " + lPara[0];
					}
					else{
						lPara[0] = CircusString.CIRCSTATE + Space + lPara[0];
					}

				}
				if (strParas == null) {
					strParas = new String[lPara.length];
					for(int i=0; i<lPara.length; i++) {
						strParas[i] = lPara[i];
					}
				}
				else {
					String[] strTemp = new String[strParas.length + lPara.length];
					int index = 0;
					for(int i=0; i<strParas.length; i++) {
						strTemp[index++] = strParas[i];
					}
					for(int i=0; i<lPara.length; i++) {
						strTemp[index++] = lPara[i];
					}
					strParas = strTemp;
				}
			}
		}


	return strParas;
}

	public Object visitJokerParaList(JokerParaList paras) {
		String[] result;
		result = new String[1];
		result[0] = paras.getName();
		return result;
	}

}
