/*
 * DeclPrint.java
 *
 * Created on 13 de Setembro de 2005, 10:36
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import java.util.List;


import net.sourceforge.czt.circus.ast.ChannelDecl;
import net.sourceforge.czt.circus.ast.ParamQualifier;
import net.sourceforge.czt.circus.ast.QualifiedDecl;
import net.sourceforge.czt.circus.visitor.ChannelDeclVisitor;
import net.sourceforge.czt.circus.visitor.QualifiedDeclVisitor;
import net.sourceforge.czt.z.ast.*;
import net.sourceforge.czt.z.visitor.*;
import circusRefine.core.*;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.circus.util.CircusString;
import net.sourceforge.czt.circus.util.CircusUtils;

/**
 *
 * @author comp
 */
public class DeclPrint 
  extends Print
  implements VarDeclVisitor,
             ConstDeclVisitor,
             InclDeclVisitor,
             QualifiedDeclVisitor,
             ChannelDeclVisitor,
             DeclVisitor {
        
  
  /** Creates a new instance of DeclPrint */
  public DeclPrint(Printer printer) {
    super(printer);
  }
  
  public Object visitDecl(Decl decl) {
    return decl.accept(this);
  }

  public Object visitChannelDecl(ChannelDecl term)
  {
	  String[] result = new String[1];
	  getPercurso().append("ChannelDecl\n");
	  ZNameList genericParams = (ZNameList)term.getZGenFormals();
	  String strGP = "";
	  int size = genericParams.size();
	  int counter = 0;
	  
	  for(Name name : genericParams) {
		  if(counter == 0) {
			  strGP = "[";
		  }
		  ZName dec = (ZName)name;
		  
		  strGP = strGP + dec.getWord();
		  if(counter < size-1) {
			  strGP = strGP + ",";
		  }
		  else if(counter == size-1) {
			  strGP = strGP + "] ";
		  }
		  counter++;
	  }
	  
	  String str = "";
	  List<Name> decls = term.getZChannelNameList();
	  size = decls.size();
	  counter = 0;
	  for(Name ndecl : decls) {

		  String str2 = ((String[])ndecl.accept(namePrint()))[0];
		  if(counter < size-1) {
			  str += str2 + ", ";
		  }else{
			  str += str2;
		  }
		  counter++;
	  }
	 
	  Expr expr = term.getExpr();
	  String strExpr = new String();
	  if (expr != null) {
		  strExpr = ((String[])expr.accept(exprPrint()))[0];
		  if (size !=0) {
			  result[0] = strGP + str + Space + ZString.COLON + Space + strExpr;
			  if (strExpr.startsWith(CircusUtils.SYNCH_CHANNEL_TYPE_NAME.getWord())){
				  result[0] = strGP + str;	
			  }
		  }
		  else {
			  result[0] = strGP + str + strExpr;
		  }
	  }
	  else {
		  result[0] = strGP + str;
	  }

	  return result;
  }

  public Object visitVarDecl(VarDecl varDecl)
  {
	  getPercurso().append("VarDEcl\n");
	  String str = "";  

	  List<Name> decls = varDecl.getName();
	  int size = decls.size();
	  int counter = 0;
	  for(Name ndecl : decls) {

		  str = str + ((String[])ndecl.accept(namePrint()))[0];

		  if(counter < size-1) {
			  str = str + "; ";
		  }
		  counter++;
	  }
	  String[] result;
	  
	  if (varDecl.getExpr() != null){
		  String[] strExpr = ((String[])varDecl.getExpr().accept(exprPrint()));
		  result = new String[strExpr.length];
		  
		  result[0] = str + " : " + strExpr[0];
		  for (int i=1; i < strExpr.length;i++) {
			  result[i] = strExpr[i];
		  }
		  
	  }
	  else {
		  result = new String[1];
		  result[0] = str;
	  }
	  
	  
	  return result;
  }

  public Object visitConstDecl(ConstDecl constDecl)
  {
	  String[] result = null;
	  getPercurso().append("ConstDEcl\n");
	  
	 
	  String str = constDecl.getZName().getWord();
	  str = ((String[])constDecl.getName().accept(namePrint()))[0];
	  
	  if (str.startsWith(CircusUtils.DEFAULT_PROCESS_STATE_NAME)) {
		  str = "Default";
	  }
	  
	  str = str + this.Space + "==" + Space;
	  
	  this.addCounterRow(1); //ha quebra de linha com o  "==" 
	  int linhaInicial = this.getCounterRow();
	  String[] strExprs = (String [])constDecl.getExpr().accept(exprPrint());
	  
	  /* Para inserir um relacionamento num RefExpr */
	  if (constDecl.getExpr() instanceof RefExpr){
		  	NoPrograma noProg = new NoPrograma(constDecl.getExpr());
			int length = 1;
			Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

			addRelacionamento(rel);

			RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1)
			, constDecl.getExpr(), isToInsertingRelAnn());

			this.setCounterRow(length +  linhaInicial);
		  
	  }
	  
	  result = new String[strExprs.length + 1];
	  result[0] = str;
	  //Caso - AndPred igual a AndPred.NewLine
	  int index=1;
	  for (int i=0;i<strExprs.length;i++) {
		  result[index++] = BRANCO + strExprs[i];
	  }
	  return result;
  }

  public Object visitInclDecl(InclDecl inclDecl)
  {
	  
	  getPercurso().append("InclDEcl\n");
	  String[] str = ((String[])inclDecl.getExpr().accept(exprPrint()));
	  
	  boolean isfinished = false;
	  
	  if (!getUnicoded()) {
		  for (int i=0;i< str.length;i++) {
			  str[i] = str[i].replaceAll(ZString.DELTA, "\\\\Delta ");
			  str[i] = str[i].replaceAll(ZString.XI, "\\\\Xi ");
		  }
	  }
	  return str;
  }

  public Object visitQualifiedDecl(QualifiedDecl qualifiedDecl)
  {
	  String[] result = new String[1];
	  getPercurso().append("QualifiedDEcl\n");

	  ParamQualifier paramQ = qualifiedDecl.getParamQualifier();
	  String str = "";
	  
	  if(paramQ.equals(ParamQualifier.Value)) {
		  if (!getUnicoded())
			  str = "\\circval~ ";
		  else
			  str = CircusString.CIRCVAL + Space;
	  }
	  else if(paramQ.equals(ParamQualifier.Result)) {
		  if (!getUnicoded())
			  str = "\\circres~ ";
		  else
			  str = CircusString.CIRCRES + Space;
		  
	  }
	  else if(paramQ.equals(ParamQualifier.ValueResult)) {
		  if (!getUnicoded())
			  str = "\\circvres~ ";
		  else
			  str = CircusString.CIRCVAR + Space;
	  }

	  List<Name> decls = qualifiedDecl.getZNameList();
	  String strDecls = "";
	  int size = decls.size();
	  int counter = 0;
	  for(Name decl : decls) {
		  ZName name = (ZName)decl;
		  strDecls = strDecls + name.getWord();
		  if(counter < size-1) {
			  strDecls = strDecls + "; ";
		  }
		  counter++;
	  }
	  result[0] = str + strDecls;
	  
	  if (qualifiedDecl.getExpr() != null){
		  String strExpr = ((String[])qualifiedDecl.getExpr().accept(exprPrint()))[0];
		  result[0] = result[0] + Space + ZString.SEMICOLON + Space + strExpr;
	  }

	  
	  return result;
  }

}
