package circusRefine.core.print;


import java.util.Arrays;
import java.util.LinkedList;

import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.visitor.ZDeclListVisitor;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.zpatt.visitor.JokerDeclListVisitor;

public class DeclListPrint 
extends Print
implements ZDeclListVisitor,
JokerDeclListVisitor{

	public DeclListPrint(Printer printer) {
		super(printer);
	}

	public String[] visitZDeclList(ZDeclList decls) {
		
		getPercurso().append("ZDecList\n");
		int counter = 0;
		String [] strDecl;
		LinkedList<String> strDecls = new LinkedList<String>();
		
		int size = decls.size();
		
		for(Decl decl : decls) {
			String[] newDecl = (String[])decl.accept(declPrint());
			if (counter < size -1 ) {
				newDecl[newDecl.length-1] += "; ";
			}
			for (int j=0;j< newDecl.length;j++){
				strDecls.add(newDecl[j]);
			}
			counter++;
		}
		
		strDecl = new String[strDecls.size()];
		for (int k=0; k< strDecls.size();k++) {
			strDecl[k] = strDecls.get(k);
		}
		
		return strDecl;
	}

	public String[] visitJokerDeclList(JokerDeclList term) {
		getPercurso().append("JokerDeclList\n");
		String[] result = new String[1];
		result[0] = term.getName();
		return result;
	}

}
