/*
 * CommandPrint.java
 *
 * Created on 13 de Setembro de 2005, 16:14
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package circusRefine.core.print;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.z.ast.*;
import net.sourceforge.czt.circus.ast.*;
import net.sourceforge.czt.circus.visitor.*;
import circusRefine.core.*;
import circusRefine.core.relations.RelationsAnn;
import circusRefine.core.relations.RelationsUtils;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.ast.JokerDeclList;
import net.sourceforge.czt.circus.util.CircusString;

/**
 *
 * @author comp
 */
public class CommandPrint 
extends Print
implements CircusCommandVisitor,
AssignmentCommandVisitor,
SpecStmtCommandVisitor,
IfGuardedCommandVisitor,
VarDeclCommandVisitor
{

	/** Creates a new instance of CommandPrint */
	public CommandPrint(Printer printer) {
		super(printer);
	}
	public Object visitCircusCommand(CircusCommand term)
	{
		return term.accept(this);
	}

	public Object visitAssignmentCommand(AssignmentCommand assignCommand)
	{
		getPercurso().append("AssignCmd\n");
		String[] result = new String[1];
		int linhaInicial = this.getCounterRow();

		AssignmentPairs term = assignCommand.getAssignmentPairs();

		String strVars = ((String[])term.getLHS().accept(nameListPrint()))[0];

		String strExprs = ((String[])term.getRHS().accept(exprListPrint()))[0];

		result[0] = strVars + Space+ CircusString.CIRCASSIGN + Space + strExprs;

		//Relacionamentos

		NoPrograma noProg = new NoPrograma(assignCommand);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), assignCommand,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;

	}

	public Object visitSpecStmtCommand(SpecStmtCommand term)
	{
		String[] result;
		getPercurso().append("SpecStmtCmd\n");

		List<Name> frameVars = term.getZFrame();
		String strFrame = "";
		int size = frameVars.size();

		int counter = 0;
		for(Name name : frameVars) {
			String nombre = ((String[])name.accept(namePrint()))[0];
			if(counter < size-1) {
				strFrame = strFrame + nombre + ",";
			}
			else {
				strFrame = strFrame + nombre ;
			}
			counter++;
		}
		
		String[] strPreVetor = ((String[])term.getPre().accept(predPrint()));
		String[] strPosVetor = ((String[])term.getPost().accept(predPrint()));
		
		int sizefinal = strPreVetor.length + strPosVetor.length - 1;
		result = new String[sizefinal];
		int index=0;
		for (int i=0;i< strPreVetor.length ;i++) {
			result[index++] = strPreVetor[i];
		}
		index--;
		result[index] = result[index] + " , " + strPosVetor[0];
		index++;
		for (int i=1;i< strPosVetor.length ;i++) {
			result[index++] = strPosVetor[i];
		}
		
		if(size == 0) {
			result[0] = "[ " + result[0];
		}

		else {
			result[0] = strFrame + " : [" + result[0];
		}
		result[result.length-1] += " ]";

		return result;

	}

	public Object visitIfGuardedCommand(IfGuardedCommand term)
	{
		String[] result = null;
		String[] strTemp = null;
		getPercurso().append("IfGuardedCmd\n");
		int linhaInicial = this.getCounterRow();

		CircusActionList gActs = term.getGuardedActionList();
		int index = 0;

		for(CircusAction act1 : gActs) {
			GuardedAction act = (GuardedAction)act1;

			int linha_GA = this.getCounterRow();//Utilizado para guardar o relacionamento
			//de cada GuardedAction

			String[] strPred = (String[])act.getPred().accept(predPrint());
			this.addCounterRow(1);
			String[] strAct = (String[])act.getCircusAction().accept(actionPrint());
			String[] strGAct = new String[strPred.length + strAct.length];
			int j = 0;
			for(int i=0; i<strPred.length; i++) {
				strGAct[j++] = strPred[i];
			}
			j--;
			if (!getUnicoded())
				strGAct[j] = strGAct[j] + Space + "\\circthen"  + Space;
			else
				strGAct[j] = strGAct[j] + Space + CircusString.CIRCTHEN + Space;

			j++;
			for(int i=0; i<strAct.length; i++) {
				strGAct[j++] = BRANCO + strAct[i];
			}

			if (strTemp == null) {
				strTemp = new String[strGAct.length];
			}
			else {
				String[] strTempAux = new String[strTemp.length + strGAct.length];
				int idx = 0;
				for(int k=0; k<strTemp.length; k++) {
					strTempAux[idx++] = strTemp[k];
				}
				strTemp = strTempAux;
			}
			for(int i=0; i<strGAct.length; i++) {
				//Captura as Strings q ja foram inseridas nas outra itera��es

				//Verificar coloca��o entre circif ou else
				if(i == 0) {
					if(index == 0) {
						if (!getUnicoded())
							strTemp[index++] = "\\circif" + Space + strGAct[i];
						else
							strTemp[index++] = ZString.IF + Space + strGAct[i];
					}
					else {
						if (!getUnicoded()) 
							strTemp[index++] = "\\circelse" + Space + strGAct[i];
						else
							strTemp[index++] = CircusString.CIRCELSE + Space + strGAct[i];
					}
				}
				else {
					strTemp[index++] = "        " + strGAct[i];
				}
			}

			//Relacionamento da Guarded Action
			NoPrograma noProg = new NoPrograma(act);
			int length = strGAct.length;
			Relacionamento rel = new Relacionamento(linha_GA, linha_GA + length - 1, noProg);
			addRelacionamento(rel);
			RelationsUtils.insertRelation(new RelationsAnn(linha_GA, linha_GA + length -1), act,
					isToInsertingRelAnn());

			this.setCounterRow(length +  linha_GA);

		}
		result = new String[strTemp.length + 1];
		for (int i =0;i < strTemp.length; i++) {
			result[i] = strTemp[i];
		}
		if (!getUnicoded())
			result[index] = "\\circfi";
		else
			result[index] = CircusString.CIRCFI;

		//Relacionamento do ActionCommand
		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);
		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;
	}

	public Object visitVarDeclCommand(VarDeclCommand term)
	{
		String[] result = null;
		getPercurso().append("VarDeclCmd\n");

		int linhaInicial = this.getCounterRow();
		String strDecl = "";
		String strDeclAux = "";

		/**
		 * ZDECLLIST
		 */
		if (term.getDeclList() instanceof ZDeclList) {
			List<Decl> decls = term.getZDeclList();

			int size = decls.size();
			int counter = 0;
			for(Decl decl : decls) {
				strDecl = ((String[])decl.accept(declPrint()))[0];
				strDeclAux += strDecl;
				if(counter < size-1) {
					strDecl = strDecl + ZString.SEMICOLON;
					strDeclAux = strDecl + " ";
				}
				counter++;
			}
		}
		/**
		 * JOKERDECLLIST
		 */
		else {
			JokerDeclList decls = (JokerDeclList)term.getDeclList();
			strDecl = decls.getName();
		}
		/*
		 * Devido ao circvar .... 
		 */
		addCounterRow(1);

		String[] strAct = (String[])term.getCircusAction().accept(actionPrint());
		result = new String[strAct.length + 2];
		if (!getUnicoded()) {
			result[0] = "(\\circvar " + strDeclAux + " \\circspot ";
		}
		else {
			result[0] = "(" + CircusString.CIRCVAR  + Space + strDeclAux 
			+ Space + ZString.SPOT + Space;
		}
		int index = 1;
		for(int i=0; i<strAct.length; i++) {
			result[index++] = BRANCO + strAct[i];
		}
		result[index] = ")";

		NoPrograma noProg = new NoPrograma(term);
		int length = result.length;
		Relacionamento rel = new Relacionamento(linhaInicial, linhaInicial + length - 1, noProg);

		addRelacionamento(rel);

		RelationsUtils.insertRelation(new RelationsAnn(linhaInicial, linhaInicial + length -1), term,
				isToInsertingRelAnn());

		this.setCounterRow(length +  linhaInicial);

		return result;
	}



}
