/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.setoperators;

import java.util.HashSet;

import circusRefine.core.opsdischarge.syntacticfunctions.CannotEvaluateException;

import net.sourceforge.czt.z.ast.Expr;

/**
 * Aplica o operador interseo
 * 
 * @author Cristiano Castro
 */
public class CapApplier extends OperadorBinarioConjuntos<Expr> {

	/**
	 * Aplica o operador interseo.
	 * 
	 * @param c1 o primeiro parmetro
	 * @param c2 o segundo parmetro
	 * @return a interseo dos dois conjuntos
	 */
	public Expr apply(Expr c1, Expr c2) throws CannotEvaluateException {
		HashSet<Expr> conj1 = CapApplier.transformarRepresentacao(c1);
		HashSet<Expr> conj2 = CapApplier.transformarRepresentacao(c2);
		conj1.retainAll(conj2);
		return CapApplier.tranformarRepresentacao(conj1);
	}

}
