/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge.expressionOperators;

import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.TupleExpr;

/**
 * Aplicador da funo igual
 * 
 * @author Cristiano Castro
 */
public class EqualApplier {

	/**
	 * Visita uma operao de igualdade
	 * 
	 * @param a tupla com os argumentos da igualdade
	 * @return <code>true</code> se e1.equals(e2) for verdadeiro
	 */
	public boolean apply(TupleExpr tupla) {
		Expr e1 = tupla.getZExprList().get(0);
		Expr e2 = ((SetExpr)tupla.getZExprList().get(1)).getZExprList().get(0);
		return e1.equals(e2);
	}
	
}
