/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.opsdischarge;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.util.UnsupportedAstClassException;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.DecorExpr;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.ZExprList;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.visitor.ApplExprVisitor;
import net.sourceforge.czt.z.visitor.DecorExprVisitor;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import circusRefine.core.astmodifiers.ActionArgumentAnn;
import circusRefine.core.astmodifiers.CommunicationArgumentAnn;
import circusRefine.core.astmodifiers.ProcessArgumentAnn;
import circusRefine.core.crules.utils.NormalizationApplicationException;
import circusRefine.core.crules.utils.NormalizeApplier;
import circusRefine.core.opsdischarge.setoperators.CapApplier;
import circusRefine.core.opsdischarge.setoperators.CupApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.AlphaApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.CannotEvaluateException;
import circusRefine.core.opsdischarge.syntacticfunctions.DashedFreeVariablesApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.FreeVariablesApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.FreeVariablesProcessApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.InitialsApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.InputVarsApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.UsedChannelsApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.UsedVariablesApplier;
import circusRefine.core.opsdischarge.syntacticfunctions.WrittenVariablesApplier;
import circusRefine.core.print.Printer;

/**
 * Aplicador de fun��es sint�ticas. Pega as express�es de obriga��es 
 * de prova e aplica as fun��es 
 * 
 * @author Cristiano Castro
 *
 */
public class SyntacticFunctionsApplier implements TermVisitor<Term>, 
ApplExprVisitor<Term>, RefExprVisitor<Term>, DecorExprVisitor<Term> {

	/** F�brica de termos */
	CircusPatternFactory factory = new CircusPatternFactoryImpl();
	
	/**
	 * M�todo que aplica as fun��es sint�ticas caso seja poss�vel
	 * 
	 * @param termosExpandidos o conjunto de termos expandidos no 
	 *  passo anterior da
	 * @param aExpandir o termo que pode conter as fun��es sint�ticas
	 *  a expandir
	 * @return o termo expandido
	 */
	public static Term aplicarFuncoesSintaticas(Set<String> termosExpandidos, 
			Term aExpandir) throws CannotExpandException {
		try {
			SyntacticFunctionsApplier visitor = 
				new SyntacticFunctionsApplier(termosExpandidos);
			return aExpandir.accept(visitor);
		} catch (CannotExpandRuntimeException e) {
			//e.printStackTrace();
			throw new CannotExpandException(e);
		}
	}

	/** O conjunto de nomes expandidos com a expans�o da OP */
	private Set<String> termosExpandidos;

	/**
	 * Inicia a classe informando quais foram os nomes expandidos
	 * pelo passo anterior da resolu��o de OPs
	 * 
	 * @param termosExpandidos os termos expandidos na OP anterior
	 */
	public SyntacticFunctionsApplier(Set<String> termosExpandidos) {
		this.setTermosExpandidos(termosExpandidos);
	}

	/**
	 * @return the termosExpandidos
	 */
	private Set<String> getTermosExpandidos() {
		return termosExpandidos;
	}

	/**
	 * @param termosExpandidos the termosExpandidos to set
	 */
	private void setTermosExpandidos(Set<String> termosExpandidos) {
		this.termosExpandidos = termosExpandidos;
	}

	/**
	 * N�o faz nenhuma tarefa especial ao expandir um termo comum.
	 * 
	 * @param arg0 o termo a ser visitado
	 * @return uma c�pia do termo com as express�es avaliadas
	 */
	public Term visitTerm(Term arg0) {
		/* Retorna uma c�pia do termo com as express�es avaliadas */
		return VisitorUtils.visitTerm(this, arg0, false);
	}
	
	/**
	 * Testa se o termo cont�m uma anota��o de argumento de a��o
	 * 
	 * @param arg0 o refExpr a ser visitado
	 */
	public Term visitRefExpr(RefExpr arg0) {
		Term result;
		ActionArgumentAnn ann = arg0.getAnn(ActionArgumentAnn.class);
		if (ann == null) {
			result = VisitorUtils.visitTerm(this, arg0, false);
		} else {
			
			RefExpr novo = factory.createRefExpr();
			CircusAction acao = 
				VisitorUtils.visitTerm(this, ann.getTerm(), false);
			ActionArgumentAnn novaAnn = new ActionArgumentAnn(acao);
			result = novo;
			result.getAnns().add(novaAnn);
		}
		
		return result;
	}
	
	/**
	 * Visita um express�o decorada. Tenta normalizar a express�o
	 */
	public Term visitDecorExpr(DecorExpr arg0) {

			
			/* Avalia a express�o interior � express�o decorada */
			Expr argumento = (Expr) arg0.getExpr().accept(this);
			DecorExpr nova = this.factory.createDecorExpr(argumento, 
					arg0.getStroke());
			
			/* Tenta normalizar a express�o */
			SchExpr expr;
			try {
				expr = NormalizeApplier.getInstance().applyRewrite(nova);
			} catch (NormalizationApplicationException e) {
				throw new CannotExpandRuntimeException(e);
				
			}
			return expr;
		
		
	}
	
	/**
	 * Visita uma aplica��o de fun��o, caso esta seja uma fun��o 
	 * sint�tica aplic�vel
	 * 
	 * @param arg0 o argumento da aplica��o de fun��o
	 * @return o termo com a aplica��o de fun��o avaliada se poss�vel,
	 *  ou uma c�pia do mesmo caso n�o seja poss�vel avaliar
	 */
	public Term visitApplExpr(ApplExpr arg0) {
		Term result;
		Expr funcao = arg0.getLeftExpr();

		
		try {
			if (funcao instanceof RefExpr) {
				RefExpr defFuncao = (RefExpr) funcao;

				/* V� se a defini��o � conhecida */
				String stringDefFuncao = 
					OPsDischargeUtils.getNomeReal(defFuncao.getZName());
				if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.FV_Expr))) {

					/* Fun��o FV_Expr: chama o FreeVariables aplier */
					FreeVariablesApplier applier = 
						new FreeVariablesApplier(this.getTermosExpandidos());
					Term argAvaliado = arg0.getRightExpr().accept(this);
					result = applier.apply((Expr) argAvaliado);
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.DFV_Expr))) {

					/* Fun��o DFV_Expr: chama do DashedFreeVariablesAplier */
					DashedFreeVariablesApplier applier = 
						new DashedFreeVariablesApplier(
								this.getTermosExpandidos());
					Term argAvaliado = arg0.getRightExpr().accept(this);
					result = applier.apply((Expr) argAvaliado);
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.UDFV_Expr))) {

					/* Fun��o UDFV: chama UndashedFreeVariablesAplier */
					DashedFreeVariablesApplier applier = 
						new DashedFreeVariablesApplier(
								this.getTermosExpandidos());
					Term argAvaliado = arg0.getRightExpr().accept(this);
					result = applier.apply((Expr) argAvaliado);
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
						OPsDischargeUtils.ALPHA))) {

					/* Fun��o \alpha: chama do AlphaApplier */
					AlphaApplier applier = new AlphaApplier();
					Term argAvaliado = arg0.getRightExpr().accept(this);
					
					result = applier.apply((SchExpr) argAvaliado);
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.USED_C))) {

					/* Fun��o usedC: chama do UsedChannelsApplier */
					UsedChannelsApplier applier = new UsedChannelsApplier();
					Term argAvaliado = arg0.getRightExpr().accept(this);
					ActionArgumentAnn ann = 
						argAvaliado.getAnn(ActionArgumentAnn.class);
					result = applier.apply((CircusAction) ann.getTerm()); 
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.INITIALS))) {
					
					/* Fun��o initials: chama do InitialsAplier */
					InitialsApplier applier = new InitialsApplier();
					Term argAvaliado = arg0.getRightExpr().accept(this);
					ActionArgumentAnn ann = 
						argAvaliado.getAnn(ActionArgumentAnn.class);
					result = applier.apply((CircusAction) ann.getTerm()); 
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.INPUT_VARS))) {
					/* Fun��o inputVars: chamada do InputVarsApplier */
					InputVarsApplier applier = new InputVarsApplier();
					Term argAvaliado = arg0.getRightExpr().accept(this);
					CommunicationArgumentAnn ann = 
						argAvaliado.getAnn(CommunicationArgumentAnn.class);
					
					ListTerm<ZName> res = applier.apply(ann.getTerm());
					List<Expr> aPassar = new LinkedList<Expr>();
					for (ZName a : res) {
						RefExpr novo = factory.createRefExpr(a, null, false, false);
						aPassar.add(novo);
					}
					result = factory.createSetExpr(factory.createZExprList(aPassar));
					//result = applier.apply(ann.getTerm());
					
					
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.FV_Action))) {
					
					/* Fun��o usedV: chamada do UsedVariablesApplier */
					UsedVariablesApplier applier = 
						new UsedVariablesApplier(this.getTermosExpandidos());
					Term argAvaliado = arg0.getRightExpr().accept(this);
					ActionArgumentAnn ann = 
						argAvaliado.getAnn(ActionArgumentAnn.class);
					result = applier.apply(ann.getTerm());
					
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.WRT_V))) {
					
					/* Fun��o usedV: chamada do UsedVariablesApplier */
					WrittenVariablesApplier applier = 
						new WrittenVariablesApplier(this.getTermosExpandidos());
					Term argAvaliado = arg0.getRightExpr().accept(this);
					ActionArgumentAnn ann = 
						argAvaliado.getAnn(ActionArgumentAnn.class);
					result = applier.apply(ann.getTerm());
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
						OPsDischargeUtils.CUP))) {
					
					/* Fun��o usedV: chamada do UsedVariablesApplier */
					CupApplier applier = new CupApplier();
					TupleExpr argAvaliado = 
						(TupleExpr) arg0.getRightExpr().accept(this);
					result = applier.apply(argAvaliado);
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
						OPsDischargeUtils.CAP))) {
					
					/* Fun��o usedV: chamada do UsedVariablesApplier */
					CapApplier applier = new CapApplier();
					TupleExpr argAvaliado = 
						(TupleExpr) arg0.getRightExpr().accept(this);
					result = applier.apply(argAvaliado);
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
								OPsDischargeUtils.USED_V))) {
					
					/* Fun��o usedV: chamada do UsedVariablesApplier */
					UsedVariablesApplier applier = 
						new UsedVariablesApplier(this.getTermosExpandidos());
					Term argAvaliado = arg0.getRightExpr().accept(this);
					ActionArgumentAnn ann = 
						argAvaliado.getAnn(ActionArgumentAnn.class);
					result = applier.apply(ann.getTerm());
				} else if (stringDefFuncao.equals(OPsDischargeUtils.getNomeReal(
						OPsDischargeUtils.FV_Process))) {

					/* Fun��o FV_p: chamada do Free Variables Applier */
					FreeVariablesProcessApplier applier = 
						new FreeVariablesProcessApplier();
					Term argAvaliado = arg0.getRightExpr().accept(this);
					ProcessArgumentAnn ann = 
						argAvaliado.getAnn(ProcessArgumentAnn.class);
					result = applier.apply(ann.getTerm());
				} else {
					
					/* A fun��o n�o � trat�vel */
					result = VisitorUtils.visitTerm(this, arg0, false);
				} 

			} else {

				/* Fun��o n�o � uma refer�ncia conhecida */
				result = VisitorUtils.visitTerm(this, arg0, false);
			}
		} catch (UnsupportedAstClassException e) {
			e.printStackTrace();
			/* Erro na aplica��o da lei */
			throw new CannotExpandRuntimeException(e);
		} catch (ClassCastException e) {
			e.printStackTrace();
			throw new CannotExpandRuntimeException(e);
		} catch (CannotEvaluateException e) {
			e.printStackTrace();
			/* N�o pode avaliar a fun��o */
			throw new CannotExpandRuntimeException(e);
		} catch (NullPointerException e) {
			e.printStackTrace();
			throw new CannotExpandRuntimeException(e);
		}
		return result;
	}

}
