package circusRefine.core.finder;

import java.util.Arrays;
import java.util.LinkedList;

import circusRefine.core.InternalManager;
import circusRefine.core.print.Printer;
import circusRefine.core.util.ClonerVisitor;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.z.ast.And;
import net.sourceforge.czt.z.ast.AndExpr;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.ZDeclList;
import net.sourceforge.czt.z.ast.ZSchText;
import net.sourceforge.czt.z.visitor.AndExprVisitor;
import net.sourceforge.czt.z.visitor.ConstDeclVisitor;
import net.sourceforge.czt.z.visitor.RefExprVisitor;
import net.sourceforge.czt.z.visitor.SchExprVisitor;

/**
 * Classe utilizada para encontrar a definição de um schema a partir de seu nome.
 * Caso esse esquema seja formado por uma conjunção dos schemas, eles são procurados tb. 
 * @author alessandro87
 *
 */
public class SchemaFinder implements TermVisitor<Void>, 
ConstDeclVisitor<Void>,
SchExprVisitor<Void>,
AndExprVisitor<Void>,
RefExprVisitor<Void>{

	private LinkedList<SchExpr> composicoesSchema;
	private LinkedList<String> names;
	private Term ast;
	private SchExpr schema;
	private boolean searching;

	public SchemaFinder(String nome, Term ast) {

		this.names = new LinkedList<String>();
		names.add(nome);

		this.composicoesSchema = new LinkedList<SchExpr>();
		this.ast = ast;
		this.searching = false;
	}

	public Void visitTerm(Term termo) {
			VisitorUtils.visitTerm(this, termo);
		return null;
	}


	public Void visitConstDecl(ConstDecl termo) {

		if (names.contains(termo.getZName().getWord())){
			if (termo.getExpr() instanceof SchExpr ||
					termo.getExpr() instanceof AndExpr ||
					termo.getExpr() instanceof RefExpr) {
				names.remove(termo.getZName().getWord());
				searching = true;
				termo.getExpr().accept(this);
				searching = false;
			}
		}
		return null;
	}

	private SchExpr comporSolucao() {

		if (composicoesSchema.size() == 1){
			return composicoesSchema.getFirst();
		}
		else if (composicoesSchema.size() == 0) {
			return null;
		}

		CircusPatternFactoryImpl factory = new CircusPatternFactoryImpl();
		ZSchText zSchText = (ZSchText) ClonerVisitor.cloneTerm(composicoesSchema.getFirst().getSchText());
		ZDeclList decls = zSchText.getZDeclList();
		Pred pred = zSchText.getPred();

		for (int i=1; i< composicoesSchema.size();i++){
			decls.addAll(composicoesSchema.get(i).getZSchText().getZDeclList());
			pred = factory.createAndPred(Arrays.asList(pred, composicoesSchema.get(i).getZSchText().getPred()),
					And.Wedge);
		}

		return factory.createSchExpr(factory.createZSchText(decls, pred));
	}

	public static SchExpr getSchema (String nome, Term ast) {
		SchemaFinder finder = new SchemaFinder(nome,ast);
		ast.accept(finder);
		
		return finder.comporSolucao();
	}

	public static boolean hasSchema (String nome, Term ast) {
		boolean result = false;

		Term a = SchemaFinder.getSchema(nome, ast);

		if (a!= null)
			result = true;

		return result;
	}

	public static SchExpr getSchema(String word, InternalManager interno) {

		Term ast = interno.retornarProgAtual();
		SchemaFinder finder = new SchemaFinder(word, ast);
		ast.accept(finder);
		SchExpr result = finder.comporSolucao();
		
		if (result == null) {
			boolean toQuit = false;
			int selectedDevelopment = interno.getSelectedDevelopment();
			while (result == null && !toQuit){
				if (interno.isSubDevelopment(selectedDevelopment)){
					int pai  = interno.getPai(selectedDevelopment);
					int indiceOp = interno.getIndiceOP(selectedDevelopment);
					Term contexto = interno.getContextoAt(pai,indiceOp);
					contexto.accept(finder);
					result = finder.comporSolucao();
					selectedDevelopment = pai;
				}
				else{
					toQuit = true;
				}
			}
		}
		/* Procurar no outro Contextos*/
		if (result == null){
			boolean toQuit = false;
			int selectedDevelopment = interno.getSelectedDevelopment();
			while (result == null && !toQuit){
				if (interno.isSubDevelopment(selectedDevelopment)){
					int pai  = interno.getPai(selectedDevelopment);
					int indiceOp = interno.getIndiceOP(selectedDevelopment);
					Term contexto = interno.getContextoAposAt(pai,indiceOp);
					contexto.accept(finder);
					result = finder.comporSolucao();
					selectedDevelopment = pai;
				}
				else{
					toQuit = true;
				}
			}
		}



		return result;
	}

	public Void visitSchExpr(SchExpr termo) {
		if (searching){
			composicoesSchema.add(termo);
		}
		return null;
	}

	public Void visitAndExpr(AndExpr termo) {

		if (searching) {
			termo.getRightExpr().accept(this);
			termo.getLeftExpr().accept(this);
			
		}
		return null;
	}

	public Void visitRefExpr(RefExpr termo) {

		if (searching) {
			String name = termo.getZName().getWord();
			names.add(name);
			searching = false;
			ast.accept(this);
			searching = true;
		}
		return null;
	}
}
