/*
 * Projeto: Circus Refine
 * Autor: Cristiano Gurgel
 */
package circusRefine.core.crules.utils;

import java.util.Arrays;
import java.util.List;

import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.visitor.ActionParaVisitor;
import net.sourceforge.czt.circus.visitor.BasicProcessVisitor;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZParaList;
import net.sourceforge.czt.z.visitor.AxParaVisitor;
import net.sourceforge.czt.z.visitor.ConstDeclVisitor;
import circusRefine.core.InternalManager;
import circusRefine.core.print.Printer;
import circusRefine.core.util.ChildrenTermExtractor;

/**
 * Captura um nome a partir da defini��o de uma Expressao
 * 
 * @author CristianoGurgel
 * @author Alessandro Gurgel
 */
public class NameFromAnActionGetter implements BasicProcessVisitor<ZName>,
	TermVisitor<ZName>, AxParaVisitor<ZName>, 
	ActionParaVisitor<ZName>, ConstDeclVisitor<ZName> {

	/**
	 * Procura por um nome dado a defini��o.
	 * 
	 * @param action a a��o cuja defini��o ser� pesquisada
	 * @param ast a ast na qual a nome a a��o ser� pesquisada
	 */
	public static ZName findName(CircusAction action, Term ast) {
		
		NameFromAnActionGetter visitor = new NameFromAnActionGetter(action);
		return ast.accept(visitor);
	}
	
	
	public static ZName search(CircusAction action, Term ast, InternalManager gerInterno) {
		ZName result = null;
		result = findName(action,ast);
		/*
		 * Nesse caso a definicao de termo pode estar no desenvolvimenot pai
		 */
		if (result == null) {
			boolean toQuit = false;
			int selectedDevelopment = gerInterno.getSelectedDevelopment();
			while (result == null && !toQuit){
				if (gerInterno.isSubDevelopment(selectedDevelopment)){
					int pai  = gerInterno.getPai(selectedDevelopment);
					int indiceOp = gerInterno.getIndiceOP(selectedDevelopment);
					Term contexto = gerInterno.getContextoAt(pai,indiceOp);
					result = findName(action, contexto);
					selectedDevelopment = pai;
				}
				else{
					toQuit = true;
				}
			}
		}
		
		if (result == null){
			boolean toQuit = false;
			int selectedDevelopment = gerInterno.getSelectedDevelopment();
			while (result == null && !toQuit){
				if (gerInterno.isSubDevelopment(selectedDevelopment)){
					int pai  = gerInterno.getPai(selectedDevelopment);
					int indiceOp = gerInterno.getIndiceOP(selectedDevelopment);
					Term contexto = gerInterno.getContextoAposAt(pai,indiceOp);
					result = findName(action, contexto);
					selectedDevelopment = pai;
				}
				else{
					toQuit = true;
				}
			}
		}
		
		
		return result;
		
	}
	
	/** A��o de Circus a ser pesquisada */
	private CircusAction acao;

	/**
	 * Construtor recebe a a��o a ser pesquisada.
	 * 
	 * @param novaAcao a a��o de circus a ser pesquisada na �rvore
	 */
	public NameFromAnActionGetter(CircusAction novaAcao) {
		this.setAction(novaAcao);
	}

	private CircusAction getAcao() {
		return acao;
	}

	private void setAction(CircusAction novaAcao) {
		this.acao = novaAcao;
	}

	/**
	 * Visita um termo irrelevante, procura a lista de par�grafos
	 *  do processo
	 * 
	 * @param o termo a ser visitado
	 * @return o nome do esquema ser for encontrado, ou 
	 *  <code>null</code>, caso contr�rio.
	 */
	public ZName visitTerm(Term arg0) {
		List<Term> filhos = ChildrenTermExtractor.extrairFilhos(arg0);

		for (Term filho : filhos) {
			ZName nome = filho.accept(this);
			if (nome != null) {
				return nome;
			}
		}
		return null;
	}

	/**
	 * Busca a defini��o do esquema na lista de par�grafo do 
	 * processo
	 * 
	 * @param arg0 o {@link BasicProcess} a ser visitado
	 * @return o nome do esquema se for encontrado, ou 
	 * 	<code>null</code> caso contr�rio
	 */
	public ZName visitBasicProcess(BasicProcess arg0) {
		return arg0.getParaList().accept(this);
	}

	/**
	 * Procura pela defini��o da a��o na ZParaList de um BasicProcess.
	 * 
	 * @param arg0 a lista de par�grafos a ser visitada
	 * @return o nome da a��o se for encontrada na lista de par�grafos
	 *  ou <code>null</code>, caso contr�rio.
	 */
	public ZName visitZParaList(ZParaList arg0) {
		
		/* Procura o nome na lista de par�grafos  */
		for (Para para : arg0) {
			ZName result = para.accept(this);
			
			/* Achou!!! */
			if (result != null) {
				return result;
			}
		}
		
		/* N�o encontrou */
		return null;
	}

	/** 
	 * Testa se a defini��o da a��o � a mesma e retorna o nome se a
	 * a��o for encontrada
	 * 
	 * @param arg0 o par�grafo de a��o a ser visitado
	 * @return o nome do par�grafo se a��o definida � a mesma, ou
	 *  <code>null</code> caso contr�rio.
	 */
	public ZName visitActionPara(ActionPara arg0) {
		
		String str1 = Printer.printLATTEX(arg0.getCircusAction());
		String str2 = Printer.printLATTEX(getAcao());
		
		/* Testa se achou a a��o */
		if (arg0.getCircusAction().equals(this.getAcao())) {
			return arg0.getZName(); /* Achou */
		}
		else if (str1.equals(str2)){
			return arg0.getZName();
		}
		else {
			return null; 			/* N�o achou */
		}
	}

	/**
	 * Visita uma defini��o axiom�tica. Se a a��o refenciar um
	 * esquema definido no {@link AxPara} ent�o 
	 */
	public ZName visitAxPara(AxPara arg0) {
		
		if (this.getAcao() instanceof SchExprAction) {
			
			/* Procura na lista de declara��es do SchText */
			for(Decl decl : arg0.getZSchText().getZDeclList()) {
				ZName result = decl.accept(this);
				
				/* Achou !!! */
				if (result != null) {
					return result;
				}
			}
			
		}

		/* N�o achou */
		return null;
	}

	/**
	 * Visita a declara��o para buscar o nome associado � uma defini��o.
	 * 
	 * @param decl declara��o a ser pesquisada
	 * @return o nome caso a defini��o seja encontrada ou 
	 *  <code>null</code> caso contr�rio.
	 */
	public ZName visitConstDecl(ConstDecl decl) {
		ZName result = null;

		/* 
		 * S� necessita visitar uma declara��o constante se, e somente
		 * se, a a��o for um schema 
		 */
		if (this.getAcao() instanceof SchExprAction) {
			SchExprAction aPesquisar = (SchExprAction) this.getAcao();
			Expr aTestar = decl.getExpr();
			Expr molde = aPesquisar.getExpr();
			List<String> vetor1 = 
				Arrays.asList(Printer.print(aTestar, Markup.LATEX,false));
			List<String> vetor2 = 
				Arrays.asList(Printer.print(molde, Markup.LATEX,false));
			if (aTestar.equals(molde)) {
				
				/* Compara��o normal */
				result = decl.getZName();
			} else if (vetor1.equals(vetor2)) {
				
				/* Compara��o pelas Strings geradas */
				result = decl.getZName();
			} 
		}
		
		/* Retorna o resultado da pesquisa */
		return result;
	}

}
