package circusRefine.core.crules.utils;

import circusRefine.core.crules.factories.LawType;
import net.sourceforge.czt.circuspatt.util.CircusLaw;

/**
 * Classe utilizada para adicionar o tipo de lei como anotacao
 * a uma lei.
 * @author alessandro87
 *
 */
public class LawTypeAnnUtils {

	public static void insertAnnLawType (CircusLaw lei, LawType tipo){
		lei.getAnns().add(tipo);
	}
	public static LawType getAnnLawType(CircusLaw lei) {
		for (Object obj : lei.getAnns()) {
			if (obj instanceof LawType) {
				return (LawType)obj;
			}
		}
		return null;
	}
	
}
