/*
 * Projeto: Circus Refine
 */
package circusRefine.core.crules.utils;

import circusRefine.core.InternalManager;
import circusRefine.core.print.Printer;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.base.visitor.VisitorUtils;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.CircusNameSet;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circuspatt.ast.CircusPatternFactory;
import net.sourceforge.czt.circuspatt.impl.CircusPatternFactoryImpl;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.ast.ZName;
import net.sourceforge.czt.z.ast.ZStrokeList;

/**
 * Retorna a defini��o de um nome a partir da busca na AST
 * 
 * @author Cristiano Castro
 */
public abstract class DefinitionFromATermGetter implements 
TermVisitor<Void> {


	/**
	 * Procura pela defini��o de um nome a partir de uma AST.
	 * 
	 * @param nome o nome a ser pesquisado
	 * @param classeNome a classe do nome definido
	 * @param ast a AST na qual ser� efetuada a busca
	 * @param gerInterno Gerenciador Interno, utilizado para pegar possiveis
	 * contextos caso a busca na ast atual nao seja bem sucedida
	 * @return
	 */
	public static Term find(ZName nome, Term classeNome, Term ast, InternalManager gerInterno){
		Term result = null;
		result = find(nome, classeNome, ast);
		/*
		 * Nesse caso a definicao de termo pode estar no desenvolvimenot pai
		 */
		if (result == null) {
			boolean toQuit = false;
			int selectedDevelopment = gerInterno.getSelectedDevelopment();
			while (result == null && !toQuit){
				if (gerInterno.isSubDevelopment(selectedDevelopment)){
					int pai  = gerInterno.getPai(selectedDevelopment);
					int indiceOp = gerInterno.getIndiceOP(selectedDevelopment);
					Term contexto = gerInterno.getContextoAt(pai,indiceOp);
					result = find(nome, classeNome, contexto);
					selectedDevelopment = pai;
				}
				else{
					toQuit = true;
				}
			}
		}
		/* Procurar no outro Contextos*/
		if (result == null){
			boolean toQuit = false;
			int selectedDevelopment = gerInterno.getSelectedDevelopment();
			while (result == null && !toQuit){
				if (gerInterno.isSubDevelopment(selectedDevelopment)){
					int pai  = gerInterno.getPai(selectedDevelopment);
					int indiceOp = gerInterno.getIndiceOP(selectedDevelopment);
					Term contexto = gerInterno.getContextoAposAt(pai,indiceOp);
					result = find(nome, classeNome, contexto);
					selectedDevelopment = pai;
				}
				else{
					toQuit = true;
				}
			}
		}
		
		return result;
	}


	/**
	 * Procura pela defini��o de um nome a partir de uma AST.
	 * 
	 * @param nome o nome a ser pesquisado
	 * @param classeNome a classe do nome definido
	 * @param ast a AST na qual ser� efetuada a busca
	 * @return
	 */
	private static Term find(ZName nome, Term classeNome, Term ast) {

		DefinitionFromATermGetter visitor;
		Term result;

		/* Testa qual visitor */
		if (classeNome instanceof ChannelSet) {
			visitor = new ChannelSetFromATermGetter(nome, classeNome);
		} else if (classeNome instanceof CallAction) {
			visitor = new ActionFromANameGetter(nome, classeNome);
		} else if (classeNome instanceof CircusNameSet) {
			visitor = new NameSetFromATermGetter(nome, classeNome);
		} else if (classeNome instanceof CircusProcess) {
			visitor = new ProcessOfANameGetter(nome, classeNome);
		} else {
			visitor = new ExpressionFromATermGetter(nome, classeNome);
		}

		try {
			ast.accept(visitor);
			result = visitor.getDefinition();

			/* Teste dos strokes de result */
			if (result instanceof Expr) {

				/* 
				 * Substitui a RefExpr pela a��o da defini��o na �rvore 
				 * result 
				 */
				RefExpr nomeOriginal = (RefExpr)classeNome;
				Expr definicaoOriginal = (Expr)result;

				/* */
				ZStrokeList strokeList = 
					nomeOriginal.getZName().getZStrokeList();

				if (strokeList.size() != 0) {
					for (Stroke stk : strokeList) {
						CircusPatternFactory ftr = 
							new CircusPatternFactoryImpl();
						definicaoOriginal = 
							ftr.createDecorExpr(definicaoOriginal, stk);
					}
				}

				result = definicaoOriginal;
			}

		} catch (NotFoundException e) {
			/* Defini��o n�o foi encontrada */
			result = classeNome;
		} catch (Exception e) {

			/* Uma outra excess�o qualquer aconteceu */
			result = classeNome;
		}

		return result;
	}

	private Term tipoNome;

	/** Nome da defini��o a ser pesquisada */
	private ZName nomeAPesquisar;

	/** Defini��o encontrada pelo nome */
	private Term definition;

	/**
	 * Construtor padr�o. Inicia o objeto informando o nome a ser
	 * pesquisado.
	 * 
	 * @param nome o nome cuja defini��o deve ser pesquisada
	 */
	public DefinitionFromATermGetter(ZName nome, Term tipoNome) {
		this.setNomeAPesquisar(nome);
		this.setTipoNome(tipoNome);
		this.setDefinition(null);
	}

	/**
	 * @return the nomeAPesquisar
	 */
	protected ZName getNomeAPesquisar() {
		return nomeAPesquisar;
	}

	/**
	 * @param nomeAPesquisar the nomeAPesquisar to set
	 */
	protected void setNomeAPesquisar(ZName nomeAPesquisar) {
		this.nomeAPesquisar = nomeAPesquisar;
	}

	/**
	 * @return the tipoNome
	 */
	protected Term getTipoNome() {
		return tipoNome;
	}

	/**
	 * @param tipoNome the tipoNome to set
	 */
	protected void setTipoNome(Term tipoNome) {
		this.tipoNome = tipoNome;
	}

	/**
	 * @return the definition
	 */
	protected Term getDefinition() {
		return definition;
	}

	/**
	 * @param definition the definition to set
	 */
	protected void setDefinition(Term definition) {
		this.definition = definition;
	}

	/**
	 * 
	 */
	public Void visitTerm(Term arg0) {
		VisitorUtils.visitTerm(this, arg0);
		return null;
	}

	/**
	 * Excess�o utilizada para avisar que a busca foi cancelada
	 * 
	 * @author Cristiano Castro
	 */
	protected class CancelSearchException extends RuntimeException {

		private static final long serialVersionUID = 5427429762846984267L;

		/**
		 * 
		 */
		public CancelSearchException() {
			super();
		}

		/**
		 * @param message
		 * @param cause
		 */
		public CancelSearchException(String message, Throwable cause) {
			super(message, cause);
		}

		/**
		 * @param message
		 */
		public CancelSearchException(String message) {
			super(message);
		}

		/**
		 * @param cause
		 */
		public CancelSearchException(Throwable cause) {
			super(cause);
		}



	}

	/**
	 * Excess�o utilizada para indicar que o termo n�o foi encontrado
	 */
	protected class NotFoundException extends RuntimeException {

		private static final long serialVersionUID = 2511016422022315460L;

		/**
		 * 
		 */
		public NotFoundException() {
			super();
		}

		/**
		 * @param message
		 * @param cause
		 */
		public NotFoundException(String message, Throwable cause) {
			super(message, cause);
		}

		/**
		 * @param message
		 */
		public NotFoundException(String message) {
			super(message);
		}

		/**
		 * @param cause
		 */
		public NotFoundException(Throwable cause) {
			super(cause);
		}

	}

}
