package circusRefine.core.crules.utils;

import java.util.Hashtable;
import java.util.List;

import net.sourceforge.czt.circuspatt.util.CircusLaw;
import circusRefine.core.InternalManager;
import circusRefine.core.crules.factories.LawType;
import circusRefine.core.crules.factories.LawsFactory;
import circusRefine.util.Internacional;

/**
 * Codigo que contem uma tabela com os enumerations e 
 * os codigos respectivos.
 * @author alessandro87
 *
 */
public class CodNameLaws extends LawsFactory{

	private Hashtable<LawType, String> table;
	
	public CodNameLaws(Internacional inter, InternalManager gerInt) {
		super(inter,gerInt);
		inicializar();
	}

	private void inicializar() {
		
		table = new Hashtable<LawType, String>();
		/*Adicionando elementos a HashTables*/
		table.put(LawType.ACTION_REFINEMENT_,actionRefinementType );
		table.put(LawType.ACTION_REFINEMENT_ALTERNATION,alternationRefinementType);
		table.put(LawType.ACTION_REFINEMENT_ASSUMPTION,assumptionRefinementType);
		table.put(LawType.ACTION_REFINEMENT_CHAOS, chaosRefinementType);
		table.put(LawType.ACTION_REFINEMENT_EXTERNAL_CHOICE, externalChoiceRefinementType);
		table.put(LawType.ACTION_REFINEMENT_GUARDS, guardsRefinementType);
		table.put(LawType.ACTION_REFINEMENT_HIDING, hidingRefinementType);
		table.put(LawType.ACTION_REFINEMENT_INTERLEAVING, interleavingRefinementType);
		table.put(LawType.ACTION_REFINEMENT_INTERNAL_CHOICE,internalChoiceRefinementType);
		table.put(LawType.ACTION_REFINEMENT_PARALLELISM_COMPOSITION, parallelismRefinementType);
		table.put(LawType.ACTION_REFINEMENT_PREFIX, prefixRefinementType);
		table.put(LawType.PROCESS_REFINEMENT, processRefinementType);
		table.put(LawType.ACTION_REFINEMENT_RECURSION, recursionRefinementType);
		table.put(LawType.ACTION_REFINEMENT_SCHEMA, schemaRefinementType);
		table.put(LawType.ACTION_REFINEMENT_SEQUENCE, sequenceRefinementType);
		table.put(LawType.SIMULATION_, simulationType);
		table.put(LawType.ACTION_REFINEMENT_SUBSTITUTION, substitutionRefinementType);
		table.put(LawType.ACTION_REFINEMENT_VARIABLE_BLOCKS,variableBlocksRefinementType);
		table.put(LawType.ZED_REFINEMENT_CALCULUS,zrcType);
	}
	
	public String getNameLawType(LawType tipoLei) {
		return table.get(tipoLei);
	}

	@Override
	public List<CircusLaw> createAll() {
		return null;
	}


}
