/*
 * Projeto: Circus Refine
 * 
 * Autores: Alessandro Gurgel <alessandro87@consiste.dimap.ufrn.br>
 * 			Cristiano Castro  <crisgc@consiste.dimap.ufrn.br>
 */
package circusRefine.core.crules.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.swing.JOptionPane;

/**
 * Gerenciador de mensagens para o pacote CRules.
 * 
 * @author Cristiano Castro
 */
public class MessagesManager {
	
	/** única instância do gerenciador de mensagens do CRules */
	private static MessagesManager instance;
	
	/**
	 * Acessa a instância do Gerenciador de mensagens do CRules
	 * 
	 * @return a instância do gerenciador de mensagens
	 */
	public static MessagesManager getInstance() {
		return MessagesManager.instance;
	}
	
	/**
	 * Inicia o servidor de mensagens.
	 * 
	 * @param language a linguagem o CRules
	 * @param country o paâs do CRules
	 */
	public static void initInstance(Locale local) {
		MessagesManager.instance = new MessagesManager(local);
	}
	
	/**
	 * Inicia o servidor de mensagens.
	 */
	public static void initInstance() {
		MessagesManager.instance = new MessagesManager();
	}

	/** Informação sobre a linguagem no qual o pacote CRules â usado */
	private Locale localization;
	
	/** Informação sobre o servidor de mensagens */
	private ResourceBundle messagesSource;

	/** 
	 * Inicia o servidor de mensagens informando
	 * 
	 * @param language a linguagem no qual o pacoteCRules serâ utilizado
	 * @param country o paâs da utilização
	 */
	public MessagesManager(Locale local) {
		this.setLocalization(local);
		this.setMessagesSource(ResourceBundle.getBundle("CRulesMessages", 
				this.getLocalization()));
	}
	
	/** 
	 * Inicia o servidor de mensagens com a linguagem padrâo
	 * 
	 */
	public MessagesManager() {
		this.setMessagesSource(ResourceBundle.getBundle("CRulesMessages"));
	}
	
	/**
	 * Acessa a informação de linguagem do CRules
	 * 
	 * @return o {@link Locale} da execução do CRules
	 */
	public Locale getLocalization() {
		return localization;
	}

	private void setLocalization(Locale localization) {
		this.localization = localization;
	}

	private ResourceBundle getMessagesSource() {
		return messagesSource;
	}

	private void setMessagesSource(ResourceBundle messagesSource) {
		this.messagesSource = messagesSource;
	}

	/**
	 * Retorna uma mensagem a ser gerada pelo CRules
	 * 
	 * @param messageCode o câdigo da mensagem ao usuario
	 * @return a {@link String} com a mensagem ao usuario 
	 */
	public String getMessage(String messageCode) throws 
			CRulesMissingMessageException {
		String message;
		try  {
			message = this.getMessagesSource().getString(messageCode);
		} catch (MissingResourceException e) {
			throw new CRulesMissingMessageException(e);
		}
		return message;
	}

}
